/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.walker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.walker.IXliffVisitor;
import net.sf.okapi.lib.xliff2.walker.VisitationContext;
import net.sf.okapi.lib.xliff2.walker.selector.PathSelectorUtils;
import net.sf.okapi.lib.xliff2.walker.selector.XliffWalkerPathSelector;
import net.sf.okapi.lib.xliff2.walker.strategy.DefaultXliffWalkerStrategy;
import net.sf.okapi.lib.xliff2.walker.strategy.IXliffWalkerStrategy;

public class XliffWalker {
    private final IXliffWalkerStrategy strategy;
    private Map<String, VisitPlaceAwareXliffVisitor<FileNode>> fileVisitors = new LinkedHashMap<String, VisitPlaceAwareXliffVisitor<FileNode>>();
    private Map<String, VisitPlaceAwareXliffVisitor<UnitNode>> unitVisitors = new LinkedHashMap<String, VisitPlaceAwareXliffVisitor<UnitNode>>();
    private Map<String, VisitPlaceAwareXliffVisitor<Segment>> segmentVisitors = new LinkedHashMap<String, VisitPlaceAwareXliffVisitor<Segment>>();
    private Set<String> linkedVisitorsSet = new LinkedHashSet<String>();

    public XliffWalker() {
        this.strategy = new DefaultXliffWalkerStrategy();
    }

    public XliffWalker(IXliffWalkerStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("A valid strategy object must be provided.");
        }
        this.strategy = strategy;
    }

    public void doWalk(XLIFFDocument xlf) {
        if (this.linkedVisitorsSet.size() == 0) {
            throw new IllegalStateException("At least one visitor must be added before running the xliff doc traversal");
        }
        this.strategy.doWalk(xlf, this);
    }

    public Iterator<String> visitorsIterator() {
        return this.linkedVisitorsSet.iterator();
    }

    public void setVisitors(List<IXliffVisitor<FileNode>> fileVisitors, List<IXliffVisitor<UnitNode>> unitVisitors, List<IXliffVisitor<Segment>> segmentVisitors) {
        if (fileVisitors != null) {
            for (IXliffVisitor<Object> iXliffVisitor : fileVisitors) {
                this.addFileVisitor(iXliffVisitor, new XliffWalkerPathSelector[0]);
            }
        }
        if (unitVisitors != null) {
            for (IXliffVisitor<Object> iXliffVisitor : unitVisitors) {
                this.addUnitVisitor(iXliffVisitor, new XliffWalkerPathSelector[0]);
            }
        }
        if (segmentVisitors != null) {
            for (IXliffVisitor<Object> iXliffVisitor : segmentVisitors) {
                this.addSegmentVisitor(iXliffVisitor, new XliffWalkerPathSelector[0]);
            }
        }
    }

    public void removeFileVisitor(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A valid ID must be provided.");
        }
        this.fileVisitors.remove(id);
        this.linkedVisitorsSet.remove(id);
    }

    public void removeUnitVisitor(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A valid ID must be provided.");
        }
        this.unitVisitors.remove(id);
        this.linkedVisitorsSet.remove(id);
    }

    public void removeSegmentVisitor(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A valid ID must be provided.");
        }
        this.segmentVisitors.remove(id);
        this.linkedVisitorsSet.remove(id);
    }

    public int getVisitorCount() {
        return this.linkedVisitorsSet.size();
    }

    public VisitPlaceAwareXliffVisitor<FileNode> getFileVisitor(String id) {
        return this.fileVisitors.get(id);
    }

    public VisitPlaceAwareXliffVisitor<UnitNode> getUnitVisitor(String id) {
        return this.unitVisitors.get(id);
    }

    public VisitPlaceAwareXliffVisitor<Segment> getSegmentVisitor(String id) {
        return this.segmentVisitors.get(id);
    }

    public List<IXliffVisitor<FileNode>> getFileNodeVisitors(String fileId) {
        ArrayList<IXliffVisitor<FileNode>> visitors = new ArrayList<IXliffVisitor<FileNode>>();
        block0: for (VisitPlaceAwareXliffVisitor<FileNode> visitor : this.fileVisitors.values()) {
            if (visitor.getSelectors() == null) {
                visitors.add(visitor);
                continue;
            }
            for (XliffWalkerPathSelector pathSelector : visitor.getSelectors()) {
                if (!PathSelectorUtils.containsFile(pathSelector, fileId)) continue;
                visitors.add(visitor);
                continue block0;
            }
        }
        return visitors;
    }

    public List<IXliffVisitor<UnitNode>> getUnitNodeVisitors(String fileId, String unitId) {
        ArrayList<IXliffVisitor<UnitNode>> visitors = new ArrayList<IXliffVisitor<UnitNode>>();
        block0: for (VisitPlaceAwareXliffVisitor<UnitNode> visitor : this.unitVisitors.values()) {
            if (visitor.getSelectors() == null) {
                visitors.add(visitor);
                continue;
            }
            for (XliffWalkerPathSelector pathSelector : visitor.getSelectors()) {
                if (!PathSelectorUtils.containsUnit(pathSelector, fileId, unitId)) continue;
                visitors.add(visitor);
                continue block0;
            }
        }
        return visitors;
    }

    public List<IXliffVisitor<Segment>> getSegmentVisitors(String fileId, String unitId, int segmentIndex) {
        ArrayList<IXliffVisitor<Segment>> visitors = new ArrayList<IXliffVisitor<Segment>>();
        block0: for (VisitPlaceAwareXliffVisitor<Segment> visitor : this.segmentVisitors.values()) {
            if (visitor.getSelectors() == null) {
                visitors.add(visitor);
                continue;
            }
            for (XliffWalkerPathSelector pathSelector : visitor.getSelectors()) {
                if (!PathSelectorUtils.containsSegment(pathSelector, fileId, unitId, segmentIndex)) continue;
                visitors.add(visitor);
                continue block0;
            }
        }
        return visitors;
    }

    public List<IXliffVisitor<FileNode>> getAllFileNodeVisitors() {
        return new ArrayList<IXliffVisitor<FileNode>>(this.fileVisitors.values());
    }

    public List<IXliffVisitor<UnitNode>> getAllUnitNodeVisitors() {
        return new ArrayList<IXliffVisitor<UnitNode>>(this.unitVisitors.values());
    }

    public List<IXliffVisitor<Segment>> getAllSegmentVisitors() {
        return new ArrayList<IXliffVisitor<Segment>>(this.segmentVisitors.values());
    }

    public String addFileVisitor(VisitPlaceAwareXliffVisitor<FileNode> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("A valid file visitor must be provided.");
        }
        String id = UUID.randomUUID().toString();
        this.fileVisitors.put(id, visitor);
        this.linkedVisitorsSet.add(id);
        return id;
    }

    public String addFileVisitor(IXliffVisitor<FileNode> visitor, XliffWalkerPathSelector ... pathSelectors) {
        if (visitor == null) {
            throw new IllegalArgumentException("A valid file visitor must be provided.");
        }
        return this.addFileVisitor(new VisitPlaceAwareXliffVisitor<FileNode>(visitor, pathSelectors));
    }

    public String addUnitVisitor(VisitPlaceAwareXliffVisitor<UnitNode> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("A valid unit visitor must be provided.");
        }
        String id = UUID.randomUUID().toString();
        this.unitVisitors.put(id, visitor);
        this.linkedVisitorsSet.add(id);
        return id;
    }

    public String addUnitVisitor(IXliffVisitor<UnitNode> visitor, XliffWalkerPathSelector ... pathSelectors) {
        if (visitor == null) {
            throw new IllegalArgumentException("A valid unit visitor must be provided.");
        }
        return this.addUnitVisitor(new VisitPlaceAwareXliffVisitor<UnitNode>(visitor, pathSelectors));
    }

    public String addSegmentVisitor(VisitPlaceAwareXliffVisitor<Segment> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("A valid segment visitor must be provided.");
        }
        String id = UUID.randomUUID().toString();
        this.segmentVisitors.put(id, visitor);
        this.linkedVisitorsSet.add(id);
        return id;
    }

    public String addSegmentVisitor(IXliffVisitor<Segment> visitor, XliffWalkerPathSelector ... pathSelectors) {
        if (visitor == null) {
            throw new IllegalArgumentException("A valid segment visitor must be provided.");
        }
        return this.addSegmentVisitor(new VisitPlaceAwareXliffVisitor<Segment>(visitor, pathSelectors));
    }

    public void removeVisitors() {
        this.fileVisitors.clear();
        this.unitVisitors.clear();
        this.segmentVisitors.clear();
        this.linkedVisitorsSet.clear();
    }

    public static class VisitPlaceAwareXliffVisitor<T>
    implements IXliffVisitor<T> {
        private final List<XliffWalkerPathSelector> selectors;
        private final IXliffVisitor<T> delegate;

        public VisitPlaceAwareXliffVisitor(IXliffVisitor<T> delegate, XliffWalkerPathSelector ... selectors) {
            this.delegate = delegate;
            this.selectors = selectors != null && selectors.length > 0 ? Arrays.asList(selectors) : null;
        }

        public List<XliffWalkerPathSelector> getSelectors() {
            return this.selectors;
        }

        @Override
        public void visit(T visitee, VisitationContext context) {
            this.delegate.visit(visitee, context);
        }
    }
}

