/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.changeTracking;

import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.changeTracking.Revision;
import net.sf.okapi.lib.xliff2.core.BaseList;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;

public class Revisions
extends BaseList<Revision>
implements IWithExtAttributes {
    public static final String TAG_NAME = "revisions";
    public static final String APPLIES_TO_ATTR_NAME = "appliesTo";
    public static final String REF_ATTR_NAME = "ref";
    public static final String CURRENT_VERSION_ATTR_NAME = "currentVersion";
    private String appliesTo;
    private String ref;
    private String currentVersion;
    private ExtAttributes xattrs;

    public Revisions() {
    }

    public Revisions(String appliesTo) {
        this.setAppliesTo(appliesTo);
    }

    public Revisions(Revisions original) {
        super(original);
    }

    public final void setAppliesTo(String appliesTo) {
        if (Util.isNoE(appliesTo)) {
            throw new IllegalArgumentException("'appliesTo' is a required attribute and cannot be null.");
        }
        if (!Util.isValidNmtoken(appliesTo)) {
            throw new IllegalArgumentException(String.format("The value of '%s' must be an NMTOKEN.", APPLIES_TO_ATTR_NAME));
        }
        this.appliesTo = appliesTo;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public void setRef(String ref) {
        if (ref != null && !Util.isValidNmtoken(ref)) {
            throw new IllegalArgumentException(String.format("The value of '%s' must be an NMTOKEN.", REF_ATTR_NAME));
        }
        this.ref = ref;
    }

    public String getRef() {
        return this.ref;
    }

    public void setCurrentVersion(String currentVersion) {
        if (currentVersion != null && !Util.isValidNmtoken(currentVersion)) {
            throw new IllegalArgumentException(String.format("The value of '%s' must be an NMTOKEN.", CURRENT_VERSION_ATTR_NAME));
        }
        this.currentVersion = currentVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    public ExtAttributes getExtAttributes() {
        if (this.xattrs == null) {
            this.xattrs = new ExtAttributes();
        }
        return this.xattrs;
    }

    @Override
    public void setExtAttributes(ExtAttributes attributes) {
        this.xattrs = attributes;
    }

    @Override
    public boolean hasExtAttribute() {
        return this.xattrs != null && !this.xattrs.isEmpty();
    }

    @Override
    public String getExtAttributeValue(String namespaceURI, String localName) {
        String xattrValue = null;
        if (this.hasExtAttribute()) {
            xattrValue = this.xattrs.getAttributeValue(namespaceURI, localName);
        }
        return xattrValue;
    }

    public String getOpeningTagName() {
        return "ctr:revisions";
    }

    public String getAttributesString() {
        StringBuilder attrs = new StringBuilder();
        attrs.append(" ");
        attrs.append(APPLIES_TO_ATTR_NAME);
        attrs.append("=\"");
        attrs.append(this.appliesTo);
        attrs.append("\"");
        if (this.ref != null && !this.ref.isEmpty()) {
            attrs.append(" ");
            attrs.append(REF_ATTR_NAME);
            attrs.append("=\"");
            attrs.append(this.ref);
            attrs.append("\"");
        }
        if (this.currentVersion != null && !this.currentVersion.isEmpty()) {
            attrs.append(" ");
            attrs.append(CURRENT_VERSION_ATTR_NAME);
            attrs.append("=\"");
            attrs.append(this.currentVersion);
            attrs.append("\"");
        }
        return attrs.toString();
    }

    public String getClosingTagName() {
        return "/ctr:revisions";
    }

    public String getCompleteOpeningTag() {
        StringBuilder openingTag = new StringBuilder();
        openingTag.append("<");
        openingTag.append("ctr:");
        openingTag.append(TAG_NAME);
        openingTag.append(" ");
        openingTag.append(APPLIES_TO_ATTR_NAME);
        openingTag.append("=\"");
        openingTag.append(this.appliesTo);
        openingTag.append("\"");
        if (this.ref != null && !this.ref.isEmpty()) {
            openingTag.append(" ");
            openingTag.append(REF_ATTR_NAME);
            openingTag.append("=\"");
            openingTag.append(this.ref);
            openingTag.append("\"");
        }
        if (this.currentVersion != null && !this.currentVersion.isEmpty()) {
            openingTag.append(" ");
            openingTag.append(CURRENT_VERSION_ATTR_NAME);
            openingTag.append("=\"");
            openingTag.append(this.currentVersion);
            openingTag.append("\"");
        }
        openingTag.append(">");
        return openingTag.toString();
    }

    public String getClosingTag() {
        return "</ctr:revisions>";
    }
}

