/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.validation;

import java.text.Normalizer;
import net.sf.okapi.lib.xliff2.validation.Rule;
import org.junit.Assert;
import org.junit.Test;

public class RuleTest {
    @Test
    public void testSimple() {
        Rule r = new Rule("startsWith", "a");
        r.prepare();
        Assert.assertTrue((r.getType() == Rule.Type.STARTSWITH ? 1 : 0) != 0);
        Assert.assertEquals((Object)"a", (Object)r.getData());
        Assert.assertTrue((boolean)r.isCaseSensitive());
        Assert.assertTrue((boolean)r.isEnabled());
        Assert.assertFalse((boolean)r.getExistsInSource());
        Assert.assertEquals((Object)Rule.Normalization.NFC, (Object)r.getNormalization());
        Assert.assertEquals((Object)"a", (Object)r.getEffectiveData());
        Assert.assertFalse((boolean)r.isInherited());
    }

    @Test
    public void testCopyConstructor() {
        Rule r = new Rule("startsWith", "b");
        r.setCaseSensitive(false);
        r.setEnabled(false);
        r.setExistsInSource(true);
        r.setNormalization(Rule.Normalization.NFD);
        r.setOccurs(3);
        r.setInherited(true);
        r.prepare();
        Rule r2 = new Rule(r);
        Assert.assertFalse((r == r2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)r2.isCaseSensitive());
        Assert.assertFalse((boolean)r2.isEnabled());
        Assert.assertTrue((boolean)r2.getExistsInSource());
        Assert.assertEquals((Object)Rule.Normalization.NFD, (Object)r2.getNormalization());
        Assert.assertEquals((long)3L, (long)r2.getOccurs());
        Assert.assertEquals((Object)"b", (Object)r2.getEffectiveData());
        Assert.assertEquals((Object)"b", (Object)r2.getData());
        Assert.assertTrue((boolean)r2.isInherited());
    }

    @Test
    public void testNormalizationNFCCaseSensitive() {
        String original = "\u00c4\ufb03n";
        String expected = Normalizer.normalize(original, Normalizer.Form.NFC);
        Rule r = new Rule("isPresent", original);
        r.prepare();
        Assert.assertEquals((Object)expected, (Object)r.getEffectiveData());
    }

    @Test
    public void testNormalizationNFDCaseSensitive() {
        String original = "\u00c4\ufb03n";
        String expected = Normalizer.normalize(original, Normalizer.Form.NFD);
        Rule r = new Rule("isPresent", original);
        r.setNormalization(Rule.Normalization.NFD);
        r.prepare();
        Assert.assertEquals((Object)expected, (Object)r.getEffectiveData());
    }

    @Test
    public void testNormalizationNoneCaseSensitive() {
        String original;
        String expected = original = "\u00c4\ufb03n";
        Rule r = new Rule("isPresent", original);
        r.setNormalization(Rule.Normalization.NONE);
        r.prepare();
        Assert.assertEquals((Object)expected, (Object)r.getEffectiveData());
    }

    @Test
    public void testNormalizationNFCNotCaseSensitive() {
        String original = "\u00c4\ufb03n";
        String expected = Normalizer.normalize(original.toLowerCase(), Normalizer.Form.NFC);
        Rule r = new Rule("isPresent", original);
        r.setCaseSensitive(false);
        r.prepare();
        Assert.assertEquals((Object)expected, (Object)r.getEffectiveData());
    }

    @Test
    public void testNormalizationNFDNotCaseSensitive() {
        String original = "\u00c4\ufb03n";
        String expected = Normalizer.normalize(original.toLowerCase(), Normalizer.Form.NFD);
        Rule r = new Rule("isPresent", original);
        r.setCaseSensitive(false);
        r.setNormalization(Rule.Normalization.NFD);
        r.prepare();
        Assert.assertEquals((Object)expected, (Object)r.getEffectiveData());
    }

    @Test
    public void testNormalizationNoneNotCaseSensitive() {
        String original = "\u00c4\ufb03n";
        String expected = original.toLowerCase();
        Rule r = new Rule("isPresent", original);
        r.setCaseSensitive(false);
        r.setNormalization(Rule.Normalization.NONE);
        r.prepare();
        Assert.assertEquals((Object)expected, (Object)r.getEffectiveData());
    }
}

