/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;

public class FileCompare {
    private final int BUFSIZ = 4096;
    private byte[] obuf = new byte[4096];
    private byte[] gbuf = new byte[4096];

    public boolean filesExactlyTheSame(String outputFilePath, String goldFilePath) {
        boolean bRslt = false;
        try {
            FileInputStream ois = new FileInputStream(new File(outputFilePath));
            FileInputStream gis = new FileInputStream(new File(goldFilePath));
            bRslt = this.filesExactlyTheSame(ois, gis);
        }
        catch (Exception e) {
            e.printStackTrace();
            bRslt = false;
        }
        return bRslt;
    }

    public boolean filesExactlyTheSame(URI outputFileURI, URI goldFileURI) {
        try {
            InputStream ois = outputFileURI.toURL().openStream();
            InputStream gis = goldFileURI.toURL().openStream();
            return this.filesExactlyTheSame(ois, gis);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean compareFilesPerLines(String outputFilePath, String goldFilePath, String encoding) {
        boolean bRslt = false;
        try {
            FileInputStream ois = new FileInputStream(new File(outputFilePath));
            FileInputStream gis = new FileInputStream(new File(goldFilePath));
            bRslt = this.compareFilesPerLines(ois, gis, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            bRslt = false;
        }
        return bRslt;
    }

    public boolean compareFilesPerLines(InputStream ois, InputStream gis, String encoding) {
        return this.compareFilesPerLines(ois, gis, encoding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareFilesPerLines(InputStream ois, InputStream gis, String encoding, boolean ignoreInitialEmptyLines) {
        BufferedReader obr = null;
        BufferedReader gbr = null;
        try {
            String gLine;
            String oLine;
            obr = new BufferedReader(new InputStreamReader(ois, encoding));
            gbr = new BufferedReader(new InputStreamReader(gis, encoding));
            boolean oFirstLine = true;
            boolean gFirstLine = true;
            do {
                oLine = obr.readLine();
                gLine = gbr.readLine();
                if (ignoreInitialEmptyLines) {
                    while (oFirstLine && oLine != null && oLine.equals("")) {
                        System.err.println("    NOTE: Ignoring initial blank line in out file." + gLine);
                        oLine = obr.readLine();
                    }
                    while (gFirstLine && gLine != null && gLine.equals("")) {
                        System.err.println("    NOTE: Ignoring initial blank line in gold file." + gLine);
                        gLine = gbr.readLine();
                    }
                    if (oFirstLine) {
                        oFirstLine = false;
                    }
                    if (gFirstLine) {
                        gFirstLine = false;
                    }
                }
                if (oLine == null) {
                    if (gLine != null) {
                        System.err.println("Extra line in gold file:" + gLine);
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                if (gLine != null) continue;
                System.err.println("Extra line in output file:" + oLine);
                boolean bl = false;
                return bl;
            } while (oLine.equals(gLine));
            System.err.println("Difference in line:");
            System.err.println(" out: \"" + oLine + "\"");
            System.err.println("gold: \"" + gLine + "\"");
            boolean bl = false;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (obr != null) {
                    obr.close();
                }
                if (gbr != null) {
                    gbr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filesExactlyTheSame(InputStream ois, InputStream gis) {
        try {
            int i;
            while (ois.available() > 0 && gis.available() > 0) {
                int gred;
                int ored = ois.read(this.obuf);
                if (ored != (gred = gis.read(this.gbuf))) {
                    System.err.println("Size difference in files.");
                    boolean bl = false;
                    return bl;
                }
                if (ored > 0) {
                    for (i = 0; i < ored; ++i) {
                        if (this.obuf[i] == this.gbuf[i]) continue;
                        System.err.println("Difference in content:");
                        int start = i - 20 < 0 ? 0 : i - 20;
                        int extra = i < 4085 ? 10 : 1;
                        String oText = new String(this.obuf, start, i - start + extra);
                        String gText = new String(this.gbuf, start, i - start + extra);
                        System.err.println(" out='" + oText + "'");
                        System.err.println("gold='" + gText + "'");
                        boolean bl = false;
                        return bl;
                    }
                    continue;
                }
                i = 1;
                return i != 0;
            }
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (gis != null) {
                    gis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

