/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.List;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.Provenance;
import net.sf.okapi.lib.xliff2.its.Provenances;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;

public class ProvenanceTest {
    @Test(expected=XLIFFException.class)
    public void testProvenanceToolToolRefConflict() {
        Provenance prov = new Provenance();
        prov.setTool("a");
        prov.setToolRef("b");
        prov.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testProvenanceOrgOrgRefConflict() {
        Provenance prov = new Provenance();
        prov.setOrg("a");
        prov.setOrgRef("b");
        prov.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testProvenancePersonPersonRefConflict() {
        Provenance prov = new Provenance();
        prov.setPerson("a");
        prov.setPersonRef("b");
        prov.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testProvenanceRevToolRevToolRefConflict() {
        Provenance prov = new Provenance();
        prov.setRevTool("a");
        prov.setRevToolRef("b");
        prov.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testProvenanceRevOrgRevOrgRefConflict() {
        Provenance prov = new Provenance();
        prov.setRevOrg("a");
        prov.setRevOrgRef("b");
        prov.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testProvenanceRevPersonRevPersonRefConflict() {
        Provenance prov = new Provenance();
        prov.setRevPerson("a");
        prov.setRevPersonRef("b");
        prov.validate();
    }

    @Test
    public void testInlineProvenance1() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source><mrk id=\"1\" type=\"its:any\" its:tool=\"tool1\" its:org=\"org1\" its:person=\"person1\" its:revTool=\"revtool1\" its:revOrg=\"revorg1\" its:revPerson=\"revperson1\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Provenance prov = (Provenance)am.getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"tool1", (Object)prov.getTool());
        Assert.assertEquals((Object)"org1", (Object)prov.getOrg());
        Assert.assertEquals((Object)"person1", (Object)prov.getPerson());
        Assert.assertEquals((Object)"revtool1", (Object)prov.getRevTool());
        Assert.assertEquals((Object)"revorg1", (Object)prov.getRevOrg());
        Assert.assertEquals((Object)"revperson1", (Object)prov.getRevPerson());
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
    }

    @Test
    public void testInlineProvenance2() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source><mrk id=\"1\" type=\"its:any\" its:toolRef=\"tool1\" its:orgRef=\"org1\" its:personRef=\"person1\" its:revToolRef=\"revtool1\" its:revOrgRef=\"revorg1\" its:revPersonRef=\"revperson1\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Provenance prov = (Provenance)am.getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"tool1", (Object)prov.getToolRef());
        Assert.assertEquals((Object)"org1", (Object)prov.getOrgRef());
        Assert.assertEquals((Object)"person1", (Object)prov.getPersonRef());
        Assert.assertEquals((Object)"revtool1", (Object)prov.getRevToolRef());
        Assert.assertEquals((Object)"revorg1", (Object)prov.getRevOrgRef());
        Assert.assertEquals((Object)"revperson1", (Object)prov.getRevPersonRef());
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
    }

    @Test
    public void testProvStandOff() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\" its:annotatorsRef=\"provenance|myTool1\">\n<unit id=\"id\">\n<its:provenanceRecords xml:id=\"p1\">\n <its:provenanceRecord toolRef=\"tool11Ref\" orgRef=\"org11Ref\" person=\"person11\" revTool=\"tool12\" revOrg=\"org12\" revPersonRef=\"person12Ref\" provRef=\"provRef11\"/>\n <its:provenanceRecord tool=\"tool21\" org=\"org21\" personRef=\"person21Ref\" revToolRef=\"tool22Ref\" revOrgRef=\"org22Ref\" revPerson=\"person22\" provRef=\"provRef22\"/>\n</its:provenanceRecords>\n<segment>\n<source><mrk id=\"1\" type=\"its:any\" its:provenanceRecordsRef=\"#its=p1\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Assert.assertFalse((boolean)am.hasExtAttribute());
        Assert.assertTrue((boolean)am.hasITSItem());
        Provenances provs = (Provenances)am.getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"p1", (Object)provs.getGroupId());
        Assert.assertEquals((long)2L, (long)provs.getList().size());
        Provenance prov = (Provenance)provs.getList().get(0);
        Assert.assertEquals((Object)"tool11Ref", (Object)prov.getToolRef());
        Assert.assertEquals((Object)"myTool1", (Object)prov.getAnnotatorRef());
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
    }

    @Test
    public void testProvStandOffOnUnit() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\" its:annotatorsRef=\"provenance|myTool1\">\n<unit id=\"id\" its:provenanceRecordsRef=\"#its=pr1\">\n<its:provenanceRecords xml:id=\"pr1\">\n <its:provenanceRecord orgRef=\"orgRef\"/>\n <its:provenanceRecord person=\"person\"/>\n</its:provenanceRecords>\n<segment>\n<source>source</source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        Assert.assertTrue((boolean)unit.hasITSItem());
        Assert.assertFalse((boolean)unit.hasExtAttribute());
        Provenances provs = (Provenances)unit.getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"pr1", (Object)provs.getGroupId());
        Assert.assertEquals((long)2L, (long)provs.getList().size());
        Provenance prov = (Provenance)provs.getList().get(0);
        Assert.assertEquals((Object)"orgRef", (Object)prov.getOrgRef());
        prov = (Provenance)provs.getList().get(1);
        Assert.assertEquals((Object)"person", (Object)prov.getPerson());
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
    }
}

