/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Notes;
import org.junit.Assert;
import org.junit.Test;

public class NotesTest {
    @Test
    public void testSimple() {
        Notes notes = new Notes();
        Assert.assertTrue((boolean)notes.isEmpty());
        Assert.assertEquals((long)0L, (long)notes.size());
        Note note = (Note)notes.add((Object)new Note());
        Assert.assertFalse((boolean)notes.isEmpty());
        Assert.assertEquals((long)1L, (long)notes.size());
        Assert.assertTrue((notes.get(0) == note ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() {
        Notes notes = new Notes();
        Note note1 = (Note)notes.add((Object)new Note("cont1"));
        Note note2 = (Note)notes.add((Object)new Note("cont2"));
        Assert.assertEquals((long)2L, (long)notes.size());
        notes.remove(0);
        Assert.assertEquals((long)1L, (long)notes.size());
        notes.remove((Object)note1);
        Assert.assertEquals((long)1L, (long)notes.size());
        notes.remove((Object)note2);
        Assert.assertEquals((long)0L, (long)notes.size());
    }

    @Test
    public void testSet() {
        Notes notes = new Notes();
        notes.add((Object)new Note("cont1"));
        Note note2 = (Note)notes.add((Object)new Note("cont2"));
        Assert.assertTrue((note2 == notes.get(1) ? 1 : 0) != 0);
        Note note3 = (Note)notes.set(1, (Object)new Note());
        Assert.assertTrue((note3 == notes.get(1) ? 1 : 0) != 0);
    }

    @Test
    public void testCopy() {
        Notes notes1 = new Notes();
        notes1.getExtAttributes().setAttribute("ns", "attr", "val");
        Note n1 = (Note)notes1.add((Object)new Note("cont1"));
        n1.setAppliesTo(Note.AppliesTo.SOURCE);
        n1.setCategory("cat1");
        n1.setPriority(5);
        n1.setId("n1");
        Note n2 = (Note)notes1.add((Object)new Note("cont2"));
        n2.setAppliesTo(Note.AppliesTo.TARGET);
        n2.setCategory("cat2");
        n2.setPriority(8);
        n2.setId("n2");
        Notes notes2 = new Notes(notes1);
        for (int i = 0; i < notes1.size(); ++i) {
            Note note1 = (Note)notes1.get(i);
            Note note2 = (Note)notes2.get(i);
            Assert.assertEquals((Object)note1.getAppliesTo(), (Object)note2.getAppliesTo());
            Assert.assertEquals((Object)note1.getCategory(), (Object)note2.getCategory());
            Assert.assertEquals((Object)note1.getText(), (Object)note2.getText());
            Assert.assertEquals((Object)note1.getId(), (Object)note2.getId());
            Assert.assertEquals((long)note1.getPriority(), (long)note2.getPriority());
            ExtAttribute ea1 = notes1.getExtAttributes().getAttribute("ns", "attr");
            ExtAttribute ea2 = notes2.getExtAttributes().getAttribute("ns", "attr");
            Assert.assertFalse((ea1 == ea2 ? 1 : 0) != 0);
            Assert.assertEquals((Object)ea1.getValue(), (Object)ea2.getValue());
        }
    }
}

