/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import org.junit.Assert;
import org.junit.Test;

public class GroupDataTest {
    @Test
    public void testDefaults() {
        StartGroupData sgd = new StartGroupData("id1");
        Assert.assertEquals((Object)"id1", (Object)sgd.getId());
        Assert.assertEquals((Object)true, (Object)sgd.getCanResegment());
        Assert.assertEquals((Object)true, (Object)sgd.getTranslate());
        Assert.assertEquals(null, (Object)sgd.getName());
        Assert.assertEquals(null, (Object)sgd.getType());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sgd.getSourceDir());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sgd.getTargetDir());
        Assert.assertTrue((boolean)sgd.getExtAttributes().isEmpty());
        Assert.assertEquals((long)0L, (long)sgd.getNoteCount());
        Assert.assertTrue((boolean)sgd.getExtElements().isEmpty());
    }

    @Test
    public void testChanges() {
        StartGroupData sgd = new StartGroupData("id1");
        sgd.setId("newId");
        Assert.assertEquals((Object)"newId", (Object)sgd.getId());
        sgd.setCanResegment(false);
        Assert.assertEquals((Object)false, (Object)sgd.getCanResegment());
        sgd.setTranslate(false);
        Assert.assertEquals((Object)false, (Object)sgd.getTranslate());
        sgd.setName("name");
        Assert.assertEquals((Object)"name", (Object)sgd.getName());
        sgd.setType("my:type");
        Assert.assertEquals((Object)"my:type", (Object)sgd.getType());
        sgd.setSourceDir(Directionality.RTL);
        Assert.assertEquals((Object)Directionality.RTL, (Object)sgd.getSourceDir());
        sgd.setTargetDir(Directionality.LTR);
        Assert.assertEquals((Object)Directionality.LTR, (Object)sgd.getTargetDir());
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidTypeValue() {
        StartGroupData sgd = new StartGroupData("id");
        sgd.setType("badValue");
    }
}

