/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.List;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.junit.Assert;
import org.junit.Test;

public class ExtElementTest {
    @Test
    public void testCreate() {
        ExtElement elem = new ExtElement(new QName("ns", "elem", "p"));
        Assert.assertEquals((Object)"ns", (Object)elem.getQName().getNamespaceURI());
        Assert.assertEquals((Object)"elem", (Object)elem.getQName().getLocalPart());
        Assert.assertEquals((Object)"p", (Object)elem.getQName().getPrefix());
    }

    @Test
    public void testAdd() {
        ExtElement elem = new ExtElement(new QName("ns", "elem", "p"));
        elem.addContent("content");
        Assert.assertEquals((Object)"content", (Object)elem.getFirstContent().getText());
        elem.addElement("elem2");
        Assert.assertEquals((Object)"ns", (Object)elem.getFirstElement().getQName().getNamespaceURI());
        Assert.assertEquals((Object)"elem2", (Object)elem.getFirstElement().getQName().getLocalPart());
        Assert.assertEquals((Object)"p", (Object)elem.getFirstElement().getQName().getPrefix());
        elem.addElement("ns2", "elem3", "q");
        ExtElement e = (ExtElement)elem.getChildren().get(2);
        Assert.assertEquals((Object)"ns2", (Object)e.getQName().getNamespaceURI());
        Assert.assertEquals((Object)"elem3", (Object)e.getQName().getLocalPart());
        Assert.assertEquals((Object)"q", (Object)e.getQName().getPrefix());
    }

    @Test
    public void testGetOrCreate() {
        Unit unit = new Unit("u1");
        unit.getExtElements().add("n1", "elem1", "my");
        ExtElements elems = unit.getExtElements();
        List list = elems.find("n1", "elem1");
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        ExtElement res1 = elems.getOrCreate("n1", "elem1", "abc");
        Assert.assertTrue((list.get(0) == res1 ? 1 : 0) != 0);
        ExtElement res2 = elems.getOrCreate("n2", "elem1", "xyz");
        list = elems.find("n2", "elem1");
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((list.get(0) == res2 ? 1 : 0) != 0);
    }
}

