/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.URIParser;
import org.junit.Assert;
import org.junit.Test;

public class URIParserTest {
    @Test
    public void testURL1() {
        URIParser up = new URIParser("#g=abc/u=123", "myFile", null, null);
        Assert.assertEquals((Object)"myFile", (Object)up.getFileId());
        Assert.assertEquals((Object)"abc", (Object)up.getGroupId());
        Assert.assertEquals((Object)"123", (Object)up.getUnitId());
    }

    @Test
    public void testURL2() {
        URIParser up = new URIParser("#u=123", "myFile", "g1", null);
        Assert.assertEquals((Object)"myFile", (Object)up.getFileId());
        Assert.assertEquals(null, (Object)up.getGroupId());
        Assert.assertEquals((Object)"123", (Object)up.getUnitId());
    }

    @Test
    public void testURL3() throws MalformedURLException {
        Assert.assertEquals((Object)"u=123", (Object)new URL("http://www.test.net/file.xlf#u=123").getRef());
        Assert.assertEquals((Object)"u=123/m1", (Object)new URL("http://www.test.net/file.xlf#u=123/m1").getRef());
        Assert.assertEquals((Object)"f=xyz/u=u1/d=d1", (Object)new URL("http://www.test.net/file.xlf#f=xyz/u=u1/d=d1").getRef());
    }

    @Test
    public void testURI1() throws URISyntaxException {
        Assert.assertEquals((Object)"", (Object)new URIParser("").getURI().toString());
        Assert.assertEquals((Object)"f=f1/u=123", (Object)new URIParser("http://www.test.net/file.xlf#f=f1/u=123").getURI().getFragment());
        Assert.assertEquals((Object)"f=f1/u=123/m1", (Object)new URIParser("http://www.test.net/file.xlf#f=f1/u=123/m1").getURI().getFragment());
        Assert.assertEquals((Object)"f=xyz/u=u1/d=d1", (Object)new URIParser("http://www.test.net/file.xlf#f=xyz/u=u1/d=d1").getURI().getFragment());
    }

    @Test
    public void testParser1() {
        URIParser up = new URIParser("");
        Assert.assertEquals((Object)"1", (Object)up.setURL("#1", "f1", null, "u1").getSourceInlineId());
        Assert.assertEquals((Object)"f=f1/u=u1/1", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)true, (Object)up.isXLIFF());
        Assert.assertEquals((Object)"2", (Object)up.setURL("#t=2", "f1", null, "u1").getTargetInlineId());
        Assert.assertEquals((Object)"f=f1/u=u1/t=2", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)true, (Object)up.isXLIFF());
        Assert.assertEquals((Object)"3", (Object)up.setURL("#u=3", "f1", null, null).getUnitId());
        Assert.assertEquals((Object)"f=f1/u=3", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)true, (Object)up.isXLIFF());
        Assert.assertEquals((Object)"4", (Object)up.setURL("#g=4", "f1", null, null).getGroupId());
        Assert.assertEquals((Object)"f=f1/g=4", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)true, (Object)up.isXLIFF());
        Assert.assertEquals((Object)"5", (Object)up.setURL("#n=5", "f1", null, null).getNoteId());
        Assert.assertEquals((Object)"f=f1/n=5", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)true, (Object)up.isXLIFF());
        Assert.assertEquals((Object)"6", (Object)up.setURL("#f=6", null, null, null).getFileId());
        Assert.assertEquals((Object)"f=6", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)"6bis", (Object)up.setURL("#/f=6bis", null, null, null).getFileId());
        Assert.assertEquals((Object)"/f=6bis", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)"7", (Object)up.setURL("#d=7", "f1", null, "1").getDataId());
        Assert.assertEquals((Object)"f=f1/u=1/d=7", (Object)up.complementReference().getURI().getFragment());
        up = new URIParser("#f=f1/g=g1/u=u1/1");
        Assert.assertEquals((Object)"f1", (Object)up.getFileId());
        Assert.assertEquals((Object)"g1", (Object)up.getGroupId());
        Assert.assertEquals((Object)"u1", (Object)up.getUnitId());
        Assert.assertEquals((Object)"1", (Object)up.getSourceInlineId());
        Assert.assertEquals((Object)true, (Object)up.isXLIFF());
    }

    @Test
    public void testParser2() {
        URIParser up = new URIParser("");
        Assert.assertEquals((Object)"1", (Object)up.setURL("#n=1", "f1", "g1", null).getNoteId());
        Assert.assertEquals((Object)"f=f1/g=g1/n=1", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)"1", (Object)up.setURL("#g=3/n=1", "f1", "g1", null).getNoteId());
        Assert.assertEquals((Object)"f=f1/g=3/n=1", (Object)up.complementReference().getURI().getFragment());
    }

    @Test
    public void testParser3() {
        URIParser up = new URIParser("");
        Assert.assertEquals(null, (Object)up.setURL("myFile.xml#id1", null, null, null).getSourceInlineId());
        Assert.assertEquals((Object)"id1", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)false, (Object)up.isXLIFF());
        Assert.assertEquals((Object)false, (Object)up.isFragmentOnly());
        Assert.assertEquals((Object)"id1", (Object)up.setURL("myFile.xml#f=f1/u=u1/id1", null, null, null).getSourceInlineId());
        Assert.assertEquals((Object)"f=f1/u=u1/id1", (Object)up.complementReference().getURI().getFragment());
        Assert.assertEquals((Object)true, (Object)up.isXLIFF());
        Assert.assertEquals((Object)false, (Object)up.isFragmentOnly());
    }

    @Test
    public void testRefTypeAndContainer() {
        URIParser up = new URIParser("#f=1/u=2");
        Assert.assertEquals((Object)"1", (Object)up.getFileId());
        Assert.assertEquals((Object)"2", (Object)up.getUnitId());
        Assert.assertEquals((long)117L, (long)up.getRefType());
        Assert.assertEquals((long)102L, (long)up.getRefContainer());
        up = new URIParser("#f=1/u=2/m1");
        Assert.assertEquals((Object)"2", (Object)up.getUnitId());
        Assert.assertEquals((Object)"m1", (Object)up.getSourceInlineId());
        Assert.assertEquals((long)115L, (long)up.getRefType());
        Assert.assertEquals((long)117L, (long)up.getRefContainer());
        up = new URIParser("#f=1/u=2/t=m1");
        Assert.assertEquals((Object)"2", (Object)up.getUnitId());
        Assert.assertEquals((Object)"m1", (Object)up.getTargetInlineId());
        Assert.assertEquals((long)116L, (long)up.getRefType());
        Assert.assertEquals((long)117L, (long)up.getRefContainer());
        up = new URIParser("#f=1/gls=term1");
        Assert.assertEquals((Object)"1", (Object)up.getFileId());
        Assert.assertEquals((Object)"term1", up.getExtensionInfo().getKey());
        Assert.assertEquals((long)120L, (long)up.getRefType());
        Assert.assertEquals((long)102L, (long)up.getRefContainer());
    }

    @Test
    public void testValidExtensions() {
        URIParser up = new URIParser("#u=u1/gls=id1", "f=f1", null, null);
        Assert.assertEquals((Object)"u1", (Object)up.getUnitId());
        Assert.assertEquals((Object)"id1", up.getExtensionInfo().getKey());
        Assert.assertEquals((Object)"urn:oasis:names:tc:xliff:glossary:2.0", ((List)up.getExtensionInfo().getValue()).get(0));
        up = new URIParser("#u=u1/mtc=c1", "f=f1", null, null);
        Assert.assertEquals((Object)"u1", (Object)up.getUnitId());
        Assert.assertEquals((Object)"c1", up.getExtensionInfo().getKey());
        Assert.assertEquals((Object)"urn:oasis:names:tc:xliff:matches:2.0", ((List)up.getExtensionInfo().getValue()).get(0));
    }

    @Test
    public void testValidCustomExtensions() {
        URIParser up = new URIParser("");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("myURI1", "p1");
        map.put("myURITwo", "p2");
        map.put("myURI1bis", "p1");
        up.addPrefixes(map);
        up.setURL("#f=f1/p2=x1", "f1", null, null);
        Assert.assertEquals((Object)"x1", up.getExtensionInfo().getKey());
        Assert.assertEquals((Object)"myURITwo", ((List)up.getExtensionInfo().getValue()).get(0));
    }

    @Test
    public void testNoFragmentId() {
        URIParser up = new URIParser("u=7");
        Assert.assertEquals(null, (Object)up.getUnitId());
        Assert.assertEquals((Object)"u=7", (Object)up.getURI().toString());
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidPrefix1() {
        new URIParser("#z=7");
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidPrefix2() {
        new URIParser("#u=1/GLS=2");
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidSpaces() {
        new URIParser("#z = 7");
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidRootedFragment() {
        new URIParser("#/u=myId");
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidNmtoken() {
        new URIParser("#u=not&nmtoken");
    }
}

