/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.walker.strategy;

import java.util.Iterator;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.walker.VisitationContext;
import net.sf.okapi.lib.xliff2.walker.XliffWalker;
import net.sf.okapi.lib.xliff2.walker.selector.PathSelectorUtils;
import net.sf.okapi.lib.xliff2.walker.selector.XliffWalkerPathSelector;
import net.sf.okapi.lib.xliff2.walker.strategy.IXliffWalkerStrategy;

public class PipelineXliffWalkerStrategy
implements IXliffWalkerStrategy {
    @Override
    public void doWalk(XLIFFDocument doc, XliffWalker walker) {
        if (doc == null) {
            throw new IllegalArgumentException("A valid XLIFF document must be provided.");
        }
        Iterator<String> visitorIterator = walker.visitorsIterator();
        while (visitorIterator.hasNext()) {
            String visitorId = visitorIterator.next();
            XliffWalker.VisitPlaceAwareXliffVisitor<FileNode> fileVisitor = walker.getFileVisitor(visitorId);
            if (fileVisitor != null) {
                PipelineXliffWalkerStrategy.doWalkFileNodes(doc, fileVisitor);
                continue;
            }
            XliffWalker.VisitPlaceAwareXliffVisitor<UnitNode> unitVisitor = walker.getUnitVisitor(visitorId);
            if (unitVisitor != null) {
                PipelineXliffWalkerStrategy.doWalkUnitNodes(doc, unitVisitor);
                continue;
            }
            XliffWalker.VisitPlaceAwareXliffVisitor<Segment> segmentVisitor = walker.getSegmentVisitor(visitorId);
            if (segmentVisitor == null) continue;
            PipelineXliffWalkerStrategy.doWalkSegments(doc, segmentVisitor);
        }
    }

    public static void doWalkFileNodes(XLIFFDocument doc, XliffWalker.VisitPlaceAwareXliffVisitor<FileNode> visitor) {
        if (visitor.getSelectors() != null) {
            for (XliffWalkerPathSelector fileNodePathSelector : visitor.getSelectors()) {
                String[] fileNodeIds;
                for (String fileNodeID : fileNodeIds = PathSelectorUtils.resolveFileNodeIds(doc, fileNodePathSelector)) {
                    FileNode fileNode = doc.getFileNode(fileNodeID);
                    visitor.visit(fileNode, new VisitationContext(fileNodeID, fileNode));
                }
            }
        } else {
            for (String fileNodeID : doc.getFileNodeIds()) {
                FileNode fileNode = doc.getFileNode(fileNodeID);
                visitor.visit(fileNode, new VisitationContext(fileNodeID, fileNode));
            }
        }
    }

    public static void doWalkUnitNodes(XLIFFDocument doc, XliffWalker.VisitPlaceAwareXliffVisitor<UnitNode> visitor) {
        if (visitor.getSelectors() != null) {
            for (XliffWalkerPathSelector fileNodePathSelector : visitor.getSelectors()) {
                String[] fileNodeIds;
                for (String fileNodeID : fileNodeIds = PathSelectorUtils.resolveFileNodeIds(doc, fileNodePathSelector)) {
                    FileNode fileNode = doc.getFileNode(fileNodeID);
                    for (XliffWalkerPathSelector unitNodePathSelector : fileNodePathSelector.getChildrenNodes()) {
                        UnitNode[] unitNodes;
                        for (UnitNode unitNode : unitNodes = PathSelectorUtils.resolveUnitNodes(fileNode, unitNodePathSelector)) {
                            visitor.visit(unitNode, new VisitationContext(fileNodeID, fileNode, unitNode));
                        }
                    }
                }
            }
        } else {
            for (String fileNodeID : doc.getFileNodeIds()) {
                FileNode fileNode = doc.getFileNode(fileNodeID);
                for (UnitNode unitNode : fileNode.getUnitNodes()) {
                    visitor.visit(unitNode, new VisitationContext(fileNodeID, fileNode, unitNode));
                }
            }
        }
    }

    public static void doWalkSegments(XLIFFDocument doc, XliffWalker.VisitPlaceAwareXliffVisitor<Segment> visitor) {
        if (visitor.getSelectors() != null) {
            for (XliffWalkerPathSelector fileNodePathSelector : visitor.getSelectors()) {
                String[] fileNodeIds;
                for (String fileNodeID : fileNodeIds = PathSelectorUtils.resolveFileNodeIds(doc, fileNodePathSelector)) {
                    FileNode fileNode = doc.getFileNode(fileNodeID);
                    for (XliffWalkerPathSelector unitNodePathSelector : fileNodePathSelector.getChildrenNodes()) {
                        UnitNode[] unitNodes;
                        for (UnitNode unitNode : unitNodes = PathSelectorUtils.resolveUnitNodes(fileNode, unitNodePathSelector)) {
                            for (XliffWalkerPathSelector segmentPathSelector : unitNodePathSelector.getChildrenNodes()) {
                                PathSelectorUtils.Pair<Integer, Segment>[] indexedSegments;
                                for (PathSelectorUtils.Pair<Integer, Segment> indexedSegment : indexedSegments = PathSelectorUtils.resolveSegments(unitNode, segmentPathSelector)) {
                                    visitor.visit(indexedSegment.getRight(), new VisitationContext(fileNodeID, fileNode, unitNode, indexedSegment.getLeft()));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (String fileNodeID : doc.getFileNodeIds()) {
                FileNode fileNode = doc.getFileNode(fileNodeID);
                for (UnitNode unitNode : fileNode.getUnitNodes()) {
                    Unit unit = unitNode.get();
                    int segmentIndex = 0;
                    for (Segment segment : unit.getSegments()) {
                        visitor.visit(segment, new VisitationContext(fileNodeID, fileNode, unitNode, segmentIndex));
                        ++segmentIndex;
                    }
                }
            }
        }
    }
}

