/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.reader;

import java.util.AbstractMap;
import java.util.List;
import net.sf.okapi.lib.xliff2.URIParser;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.ExtChildType;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.IWithExtElements;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.glossary.GlossEntry;
import net.sf.okapi.lib.xliff2.glossary.Translation;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.reader.Event;

public class URIContext
implements Cloneable {
    private String fileId;
    private String groupId;
    private String unitId;

    public URIContext clone() {
        URIContext tmp = new URIContext();
        tmp.setFileId(this.fileId);
        tmp.setGroupId(this.groupId);
        tmp.setUnitId(this.unitId);
        return tmp;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object matches(Event event, URIParser up) {
        String scope = up.getScope();
        if (scope.isEmpty()) {
            return null;
        }
        char refType = up.getRefType();
        Object obj = null;
        int i = 0;
        while (i < scope.length()) {
            switch (scope.charAt(i)) {
                case 'f': {
                    if (!up.getFileId().equals(this.fileId)) {
                        return null;
                    }
                    if (refType == 'f') {
                        return event.getResource();
                    }
                    if (!event.isMidFile() || up.getRefContainer() != 'f' || !(refType == 'n' ? (obj = URIContext.searchNotes(event.getMidFileData(), up.getNoteId())) != null : refType == 'x' && (obj = URIContext.searchExtensions(event.getMidFileData(), up.getExtensionInfo())) != null)) break;
                    return obj;
                }
                case 'g': {
                    if (!up.getGroupId().equals(this.groupId)) {
                        return null;
                    }
                    if (refType == 'g') {
                        return event.getResource();
                    }
                    if (!(refType == 'n' && up.getRefContainer() == 'g' ? (obj = URIContext.searchNotes(event.getStartGroupData(), up.getNoteId())) != null : refType == 'x' && up.getRefContainer() == 'g' && (obj = URIContext.searchExtensions(event.getStartGroupData(), up.getExtensionInfo())) != null)) break;
                    return obj;
                }
                case 'u': {
                    if (!up.getUnitId().equals(this.unitId)) {
                        return null;
                    }
                    switch (refType) {
                        case 'u': {
                            return event.getResource();
                        }
                        case 's': {
                            obj = URIContext.searchInlineSource(event.getUnit(), up.getSourceInlineId());
                            if (obj == null) break;
                            return obj;
                        }
                        case 't': {
                            obj = URIContext.searchInlineTarget(event.getUnit(), up.getTargetInlineId());
                            if (obj == null) break;
                            return obj;
                        }
                        case 'n': {
                            if (up.getRefContainer() != 'u' || (obj = URIContext.searchNotes(event.getUnit(), up.getNoteId())) == null) break;
                            return obj;
                        }
                        case 'x': {
                            if (up.getRefContainer() != 'u' || (obj = URIContext.searchExtensions(event.getUnit(), up.getExtensionInfo())) == null) break;
                            return obj;
                        }
                        case 'd': {
                            obj = URIContext.searchData(event.getUnit(), up.getDataId());
                            if (obj == null) break;
                            return obj;
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        return null;
    }

    public static Note searchNotes(IWithNotes parent, String id) {
        if (parent == null) {
            return null;
        }
        for (int i = 0; i < parent.getNoteCount(); ++i) {
            Note note = (Note)parent.getNotes().get(i);
            if (!id.equals(note.getId())) continue;
            return note;
        }
        return null;
    }

    public static Object searchInlineSource(Unit unit, String id) {
        for (Part part : unit) {
            if (!id.equals(part.getId())) continue;
            if (part.isSegment()) {
                return (Segment)part;
            }
            return part;
        }
        Tags markers = unit.getStore().getSourceTags();
        for (Tag m : markers) {
            if (!m.getId().equals(id)) continue;
            if (m.isMarker()) {
                return (MTag)m;
            }
            return (CTag)m;
        }
        return null;
    }

    public static Object searchInlineTarget(Unit unit, String id) {
        Tags markers = unit.getStore().getTargetTags();
        for (Tag m : markers) {
            if (!m.getId().equals(id)) continue;
            if (m.isMarker()) {
                return (MTag)m;
            }
            return (CTag)m;
        }
        return null;
    }

    public static Object searchUnit(Unit unit, AbstractMap.SimpleEntry<String, List<String>> extensionInfo) {
        Object obj;
        if (unit.hasMatch()) {
            for (Match match : unit.getMatches()) {
                for (String searchNs : extensionInfo.getValue()) {
                    if (!searchNs.equals("urn:oasis:names:tc:xliff:matches:2.0") || Util.compareAllowingNull(match.getId(), extensionInfo.getKey()) != 0) continue;
                    return match;
                }
                obj = URIContext.searchExtensions(match, extensionInfo);
                if (obj == null) continue;
                return obj;
            }
        }
        if (unit.hasGlossEntry()) {
            for (GlossEntry entry : unit.getGlossary()) {
                for (String searchNs : extensionInfo.getValue()) {
                    if (!searchNs.equals("urn:oasis:names:tc:xliff:glossary:2.0")) continue;
                    if (Util.compareAllowingNull(entry.getId(), extensionInfo.getKey()) == 0) {
                        return entry;
                    }
                    for (Translation trans : entry) {
                        if (Util.compareAllowingNull(trans.getId(), extensionInfo.getKey()) != 0) continue;
                        return trans;
                    }
                }
                obj = URIContext.searchExtensions(entry, extensionInfo);
                if (obj == null) continue;
                return obj;
            }
        }
        return URIContext.searchExtensions(unit, extensionInfo);
    }

    public static Object searchExtensions(IWithExtElements parent, AbstractMap.SimpleEntry<String, List<String>> extensionInfo) {
        ExtElements elems = parent.getExtElements();
        for (ExtElement elem : elems) {
            Object obj = URIContext.searchMatch(elem, extensionInfo);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static Object searchMatch(ExtElement elem, AbstractMap.SimpleEntry<String, List<String>> extensionInfo) {
        for (String searchNs : extensionInfo.getValue()) {
            if (!searchNs.equals(elem.getQName().getNamespaceURI())) continue;
            ExtAttributes attrs = elem.getExtAttributes();
            ExtAttribute attr = attrs.getAttribute("", "id");
            if (attr != null && extensionInfo.getKey().equals(attr.getValue())) {
                return elem;
            }
            attr = attrs.getAttribute("http://www.w3.org/XML/1998/namespace", "id");
            if (attr == null || !extensionInfo.getKey().equals(attr.getValue())) continue;
            return elem;
        }
        for (IExtChild child : elem.getChildren()) {
            Object obj;
            if (child.getType() != ExtChildType.ELEMENT || (obj = URIContext.searchMatch((ExtElement)child, extensionInfo)) == null) continue;
            return obj;
        }
        return null;
    }

    public static Object searchData(Unit unit, String dataId) {
        CTag cm;
        Tags markers = unit.getStore().getSourceTags();
        for (Tag m : markers) {
            if (m.isMarker() || !(cm = (CTag)m).getDataRef().equals(dataId)) continue;
            return cm;
        }
        markers = unit.getStore().getTargetTags();
        for (Tag m : markers) {
            if (m.isMarker() || !(cm = (CTag)m).getDataRef().equals(dataId)) continue;
            return cm;
        }
        return null;
    }
}

