/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.reader;

import net.sf.okapi.lib.xliff2.core.InsingnificantPartData;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.URIContext;

public class Event {
    private EventType type;
    private Object object;
    private URIContext uriCtx;

    public Event(EventType type, URIContext uriCtx) {
        this.type = type;
        this.uriCtx = uriCtx;
    }

    public Event(EventType type, URIContext uriCtx, Object object) {
        this.type = type;
        this.uriCtx = uriCtx;
        this.object = object;
    }

    public EventType getType() {
        return this.type;
    }

    public URIContext getURIContext() {
        return this.uriCtx;
    }

    public boolean isStartDocument() {
        return this.type == EventType.START_DOCUMENT;
    }

    public boolean isEndDocument() {
        return this.type == EventType.END_DOCUMENT;
    }

    public boolean isStartXliff() {
        return this.type == EventType.START_XLIFF;
    }

    public StartXliffData getStartXliffData() {
        return (StartXliffData)this.object;
    }

    public boolean isEndXliff() {
        return this.type == EventType.END_XLIFF;
    }

    public boolean isStartFile() {
        return this.type == EventType.START_FILE;
    }

    public StartFileData getStartFileData() {
        return (StartFileData)this.object;
    }

    public boolean isMidFile() {
        return this.type == EventType.MID_FILE;
    }

    public MidFileData getMidFileData() {
        return (MidFileData)this.object;
    }

    public boolean isEndFile() {
        return this.type == EventType.END_FILE;
    }

    public boolean isSkeleton() {
        return this.type == EventType.SKELETON;
    }

    public Skeleton getSkeletonData() {
        return (Skeleton)this.object;
    }

    public boolean isStartGroup() {
        return this.type == EventType.START_GROUP;
    }

    public StartGroupData getStartGroupData() {
        return (StartGroupData)this.object;
    }

    public boolean isEndGroup() {
        return this.type == EventType.END_GROUP;
    }

    public boolean isUnit() {
        return this.type == EventType.TEXT_UNIT;
    }

    public Unit getUnit() {
        return (Unit)this.object;
    }

    public InsingnificantPartData getInsingnificantPartData() {
        return (InsingnificantPartData)this.object;
    }

    public Object getResource() {
        return this.object;
    }
}

