/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.IWithStore;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;

public class Store {
    private final IWithStore parent;
    private Tags srcTags;
    private Tags trgTags;
    private int lastSuggested;
    private int lastSegSuggested;
    private transient Map<String, String> map;

    public Store(IWithStore parent) {
        if (parent == null) {
            throw new InvalidParameterException("Parent parameter must not be null.");
        }
        this.parent = parent;
    }

    public boolean hasCTagWithData() {
        if (this.srcTags != null && this.srcTags.hasCTagWithData()) {
            return true;
        }
        return this.trgTags != null && this.trgTags.hasCTagWithData();
    }

    public boolean hasSourceTag() {
        return this.srcTags != null && this.srcTags.size() > 0;
    }

    public boolean hasTargetTag() {
        return this.trgTags != null && this.trgTags.size() > 0;
    }

    public Tags getSourceTags() {
        if (this.srcTags == null) {
            this.srcTags = new Tags(this);
        }
        return this.srcTags;
    }

    public Tags getTargetTags() {
        if (this.trgTags == null) {
            this.trgTags = new Tags(this);
        }
        return this.trgTags;
    }

    public void calculateDataToIdsMap() {
        CTag code;
        String tmp;
        this.map = new LinkedHashMap<String, String>();
        int mapId = 0;
        if (this.srcTags != null) {
            for (Tag tag : this.srcTags) {
                if (tag.isMarker() || (tmp = (code = (CTag)tag).getData()) == null || tmp.isEmpty() || this.map.containsKey(tmp = tmp + code.getDataDir().getPrefix())) continue;
                this.map.put(tmp, "d" + String.valueOf(++mapId));
            }
        }
        if (this.trgTags != null) {
            for (Tag tag : this.trgTags) {
                if (tag.isMarker() || (tmp = (code = (CTag)tag).getData()) == null || tmp.isEmpty() || this.map.containsKey(tmp = tmp + code.getDataDir().getPrefix())) continue;
                this.map.put(tmp, "d" + String.valueOf(++mapId));
            }
        }
    }

    public void setOutsideRepresentationMap(Map<String, String> map) {
        this.map = map;
    }

    public Map<String, String> getOutsideRepresentationMap() {
        return this.map;
    }

    public String getIdForData(CTag ctag) {
        String key;
        if (this.map == null) {
            this.calculateDataToIdsMap();
        }
        if (!this.map.containsKey(key = (ctag.getData() == null ? "" : ctag.getData()) + ctag.getDataDir().getPrefix())) {
            this.calculateDataToIdsMap();
            if (!this.map.containsKey(key)) {
                throw new XLIFFException(String.format("No id found for the original data '%s'.", ctag.getData()));
            }
        }
        return this.map.get(key);
    }

    public Tag getTag(String id, TagType tagType) {
        if (this.srcTags != null) {
            for (Tag tag : this.srcTags) {
                if (!id.equals(tag.getId()) || tag.getTagType() != tagType) continue;
                return tag;
            }
        }
        if (this.trgTags != null) {
            for (Tag tag : this.trgTags) {
                if (!id.equals(tag.getId()) || tag.getTagType() != tagType) continue;
                return tag;
            }
        }
        return null;
    }

    public boolean isIdUsedInTags(String id) {
        return this.getTag(id) != null;
    }

    public boolean isIdUsed(String id) {
        return this.parent.isIdUsed(id);
    }

    public Tag getTag(String id) {
        if (this.srcTags != null) {
            for (Tag tag : this.srcTags) {
                if (!id.equals(tag.getId())) continue;
                return tag;
            }
        }
        if (this.trgTags != null) {
            for (Tag tag : this.trgTags) {
                if (!id.equals(tag.getId())) continue;
                return tag;
            }
        }
        return null;
    }

    public String suggestId(boolean forSegment) {
        String id;
        while (this.parent.isIdUsed(id = forSegment ? "s" + String.valueOf(++this.lastSegSuggested) : String.valueOf(++this.lastSuggested))) {
        }
        return id;
    }

    public Directionality getSourceDir() {
        return this.parent.getSourceDir();
    }

    public void setSourceDir(Directionality dir) {
        this.parent.setSourceDir(dir);
    }

    public Directionality getTargetDir() {
        return this.parent.getTargetDir();
    }

    public void setTargetDir(Directionality dir) {
        this.parent.setTargetDir(dir);
    }

    public IWithStore getParent() {
        return this.parent;
    }
}

