/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.URIPrefixes;
import net.sf.okapi.lib.xliff2.Util;

public class URIParser {
    private final URIPrefixes uriPrefixes;
    private URI uri;
    private String contextFileId;
    private String contextGroupId;
    private String contextUnitId;
    private char originator;
    private String fileId;
    private String groupId;
    private String unitId;
    private String noteId;
    private String srcInlineId;
    private String trgInlineId;
    private String dataId;
    private boolean external;
    private AbstractMap.SimpleEntry<String, List<String>> extensionId;
    private String scope;
    private boolean errorOnUnknownPrefix = true;

    public URIParser() {
        this.uriPrefixes = new URIPrefixes(null);
        this.reset();
    }

    public URIParser(File extraPrefixes) {
        this.uriPrefixes = new URIPrefixes(extraPrefixes);
        this.reset();
    }

    public URIParser(String urilOrFragment) {
        this(urilOrFragment, null, null, null);
    }

    public URIParser(String urilOrFragment, String contextFileId, String contextGroupId, String contextUnitId) {
        this.uriPrefixes = new URIPrefixes();
        this.setURL(urilOrFragment, contextFileId, contextGroupId, contextUnitId);
    }

    public String toString() {
        if (this.uri == null) {
            return "null";
        }
        return this.uri.toString();
    }

    public void setErrorOnUnknownPrefix(boolean errorOnUnknownPrefix) {
        this.errorOnUnknownPrefix = errorOnUnknownPrefix;
    }

    public boolean getErrorOnUnknownPrefix() {
        return this.errorOnUnknownPrefix;
    }

    public void addPrefixes(Map<String, String> map) {
        this.uriPrefixes.add(map);
    }

    public URIParser setURL(String urilOrFragment) {
        return this.setURL(urilOrFragment, null, null, null);
    }

    public URIParser setURL(String urilOrFragment, String contextFileId, String contextGroupId, String contextUnitId) {
        this.contextFileId = contextFileId;
        this.contextGroupId = contextGroupId;
        this.contextUnitId = contextUnitId;
        if ((contextUnitId != null || contextGroupId != null) && contextFileId == null) {
            throw new InvalidParameterException("Context file id must be set when a context unit/group id is set.");
        }
        this.originator = contextUnitId != null ? (char)117 : (contextGroupId != null ? (char)103 : (contextFileId != null ? (char)102 : (char)95));
        this.parse(urilOrFragment);
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    private void reset() {
        this.dataId = null;
        this.trgInlineId = null;
        this.srcInlineId = null;
        this.noteId = null;
        this.unitId = null;
        this.groupId = null;
        this.fileId = null;
        this.extensionId = null;
        this.external = false;
        this.uri = null;
        this.scope = "";
    }

    private void parse(String urilOrFragment) {
        String[] parts;
        this.reset();
        try {
            this.uri = new URI(urilOrFragment);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException(e.getLocalizedMessage());
        }
        String path = this.uri.getPath();
        String frag = this.uri.getFragment();
        if (!Util.isNoE(path)) {
            this.external = true;
            if (!Util.isNoE(frag) && !frag.contains("f=")) {
                return;
            }
        }
        if (frag == null) {
            return;
        }
        if (frag.indexOf(32) != -1) {
            throw new InvalidParameterException("Spaces not allowed in fragment identifier.");
        }
        boolean absolute = false;
        if (frag.startsWith("/")) {
            absolute = true;
            frag = frag.substring(1);
        }
        block18: for (String part : parts = frag.split("/", 0)) {
            int n = part.indexOf(61);
            if (n == -1) {
                this.srcInlineId = this.check(this.srcInlineId, part, null, 's', frag);
                this.scope = this.scope + "s";
                continue;
            }
            String prefix = part.substring(0, n);
            String value = part.substring(n + 1);
            switch (prefix) {
                case "f": {
                    this.fileId = this.check(this.fileId, value, prefix, 'f', frag);
                    this.scope = this.scope + "f";
                    continue block18;
                }
                case "g": {
                    this.groupId = this.check(this.groupId, value, prefix, 'g', frag);
                    this.scope = this.scope + "g";
                    continue block18;
                }
                case "u": {
                    this.unitId = this.check(this.unitId, value, prefix, 'u', frag);
                    this.scope = this.scope + "u";
                    continue block18;
                }
                case "n": {
                    this.noteId = this.check(this.noteId, value, prefix, 'n', frag);
                    this.scope = this.scope + "n";
                    continue block18;
                }
                case "t": {
                    this.trgInlineId = this.check(this.trgInlineId, value, prefix, 't', frag);
                    this.scope = this.scope + "t";
                    continue block18;
                }
                case "d": {
                    this.dataId = this.check(this.dataId, value, prefix, 'd', frag);
                    this.scope = this.scope + "d";
                    continue block18;
                }
                default: {
                    if (prefix.length() < 2) {
                        throw new InvalidParameterException(String.format("The module or extension prefix '%s' must be longer than 1 character.", prefix));
                    }
                    if (!Util.isValidNmtoken(prefix)) {
                        throw new InvalidParameterException(String.format("The module or extension prefix '%s' is not an NMTOKEN.", prefix));
                    }
                    List<String> uris = this.uriPrefixes.resolve(prefix);
                    if (uris == null && this.errorOnUnknownPrefix) {
                        throw new InvalidParameterException(String.format("The prefix '%s' in '%s' is not recognized.\nRecognized prefixes are: f, g, u, n, d, t and the following modules or extension prefixes '%s'.", prefix, frag, this.uriPrefixes.get().toString()));
                    }
                    this.check(this.extensionId == null ? null : this.extensionId.getKey(), value, prefix, 'x', frag);
                    this.extensionId = new AbstractMap.SimpleEntry<String, List<String>>(value, uris);
                    this.scope = this.scope + "x";
                }
            }
        }
        if (absolute && this.fileId == null) {
            throw new InvalidParameterException("An absolute fragment identifier without a file selector is invalid.");
        }
        if (this.srcInlineId != null || this.trgInlineId != null || this.dataId != null) {
            if (this.unitId == null) {
                this.unitId = this.contextUnitId;
            }
            if (this.unitId == null) {
                throw new InvalidParameterException(String.format("The un-prefixed selectors or 't' or 'd' selectors require a specified or context unit id ('%s').", frag));
            }
        }
        if (this.unitId != null || this.groupId != null) {
            if (this.fileId == null) {
                this.fileId = this.contextFileId;
            }
            if (this.fileId == null) {
                throw new InvalidParameterException(String.format("The 'g' or 'u' selectors require a specified or context file id ('%s').", frag));
            }
        }
        if (this.noteId != null || this.extensionId != null) {
            if (this.fileId == null) {
                this.fileId = this.contextFileId;
            }
            if (this.groupId == null) {
                this.groupId = this.contextGroupId;
            }
            if (this.unitId == null) {
                this.unitId = this.contextUnitId;
            }
            if (this.fileId == null && this.groupId == null && this.fileId == null) {
                throw new InvalidParameterException(String.format("The 'n' selectors or the modules or extensions selectors require a specified or context id for either file, group or unit ('%s').", frag));
            }
        }
    }

    public URIParser complementReference() {
        StringBuilder sb = new StringBuilder(this.uri.getFragment());
        switch (this.getRefType()) {
            case 'f': {
                break;
            }
            case 'g': 
            case 'u': {
                if (this.getRefContainer() != '_') break;
                sb.insert(0, "f=" + this.fileId + "/");
                break;
            }
            case 'n': 
            case 'x': {
                if (this.getRefContainer() == '_') {
                    if (this.originator == 'u') {
                        sb.insert(0, "u=" + this.unitId + "/");
                    } else if (this.originator == 'g') {
                        sb.insert(0, "g=" + this.groupId + "/");
                    }
                }
                if (this.uri.getFragment() == null || this.uri.getFragment().contains("f=")) break;
                sb.insert(0, "f=" + this.fileId + "/");
                break;
            }
            case 'd': 
            case 's': 
            case 't': {
                if (this.getRefContainer() != '_') break;
                sb.insert(0, "u=" + this.unitId + "/");
                sb.insert(0, "f=" + this.fileId + "/");
                break;
            }
        }
        String tmp = this.uri.toString();
        int n = tmp.indexOf(35);
        if (n != -1) {
            tmp = tmp.substring(0, n + 1) + sb.toString();
            this.parse(tmp);
        }
        return this;
    }

    private String check(String current, String value, String prefix, char selectorType, String frag) {
        if (current != null) {
            if (prefix == null) {
                throw new InvalidParameterException(String.format("Duplicated un-prefixed selector in '%s'.", frag));
            }
            throw new InvalidParameterException(String.format("Duplicated selector '%s' in '%s'.", prefix, frag));
        }
        boolean allowed = true;
        if (!this.scope.endsWith("f")) {
            if (this.scope.endsWith("g")) {
                allowed = "f".indexOf(selectorType) == -1;
            } else if (this.scope.endsWith("u")) {
                allowed = "fg".indexOf(selectorType) == -1;
            } else if (!this.scope.isEmpty()) {
                allowed = false;
            }
        }
        if (!allowed) {
            if (prefix == null) {
                throw new InvalidParameterException(String.format("The un-prefixed selector is at an invalid position '%s'", frag));
            }
            throw new InvalidParameterException(String.format("The selector with the prefix '%s' is at an invalid position in '%s'", prefix, frag));
        }
        if (!Util.isValidNmtoken(value)) {
            throw new InvalidParameterException(String.format("The id '%s' is not a valid NMTOKEN.", value));
        }
        return value;
    }

    public boolean isFragmentOnly() {
        return !this.external;
    }

    public boolean isXLIFF() {
        return !this.scope.isEmpty();
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public String getNoteId() {
        return this.noteId;
    }

    public String getSourceInlineId() {
        return this.srcInlineId;
    }

    public String getTargetInlineId() {
        return this.trgInlineId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public String getContextFileId() {
        return this.contextFileId;
    }

    public String getContextGroupId() {
        return this.contextGroupId;
    }

    public String getContextUnitId() {
        return this.contextUnitId;
    }

    public AbstractMap.SimpleEntry<String, List<String>> getExtensionInfo() {
        return this.extensionId;
    }

    public String getScope() {
        return this.scope;
    }

    public char getRefType() {
        if (this.scope.isEmpty()) {
            return '_';
        }
        return this.scope.charAt(this.scope.length() - 1);
    }

    public char getRefContainer() {
        if (this.scope.length() < 2) {
            return '_';
        }
        return this.scope.charAt(this.scope.length() - 2);
    }
}

