/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.glossary;

import java.util.List;
import net.sf.okapi.lib.xliff2.URIParser;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.glossary.Definition;
import net.sf.okapi.lib.xliff2.glossary.GlossEntry;
import net.sf.okapi.lib.xliff2.glossary.Glossary;
import net.sf.okapi.lib.xliff2.glossary.Term;
import net.sf.okapi.lib.xliff2.glossary.Translation;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;

public class GlossaryTest {
    @Test
    public void testCreation() {
        Glossary gloss = new Glossary();
        Assert.assertTrue((boolean)gloss.isEmpty());
    }

    @Test
    public void testCopyConstruct() {
        Glossary gloss1 = new Glossary();
        gloss1.add((Object)this.createEntry());
        Glossary gloss2 = new Glossary(gloss1);
        Assert.assertFalse((gloss2 == gloss1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((GlossEntry)gloss1.get(0)).getTerm().getText(), (Object)((GlossEntry)gloss2.get(0)).getTerm().getText());
    }

    @Test
    public void testReadGlossaryThenWrite() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<gls:glossary xmlns:gls=\"urn:oasis:names:tc:xliff:glossary:2.0\" xmlns:my=\"myNamespace\">\n<gls:glossEntry id=\"g1\" ref=\"#m1\" xmlns:my=\"myNamespace\" my:attr=\"value\">\n<gls:term source=\"term1-source\">term1</gls:term>\n<gls:definition>def</gls:definition>\n</gls:glossEntry>\n<gls:glossEntry id=\"g2\" ref=\"#m1\" my:attr1=\"value1\">\n<gls:term source=\"term2-source\">term2</gls:term>\n<gls:translation id=\"g2-t1\" ref=\"#t=m2\" source=\"some-place\" my:attr2=\"value2\">trans2-1</gls:translation>\n<gls:definition source=\"def2-source\">def2</gls:definition>\n<my:elem xmlns:my=\"myNamespace\">data</my:elem>\n</gls:glossEntry>\n</gls:glossary>\n<segment>\n<source><mrk id=\"m1\" type=\"term\">Text</mrk></source>\n<target><mrk id=\"m2\" type=\"term\">trans2-1</mrk></target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        Glossary gloss = unit.getGlossary();
        GlossEntry entry1 = (GlossEntry)gloss.get(0);
        Assert.assertEquals((Object)"term1", (Object)entry1.getTerm().getText());
        Assert.assertEquals((Object)"term1-source", (Object)entry1.getTerm().getSource());
        GlossEntry entry2 = (GlossEntry)gloss.get(1);
        Assert.assertEquals((Object)"term2", (Object)entry2.getTerm().getText());
        Assert.assertEquals((Object)"term2-source", (Object)entry2.getTerm().getSource());
        GlossEntry entry3 = new GlossEntry(entry2);
        entry3.setId("g2-clone");
        ((Translation)entry3.getTranslations().get(0)).setId("g2-t1-clone");
        gloss.add((Object)entry3);
        String output = U.writeEvents(events);
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<gls:glossary xmlns:gls=\"urn:oasis:names:tc:xliff:glossary:2.0\">\n<gls:glossEntry id=\"g1\" ref=\"#m1\" xmlns:my=\"myNamespace\" my:attr=\"value\">\n<gls:term source=\"term1-source\">term1</gls:term>\n<gls:definition>def</gls:definition>\n</gls:glossEntry>\n<gls:glossEntry id=\"g2\" ref=\"#m1\" xmlns:my=\"myNamespace\" my:attr1=\"value1\">\n<gls:term source=\"term2-source\">term2</gls:term>\n<gls:translation id=\"g2-t1\" ref=\"#t=m2\" source=\"some-place\" my:attr2=\"value2\">trans2-1</gls:translation>\n<gls:definition source=\"def2-source\">def2</gls:definition>\n<my:elem>data</my:elem>\n</gls:glossEntry>\n<gls:glossEntry id=\"g2-clone\" ref=\"#m1\" xmlns:my=\"myNamespace\" my:attr1=\"value1\">\n<gls:term source=\"term2-source\">term2</gls:term>\n<gls:translation id=\"g2-t1-clone\" ref=\"#t=m2\" source=\"some-place\" my:attr2=\"value2\">trans2-1</gls:translation>\n<gls:definition source=\"def2-source\">def2</gls:definition>\n<my:elem>data</my:elem>\n</gls:glossEntry>\n</gls:glossary>\n<segment>\n<source><mrk id=\"m1\" type=\"term\">Text</mrk></source>\n<target><mrk id=\"m2\" type=\"term\">trans2-1</mrk></target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)output);
        U.getEvents(output);
    }

    @Test
    public void testGlossaryInDocument() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<gls:glossary xmlns:gls=\"urn:oasis:names:tc:xliff:glossary:2.0\" xmlns:my=\"myNamespace\">\n<gls:glossEntry id=\"g1\" ref=\"#m1\" xmlns:my=\"myNamespace\" my:attr=\"value\">\n<gls:term source=\"term1-source\">term1</gls:term>\n<gls:definition>def</gls:definition>\n</gls:glossEntry>\n<gls:glossEntry id=\"g2\" ref=\"#m1\" my:attr1=\"value1\">\n<gls:term source=\"term2-source\">term2</gls:term>\n<gls:translation id=\"g2-t1\" ref=\"#t=m2\" source=\"some-place\" my:attr2=\"value2\">trans2-1</gls:translation>\n<gls:definition source=\"def2-source\">def2</gls:definition>\n<my:elem xmlns:my=\"myNamespace\">data</my:elem>\n</gls:glossEntry>\n</gls:glossary>\n<segment>\n<source><mrk id=\"m1\" type=\"term\">Text</mrk></source>\n<target><mrk id=\"m2\" type=\"term\">trans2-1</mrk></target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(text, 255);
        URIParser up = new URIParser("#/f=f1/u=id/gls=g1");
        Object obj = doc.fetchReference(up);
        Assert.assertNotNull((Object)obj);
        GlossEntry entry = (GlossEntry)obj;
        Assert.assertEquals((Object)"g1", (Object)entry.getId());
        up.setURL("#/f=f1/u=id/gls=g2-t1");
        obj = doc.fetchReference(up);
        Assert.assertNotNull((Object)obj);
        Translation trans = (Translation)obj;
        Assert.assertEquals((Object)"g2-t1", (Object)trans.getId());
    }

    @Test
    public void testCreateTranslations() {
        GlossEntry ge = new GlossEntry();
        ge.setId("id");
        ge.setTerm(new Term("term")).setSource("term-source");
        ge.getTranslations().add(new Translation("trans1"));
        ge.addTranslation("trans2").setRef("ref2");
        Assert.assertEquals((Object)"term", (Object)ge.getTerm().getText());
        Assert.assertEquals((Object)"term-source", (Object)ge.getTerm().getSource());
        Assert.assertEquals((Object)"trans1", (Object)((Translation)ge.getTranslations().get(0)).getText());
        Assert.assertEquals((Object)"trans2", (Object)((Translation)ge.getTranslations().get(1)).getText());
        Assert.assertEquals((Object)"ref2", (Object)((Translation)ge.getTranslations().get(1)).getRef());
        Translation t = (Translation)ge.getTranslations().get(1);
        t.setText("newTrans");
        Assert.assertEquals((Object)"newTrans", (Object)((Translation)ge.getTranslations().get(1)).getText());
    }

    private GlossEntry createEntry() {
        GlossEntry ge = new GlossEntry();
        ge.setId("id");
        ge.setRef("ref");
        ge.getExtAttributes().setAttribute("myNS", "attr1", "val1");
        ge.setTerm(new Term("term"));
        ge.getTerm().setSource("termSource");
        ge.getExtAttributes().setAttribute("myNS", "termAttr1", "termVal1");
        ge.setDefinition(new Definition("definition"));
        ge.getDefinition().setSource("defSource");
        ge.getDefinition().getExtAttributes().setAttribute("myNS", "defAttr1", "defVal1");
        ge.getTranslations().add(new Translation("trans1"));
        Translation trans = (Translation)ge.getTranslations().get(0);
        trans.setId("trans1Id");
        trans.setRef("trans1Ref");
        trans.getExtAttributes().setAttribute("myNS", "trans1Attr1", "trans1Val1");
        return ge;
    }
}

