/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.document;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.URIParser;
import net.sf.okapi.lib.xliff2.core.ExtContent;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.ProcessingInstruction;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.GroupNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import net.sf.okapi.lib.xliff2.writer.ExtensionsWriter;
import org.junit.Assert;
import org.junit.Test;

public class XLIFFDocumentTest {
    private final String root = U.getParentDir(this, "/extra-prefixes.properties");

    @Test
    public void testSimpleRead() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\"><file translate=\"no\" id=\"f1\" original=\"ori\">\n<group id='g1'><unit id=\"u1\" canResegment=\"no\">\n<segment>\n<source>Source 1.</source><target>Target 1.</target>\n</segment>\n<segment>\n<source>Source 2.</source><target>Target 2.</target>\n</segment>\n</unit>\n</group></file></xliff>";
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(text, 255);
        FileNode fn = doc.getFileNode("f1");
        Assert.assertNotNull((Object)fn);
        GroupNode gn = fn.getGroupNode("g1");
        Assert.assertNotNull((Object)gn);
        Assert.assertNotNull((Object)doc.getGroupNode("f1", "g1"));
        Assert.assertNotNull((Object)fn.getUnitNode("u1"));
        Assert.assertNotNull((Object)gn.getUnitNode("u1"));
        Assert.assertNotNull((Object)doc.getUnitNode("f1", "u1"));
    }

    @Test
    public void testDoubleIteration() throws IOException {
        String text = "<?xml version='1.0'?>\n<xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en'><file id='f1'><group id='g11'><unit id='u111'><segment><source>Source 1.</source></segment></unit></group></file><file id='f2'><skeleton>data</skeleton><my:elem xmlns:my='myNS'>extension</my:elem><group id='g21'><unit id='u211'><segment><source>Source 2.</source></segment></unit><group id='g22'><unit id='u221'><segment><source>Source 3.</source></segment></unit></group></group><unit id='u1'><segment><source>Source 4.</source></segment></unit></file></xliff>";
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(text, 255);
        this.checkIteration(doc);
        StringWriter sw = new StringWriter();
        doc.save((Writer)sw);
        sw.close();
        doc = new XLIFFDocument();
        doc.load(sw.getBuffer().toString(), 255);
        this.checkIteration(doc);
    }

    @Test
    public void testFragmentIdentifierAccess() throws IOException {
        XLIFFDocument doc = this.loadDocument1();
        URIParser up = new URIParser(new File(this.root + "/extra-prefixes.properties"));
        Object obj = doc.fetchReference(up.setURL("#f=f1/u=u1/s1"));
        Assert.assertEquals((Object)true, (Object)(obj instanceof Segment));
        obj = doc.fetchReference(up.setURL("#f=f1/u=u1/i1"));
        Assert.assertEquals((Object)true, (Object)(obj instanceof Part));
        obj = doc.fetchReference(up.setURL("#f=f1/g=g1/n=n1"));
        Assert.assertEquals((Object)true, (Object)(obj instanceof Note));
        Assert.assertEquals((Object)"g1-note", (Object)((Note)obj).getText());
        obj = doc.fetchReference(up.setURL("#f=f1/res=r1"));
        Assert.assertEquals((Object)true, (Object)(obj instanceof ExtElement));
        obj = doc.fetchReference(up.setURL("#f=f1/g=g1/my=x1"));
        Assert.assertEquals((Object)true, (Object)(obj instanceof ExtElement));
    }

    @Test
    public void testSpaces() throws IOException {
        String text = "<?xml version='1.0'?>\n<xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en'><file id='f1'><group id='g1'><unit id='u1'><segment><source>[   ]</source></segment></unit></group><unit id='u2'><ignorable><source>[   ]</source></ignorable><segment><source>[   ]</source></segment></unit></file></xliff>";
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(text, 255);
        doc.setLineBreak("\n");
        StringWriter sw = new StringWriter();
        doc.save((Writer)sw);
        sw.close();
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<group id=\"g1\">\n<unit id=\"u1\">\n<segment>\n<source>[   ]</source>\n</segment>\n</unit>\n</group>\n<unit id=\"u2\">\n<ignorable>\n<source>[   ]</source>\n</ignorable>\n<segment>\n<source>[   ]</source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)sw.toString());
    }

    @Test
    public void testObjectAccess() throws IOException {
        XLIFFDocument doc = this.loadDocument1();
        UnitNode un1 = doc.getUnitNode("f1", "u1");
        Assert.assertEquals((Object)"u1", (Object)un1.get().getId());
        GroupNode gn1 = doc.getGroupNode("f1", "g1");
        Assert.assertEquals((Object)"g1", (Object)gn1.get().getId());
        FileNode fn = doc.getFileNode("f1");
        Assert.assertEquals((Object)"f1", (Object)fn.getStartData().getId());
        GroupNode gn2 = fn.getGroupNode("g1");
        Assert.assertTrue((gn1 == gn2 ? 1 : 0) != 0);
        UnitNode un2 = gn2.getUnitNode("u1");
        Assert.assertTrue((un1 == un2 ? 1 : 0) != 0);
    }

    private void checkIteration(XLIFFDocument doc) {
        Iterator iter = doc.createEventIterator();
        int count = 0;
        while (iter.hasNext()) {
            Event event = (Event)iter.next();
            switch (++count) {
                case 1: {
                    Assert.assertTrue((boolean)event.isStartDocument());
                    break;
                }
                case 2: {
                    Assert.assertTrue((boolean)event.isStartXliff());
                    break;
                }
                case 3: {
                    Assert.assertTrue((boolean)event.isStartFile());
                    Assert.assertEquals((Object)"f1", (Object)event.getStartFileData().getId());
                    break;
                }
                case 4: {
                    Assert.assertTrue((boolean)event.isMidFile());
                    break;
                }
                case 5: {
                    Assert.assertTrue((boolean)event.isStartGroup());
                    Assert.assertEquals((Object)"g11", (Object)event.getStartGroupData().getId());
                    break;
                }
                case 6: {
                    Assert.assertTrue((boolean)event.isUnit());
                    Assert.assertEquals((Object)"u111", (Object)event.getUnit().getId());
                    break;
                }
                case 7: {
                    Assert.assertTrue((boolean)event.isEndGroup());
                    break;
                }
                case 8: {
                    Assert.assertTrue((boolean)event.isEndFile());
                    break;
                }
                case 9: {
                    Assert.assertTrue((boolean)event.isStartFile());
                    Assert.assertEquals((Object)"f2", (Object)event.getStartFileData().getId());
                    break;
                }
                case 10: {
                    Assert.assertTrue((boolean)event.isSkeleton());
                    break;
                }
                case 11: {
                    Assert.assertTrue((boolean)event.isMidFile());
                    break;
                }
                case 12: {
                    Assert.assertTrue((boolean)event.isStartGroup());
                    Assert.assertEquals((Object)"g21", (Object)event.getStartGroupData().getId());
                    break;
                }
                case 13: {
                    Assert.assertTrue((boolean)event.isUnit());
                    Assert.assertEquals((Object)"u211", (Object)event.getUnit().getId());
                    break;
                }
                case 14: {
                    Assert.assertTrue((boolean)event.isStartGroup());
                    Assert.assertEquals((Object)"g22", (Object)event.getStartGroupData().getId());
                    break;
                }
                case 15: {
                    Assert.assertTrue((boolean)event.isUnit());
                    Assert.assertEquals((Object)"u221", (Object)event.getUnit().getId());
                    break;
                }
                case 16: {
                    Assert.assertTrue((boolean)event.isEndGroup());
                    break;
                }
                case 17: {
                    Assert.assertTrue((boolean)event.isEndGroup());
                    break;
                }
                case 18: {
                    Assert.assertTrue((boolean)event.isUnit());
                    Assert.assertEquals((Object)"u1", (Object)event.getUnit().getId());
                    break;
                }
                case 19: {
                    Assert.assertTrue((boolean)event.isEndFile());
                    break;
                }
                case 20: {
                    Assert.assertTrue((boolean)event.isEndXliff());
                    break;
                }
                case 21: {
                    Assert.assertTrue((boolean)event.isEndDocument());
                }
            }
        }
    }

    @Test
    public void testGetUnits() {
        XLIFFDocument doc = this.loadDocument1();
        for (Unit unit : doc.getUnits()) {
            Assert.assertEquals((Object)"u1", (Object)unit.getId());
        }
        doc = this.loadDocument2();
        int n = 0;
        for (Unit unit : doc.getUnits()) {
            switch (n) {
                case 0: {
                    Assert.assertEquals((Object)"u1", (Object)unit.getId());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"u2", (Object)unit.getId());
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"u3", (Object)unit.getId());
                }
            }
            ++n;
        }
    }

    @Test
    public void testFileAndUnitNodes() {
        XLIFFDocument doc = this.loadDocument3();
        List fids = doc.getFileNodeIds();
        int f = 0;
        for (String id : fids) {
            FileNode fn = doc.getFileNode(id);
            List nodes = fn.getUnitNodes();
            if (f == 0) {
                Assert.assertEquals((Object)"f1", (Object)fn.getStartData().getId());
                Assert.assertEquals((long)1L, (long)nodes.size());
            } else if (f == 1) {
                Assert.assertEquals((Object)"f2", (Object)fn.getStartData().getId());
                Assert.assertEquals((long)6L, (long)nodes.size());
                Assert.assertEquals((Object)"f2g1g1u1", (Object)((UnitNode)nodes.get(2)).get().getId());
            } else {
                Assert.assertTrue((String)"Too many file nodes", (boolean)true);
            }
            ++f;
        }
    }

    @Test
    public void testCreation() throws IOException {
        FileNode fn2;
        XLIFFDocument doc = new XLIFFDocument("en", null);
        FileNode fn1 = doc.addFileNode("f1");
        Assert.assertTrue((fn1 == (fn2 = doc.getFileNode("f1")) ? 1 : 0) != 0);
        UnitNode un1 = fn1.addUnitNode("u1");
        UnitNode un2 = fn1.getUnitNode("u1");
        Assert.assertTrue((un1 == un2 ? 1 : 0) != 0);
        un1.get().appendSegment().getSource().append((CharSequence)"source1");
        GroupNode gn1 = fn1.addGroupNode("g1");
        GroupNode gn2 = fn1.getGroupNode("g1");
        Assert.assertTrue((gn1 == gn2 ? 1 : 0) != 0);
        un1 = gn1.addUnitNode("u2");
        un2 = gn1.getUnitNode("u2");
        Assert.assertTrue((un1 == un2 ? 1 : 0) != 0);
        Segment seg = un1.get().appendSegment();
        seg.getSource().append((CharSequence)"source2");
        doc.setLineBreak("\n");
        StringWriter sw = new StringWriter();
        doc.save((Writer)sw);
        sw.close();
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<segment>\n<source>source1</source>\n</segment>\n</unit>\n<group id=\"g1\">\n<unit id=\"u2\">\n<segment>\n<source>source2</source>\n</segment>\n</unit>\n</group>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)sw.toString());
    }

    @Test
    public void testSkeleton() throws IOException {
        XLIFFDocument doc = new XLIFFDocument("en", "2.0");
        FileNode fn = doc.addFileNode("f1");
        fn.addUnitNode("u1").get().appendSegment().getSource().append((CharSequence)"Text");
        Skeleton skel = new Skeleton();
        skel.addChild((IExtChild)new ExtContent("Text 1\n\t  Text 2."));
        skel.addChild((IExtChild)new ProcessingInstruction("<?mystuff abc?>"));
        skel.addChild((IExtChild)new ExtContent("\n"));
        skel.addChild((IExtChild)new ExtContent("<>cdata-stuff", true));
        skel.addChild((IExtChild)new ExtContent("\n"));
        ExtElement xe = new ExtElement(new QName("myStuff", "elem", "mine"));
        xe.addContent("Text Content");
        xe.addChild((IExtChild)new ProcessingInstruction("<?extra pi?>"));
        skel.addChild((IExtChild)xe);
        fn.setSkeletonData(skel);
        StringWriter sw = new StringWriter();
        doc.setLineBreak("\n");
        doc.save((Writer)sw);
        sw.close();
        String sklOut = "Text 1\n\t  Text 2.<?mystuff abc?>\n<![CDATA[<>cdata-stuff]]>\n<mine:elem xmlns:mine=\"myStuff\">Text Content<?extra pi?></mine:elem>";
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<skeleton>" + sklOut + "</skeleton>\n<unit id=\"u1\">\n<segment>\n<source>Text</source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        ExtensionsWriter xew = new ExtensionsWriter("\n");
        Assert.assertEquals((Object)sklOut, (Object)xew.buildExtChildren(skel.getChildren(), null));
        Assert.assertEquals((Object)expected, (Object)sw.toString());
        doc.load(sw.toString(), 255);
    }

    private XLIFFDocument loadDocument1() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr' xmlns:res='urn:oasis:names:tc:xliff:resourcedata:2.0'><file id='f1'><res:resourceData><res:resourceItem id='r1' mimeType='text/xml' context='no'><res:source href='resources/en/registryconfig.resources.xml'/><res:target href='resources/de/registryconfig.resources.xml'/></res:resourceItem></res:resourceData><group id='g1'><my:elem xmlns:my='myNS'><my:elem2 xml:id='x1'/></my:elem><notes><note id='n1'>g1-note</note></notes><unit id='u1'><notes><note id='n1'>u1-note</note></notes><segment id='s1'><source>Source 1.</source></segment><ignorable id='i1'><source> </source></ignorable><segment id='s2'><source>Source 2.</source></segment><ignorable><source> </source></ignorable><segment><source>Source 3.</source></segment></unit></group></file></xliff>";
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(text, 255);
        return doc;
    }

    private XLIFFDocument loadDocument2() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr' xmlns:res='urn:oasis:names:tc:xliff:resourcedata:2.0'><file id='f1'><group id='g1'><my:elem xmlns:my='myNS'><my:elem2 xml:id='x1'/></my:elem><notes><note id='n1'>g1-note</note></notes><unit id='u1'><segment id='s1'><source>Source 11. </source></segment><segment id='s2'><source>Source 12.</source></segment></unit><unit id='u2'><segment id='s1'><source>Source 21. </source></segment><segment id='s2'><source>Source 22.</source></segment></unit><unit id='u3'><segment id='s1'><source>Source 31. </source></segment><segment id='s2'><source>Source 32.</source></segment></unit></group></file></xliff>";
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(text, 255);
        return doc;
    }

    private XLIFFDocument loadDocument3() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr' xmlns:res='urn:oasis:names:tc:xliff:resourcedata:2.0'><file id='f1'> <group id='f1g1'>  <unit id='f1g1u1'>   <segment id='s1'><source>Source</source></segment>  </unit> </group></file><file id='f2'> <unit id='f2u1'>  <segment id='s1'><source>Source</source></segment> </unit> <group id='f2g1'>  <unit id='f2g1u1'>   <segment id='s1'><source>Source</source></segment>  </unit>  <group id='f2g1g1'>   <unit id='f2g1g1u1'>    <segment id='s1'><source>Source</source></segment>   </unit>  </group>  <unit id='f2g1u2'>   <segment id='s1'><source>Source</source></segment>  </unit>  <group id='f2g1g2'>   <unit id='f2g1g2u1'>    <segment id='s1'><source>Source</source></segment>   </unit>  </group> </group> <unit id='f2u2'>  <segment id='s1'><source>Source</source></segment> </unit></file></xliff>";
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(text, 255);
        return doc;
    }
}

