/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.Iterator;
import java.util.List;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.TargetState;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.reader.XLIFFReaderException;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;

public class UnitTest {
    @Test
    public void testDefaults() {
        Unit unit = new Unit("id1");
        Assert.assertEquals((Object)"id1", (Object)unit.getId());
        Assert.assertEquals((Object)true, (Object)unit.getCanResegment());
        Assert.assertEquals((Object)true, (Object)unit.getTranslate());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)unit.getTargetDir());
        Assert.assertTrue((boolean)unit.getExtAttributes().isEmpty());
        Assert.assertTrue((boolean)unit.getExtElements().isEmpty());
        Assert.assertEquals((long)0L, (long)unit.getNoteCount());
        Assert.assertEquals((long)0L, (long)unit.getPartCount());
        Assert.assertEquals(null, (Object)unit.getType());
        Assert.assertEquals(null, (Object)unit.getName());
    }

    @Test
    public void testGetPartAndSegment() {
        Unit unit = new Unit("u1");
        unit.appendSegment().getSource().append((CharSequence)"p0s0");
        unit.appendIgnorable().getSource().append((CharSequence)"p1");
        unit.appendIgnorable().getSource().append((CharSequence)"p2");
        unit.appendSegment().getSource().append((CharSequence)"p3s1");
        unit.appendSegment().getSource().append((CharSequence)"p4s2");
        unit.appendIgnorable().getSource().append((CharSequence)"p5");
        unit.appendSegment().getSource().append((CharSequence)"p6s3");
        Assert.assertEquals((long)7L, (long)unit.getPartCount());
        Assert.assertEquals((long)4L, (long)unit.getSegmentCount());
        Assert.assertEquals((Object)"p0s0", (Object)unit.getPart(0).getSource().toString());
        Assert.assertEquals((Object)"p2", (Object)unit.getPart(2).getSource().toString());
        Assert.assertEquals((Object)"p0s0", (Object)unit.getSegment(0).getSource().toString());
        Assert.assertEquals((Object)"p6s3", (Object)unit.getPart(6).getSource().toString());
        Assert.assertEquals((Object)"p6s3", (Object)unit.getSegment(3).getSource().toString());
        Assert.assertEquals((Object)"p3s1", (Object)unit.getSegment(1).getSource().toString());
        Assert.assertEquals((Object)"p4s2", (Object)unit.getSegment(2).getSource().toString());
    }

    @Test
    public void testTargetOrderedList() {
        Unit unit = new Unit("u1");
        Segment seg = unit.appendSegment();
        seg.setSource("seg1-s1");
        seg.setTarget("seg1-t7");
        seg.setTargetOrder(7);
        unit.appendIgnorable().setSource(" .2. ");
        seg = unit.appendSegment();
        seg.setSource("seg2-s3");
        seg.setTarget("seg2-t1");
        seg.setTargetOrder(1);
        unit.appendIgnorable().setSource(" .4. ");
        seg = unit.appendSegment();
        seg.setSource("seg3-s5");
        seg.setTarget("seg3-t5");
        unit.appendIgnorable().setSource(" .6. ");
        seg = unit.appendSegment();
        seg.setSource("seg4-s7");
        seg.setTarget("seg4-t3");
        seg.setTargetOrder(3);
        StringBuilder src = new StringBuilder();
        StringBuilder trg = new StringBuilder();
        for (Part part : unit.getTargetOrderedParts()) {
            src.append(part.getSource().toString());
            trg.append(U.getTargetOrSource(part).toString());
        }
        Assert.assertEquals((Object)"seg2-s3 .2. seg4-s7 .4. seg3-s5 .6. seg1-s1", (Object)src.toString());
        Assert.assertEquals((Object)"seg2-t1 .2. seg4-t3 .4. seg3-t5 .6. seg1-t7", (Object)trg.toString());
    }

    @Test
    public void testInlineTranslate1() {
        Unit unit = new Unit("u1");
        Segment seg = unit.appendSegment();
        seg.setSource("toTrans");
        Part part = unit.appendIgnorable();
        MTag am = part.getSource().openMarkerSpan("m1", null);
        am.setTranslate(Boolean.valueOf(false));
        unit.appendSegment().setSource("noTrans");
        part = unit.appendIgnorable();
        part.getSource().closeMarkerSpan("m1");
        List res = unit.getTranslateStateEndings(true);
        Assert.assertEquals((Object)true, res.get(0));
        Assert.assertEquals((Object)false, res.get(1));
        Assert.assertEquals((Object)false, res.get(2));
        Assert.assertEquals((Object)true, res.get(3));
    }

    @Test
    public void testProtectedCodedText() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1'><source>tt <mrk id='m1' translate='no'>nt</mrk> tt.</source><target>TT <mrk id='m1' translate='no'>nt</mrk> TT.</target></segment><ignorable><source> <sm id='m2' translate='no'/></source><target> <sm id='m2' translate='no'/></target></ignorable><segment id='s2'><source>nt 2 <mrk id='m3' translate='yes'>tt</mrk> nt.</source><target>nt 2 <mrk id='m3' translate='yes'>TT</mrk> nt.</target></segment><ignorable><source> <sm id='m4' translate='yes'/></source><target> <sm id='m4' translate='yes'/></target></ignorable><segment id='s3'><source>tt 3.</source><target>TT 3.</target></segment><ignorable><source><em startRef='m4'/> </source><target><em startRef='m4'/> </target></ignorable><segment id='s4'><source>nt 4.</source><target>nt 4.</target></segment><ignorable><source><em startRef='m2'/> </source><target><em startRef='m2'/> </target></ignorable></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.hideProtectedContent();
        Part part = unit.getPart(0);
        Assert.assertEquals((Object)true, (Object)part.isSegment());
        Assert.assertEquals((Object)"{oA}nt{cA}", (Object)U.fmtMarkers(part.getSourceTags().getPCont(U.kSP(0)).getCodedText()));
        Assert.assertEquals((Object)"tt {$} tt.", (Object)U.fmtMarkers(part.getSource().getCodedText()));
        part = unit.getPart(1);
        Assert.assertEquals((Object)false, (Object)part.isSegment());
        Assert.assertEquals((Object)"{oA}", (Object)U.fmtMarkers(part.getSourceTags().getPCont(U.kSP(1)).getCodedText()));
        Assert.assertEquals((Object)" {$}", (Object)U.fmtMarkers(part.getSource().getCodedText()));
        part = unit.getPart(2);
        Assert.assertEquals((Object)"nt 2 ", (Object)part.getSourceTags().getPCont(U.kSP(2)).getCodedText());
        Assert.assertEquals((Object)" nt.", (Object)part.getSourceTags().getPCont(U.kSP(3)).getCodedText());
        Assert.assertEquals((Object)"{$}{oA}tt{cA}{$}", (Object)U.fmtMarkers(part.getSource().getCodedText()));
        part = unit.getPart(3);
        Assert.assertEquals((Object)" ", (Object)part.getSourceTags().getPCont(U.kSP(4)).getCodedText());
        Assert.assertEquals((Object)"{$}{oA}", (Object)U.fmtMarkers(part.getSource().getCodedText()));
        part = unit.getPart(4);
        Assert.assertEquals((Object)"tt 3.", (Object)U.fmtMarkers(part.getSource().getCodedText()));
        part = unit.getPart(5);
        Assert.assertEquals((Object)" ", (Object)part.getSourceTags().getPCont(U.kSP(5)).getCodedText());
        Assert.assertEquals((Object)"{cA}{$}", (Object)U.fmtMarkers(part.getSource().getCodedText()));
        part = unit.getPart(6);
        Assert.assertEquals((Object)"nt 4.", (Object)part.getSourceTags().getPCont(U.kSP(6)).getCodedText());
        Assert.assertEquals((Object)"{$}", (Object)U.fmtMarkers(part.getSource().getCodedText()));
        part = unit.getPart(7);
        Assert.assertEquals((Object)"{cA}", (Object)U.fmtMarkers(part.getSourceTags().getPCont(U.kSP(7)).getCodedText()));
        Assert.assertEquals((Object)"{$} ", (Object)U.fmtMarkers(part.getSource().getCodedText()));
        this.pseudoTranslateSource(unit);
        unit.showProtectedContent();
        Assert.assertEquals((Object)"ZZZ{oA}nt{cA}ZZZZ", (Object)U.fmtMarkers(unit.getPart(0).getSource().getCodedText()));
        Assert.assertEquals((Object)"Z{oA}", (Object)U.fmtMarkers(unit.getPart(1).getSource().getCodedText()));
        Assert.assertEquals((Object)"nt 2 {oA}ZZ{cA} nt.", (Object)U.fmtMarkers(unit.getPart(2).getSource().getCodedText()));
        Assert.assertEquals((Object)" {oA}", (Object)U.fmtMarkers(unit.getPart(3).getSource().getCodedText()));
        Assert.assertEquals((Object)"ZZZZZ", (Object)U.fmtMarkers(unit.getPart(4).getSource().getCodedText()));
        Assert.assertEquals((Object)"{cA} ", (Object)U.fmtMarkers(unit.getPart(5).getSource().getCodedText()));
        Assert.assertEquals((Object)"nt 4.", (Object)U.fmtMarkers(unit.getPart(6).getSource().getCodedText()));
        Assert.assertEquals((Object)"{cA}Z", (Object)U.fmtMarkers(unit.getPart(7).getSource().getCodedText()));
    }

    @Test
    public void testInlineTranslate2() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1' translate='no'><segment id='s1'><source>t1 <sm id='1' translate='yes'/>t2 <sm id='2' translate='no'/></source></segment><segment id='s2'><source>t3 <em startRef='2'/>t4 </source></segment><segment id='s3'><source><em startRef='1'/>t5</source></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.hideProtectedContent();
        Assert.assertEquals((Object)"{$}{oA}t2 {$}", (Object)U.fmtMarkers(unit.getPart(0).getSource().toString()));
        Assert.assertEquals((Object)"{$}t4 ", (Object)U.fmtMarkers(unit.getPart(1).getSource().toString()));
        Assert.assertEquals((Object)"{cA}{$}", (Object)U.fmtMarkers(unit.getPart(2).getSource().toString()));
        Assert.assertEquals(null, (Object)unit.getPart(0).getTarget());
        Assert.assertEquals(null, (Object)unit.getPart(1).getTarget());
        Assert.assertEquals(null, (Object)unit.getPart(2).getTarget());
        this.pseudoTranslateSource(unit);
        unit.showProtectedContent();
        Assert.assertEquals((Object)"t1 {oA}ZZZ{oA}", (Object)U.fmtMarkers(unit.getPart(0).getSource().toString()));
        Assert.assertEquals((Object)"t3 {cA}ZZZ", (Object)U.fmtMarkers(unit.getPart(1).getSource().toString()));
    }

    @Test
    public void testSplit1() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1'><source>source1. source2.</source><target>translation1. translation2.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.split(0, 9, 9, 14, 14, true);
        Assert.assertEquals((long)2L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"source1. ", (Object)unit.getPart(0).getSource().toString());
        Assert.assertEquals((Object)"source2.", (Object)unit.getPart(1).getSource().toString());
        Assert.assertEquals((Object)"translation1. ", (Object)unit.getPart(0).getTarget().toString());
        Assert.assertEquals((Object)"translation2.", (Object)unit.getPart(1).getTarget().toString());
        Assert.assertEquals((Object)"s1", (Object)unit.getPart(0).getId());
        Assert.assertEquals((Object)"s2", (Object)unit.getPart(1).getId());
        unit.split(1, 0, 0, 0, 5, true);
        Assert.assertEquals((long)3L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"trans", (Object)unit.getPart(1).getTarget().toString());
        Assert.assertEquals((Object)"lation2.", (Object)unit.getPart(2).getTarget().toString());
        Assert.assertEquals((Object)"source2.", (Object)unit.getPart(1).getSource().toString());
        Assert.assertEquals((Object)"", (Object)unit.getPart(2).getSource().toString());
        Assert.assertEquals((Object)"s1", (Object)unit.getPart(0).getId());
        Assert.assertEquals((Object)"s2", (Object)unit.getPart(1).getId());
        Assert.assertEquals((Object)"s3", (Object)unit.getPart(2).getId());
        unit.split(1, 8, 8, 0, 0, true);
        Assert.assertEquals((long)3L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"trans", (Object)unit.getPart(1).getTarget().toString());
        Assert.assertEquals((Object)"lation2.", (Object)unit.getPart(2).getTarget().toString());
        Assert.assertEquals((Object)"source2.", (Object)unit.getPart(1).getSource().toString());
        Assert.assertEquals((Object)"", (Object)unit.getPart(2).getSource().toString());
        Assert.assertEquals((Object)"s1", (Object)unit.getPart(0).getId());
        Assert.assertEquals((Object)"s2", (Object)unit.getPart(1).getId());
        Assert.assertEquals((Object)"s3", (Object)unit.getPart(2).getId());
        unit.split(0, 7, 9, 5, 8, true);
        Assert.assertEquals((long)5L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"source1", (Object)unit.getPart(0).getSource().toString());
        Assert.assertEquals((Object)"trans", (Object)unit.getPart(0).getTarget().toString());
        Assert.assertEquals((Object)". ", (Object)unit.getPart(1).getSource().toString());
        Assert.assertEquals((Object)"lat", (Object)unit.getPart(1).getTarget().toString());
        Assert.assertEquals((Object)"", (Object)unit.getPart(2).getSource().toString());
        Assert.assertEquals((Object)"ion1. ", (Object)unit.getPart(2).getTarget().toString());
        Assert.assertEquals((Object)"source2.", (Object)unit.getPart(3).getSource().toString());
        Assert.assertEquals((Object)"trans", (Object)unit.getPart(3).getTarget().toString());
        Assert.assertEquals((Object)"", (Object)unit.getPart(4).getSource().toString());
        Assert.assertEquals((Object)"lation2.", (Object)unit.getPart(4).getTarget().toString());
        Assert.assertEquals((Object)"s1", (Object)unit.getPart(0).getId());
        Assert.assertEquals((Object)"s4", (Object)unit.getPart(1).getId());
        Assert.assertEquals((Object)"s5", (Object)unit.getPart(2).getId());
        Assert.assertEquals((Object)"s2", (Object)unit.getPart(3).getId());
        Assert.assertEquals((Object)"s3", (Object)unit.getPart(4).getId());
    }

    @Test
    public void testSplit2() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1' state='translated' subState='my:info'><source xml:lang='en' xml:space='preserve'>source1.  source2.</source><target xml:lang='fr' xml:space='preserve'>translation1.  translation2.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.split(0, 8, 10, 13, 15, true);
        Assert.assertEquals((long)3L, (long)unit.getPartCount());
        Segment seg = (Segment)unit.getPart(0);
        Assert.assertEquals((Object)"source1.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)"translation1.", (Object)seg.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.TRANSLATED, (Object)seg.getState());
        Assert.assertEquals((Object)"my:info", (Object)seg.getSubState());
        Part part = unit.getPart(1);
        Assert.assertEquals((Object)"  ", (Object)part.getSource().toString());
        Assert.assertEquals((Object)"  ", (Object)part.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)part.getPreserveWS());
        seg = (Segment)unit.getPart(2);
        Assert.assertEquals((Object)"source2.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)"translation2.", (Object)seg.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.TRANSLATED, (Object)seg.getState());
        Assert.assertEquals((Object)"my:info", (Object)seg.getSubState());
    }

    @Test
    public void testSplit3() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1' state='reviewed' subState='my:info'><source xml:lang='en' xml:space='preserve'>source1.  source2.</source><target xml:lang='fr' xml:space='preserve'>translation1.  translation2.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.split(0, 8, 10, 13, 15, true);
        Assert.assertEquals((long)3L, (long)unit.getPartCount());
        Segment seg = (Segment)unit.getPart(0);
        Assert.assertEquals((Object)"source1.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)"translation1.", (Object)seg.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.TRANSLATED, (Object)seg.getState());
        Assert.assertEquals(null, (Object)seg.getSubState());
        Part part = unit.getPart(1);
        Assert.assertEquals((Object)"  ", (Object)part.getSource().toString());
        Assert.assertEquals((Object)"  ", (Object)part.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)part.getPreserveWS());
        seg = (Segment)unit.getPart(2);
        Assert.assertEquals((Object)"source2.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)"translation2.", (Object)seg.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.TRANSLATED, (Object)seg.getState());
        Assert.assertEquals(null, (Object)seg.getSubState());
    }

    @Test
    public void testSplit4() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1' state='reviewed' subState='my:info'><source xml:lang='en' xml:space='preserve'>source1.  source2.</source></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.split(0, 8, 10, -1, -1, true);
        Assert.assertEquals((long)3L, (long)unit.getPartCount());
        Segment seg = (Segment)unit.getPart(0);
        Assert.assertEquals((Object)"source1.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.REVIEWED, (Object)seg.getState());
        Assert.assertEquals((Object)"my:info", (Object)seg.getSubState());
        Part part = unit.getPart(1);
        Assert.assertEquals((Object)"  ", (Object)part.getSource().toString());
        Assert.assertEquals((Object)true, (Object)part.getPreserveWS());
        seg = (Segment)unit.getPart(2);
        Assert.assertEquals((Object)"source2.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.REVIEWED, (Object)seg.getState());
        Assert.assertEquals((Object)"my:info", (Object)seg.getSubState());
    }

    @Test
    public void testSplit5() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1' state='reviewed' subState='my:info'><source xml:lang='en' xml:space='preserve'>source1.  source2.</source><target xml:lang='fr' xml:space='preserve'>translation1.  translation2.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.split(0, 8, 10, 13, 15, false);
        Assert.assertEquals((long)3L, (long)unit.getPartCount());
        Segment seg = (Segment)unit.getPart(0);
        Assert.assertEquals((Object)"source1.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)"translation1.", (Object)seg.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.REVIEWED, (Object)seg.getState());
        Assert.assertEquals((Object)"my:info", (Object)seg.getSubState());
        Part part = unit.getPart(1);
        Assert.assertEquals((Object)"  ", (Object)part.getSource().toString());
        Assert.assertEquals((Object)"  ", (Object)part.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)part.getPreserveWS());
        seg = (Segment)unit.getPart(2);
        Assert.assertEquals((Object)"source2.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)"translation2.", (Object)seg.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.REVIEWED, (Object)seg.getState());
        Assert.assertEquals((Object)"my:info", (Object)seg.getSubState());
    }

    @Test
    public void testSplit6() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1' state='reviewed' subState='my:info'><source xml:space='preserve'>source1.  source2.</source><target xml:space='preserve'>trans1.  trans2.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.split(0, 8, -1, 7, -1, false);
        Assert.assertEquals((long)2L, (long)unit.getPartCount());
        Segment seg = (Segment)unit.getPart(0);
        Assert.assertEquals((Object)"source1.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)"trans1.", (Object)seg.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.REVIEWED, (Object)seg.getState());
        Assert.assertEquals((Object)"my:info", (Object)seg.getSubState());
        seg = (Segment)unit.getPart(1);
        Assert.assertEquals((Object)"  source2.", (Object)seg.getSource().toString());
        Assert.assertEquals((Object)"  trans2.", (Object)seg.getTarget().toString());
        Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
        Assert.assertEquals((Object)TargetState.REVIEWED, (Object)seg.getState());
        Assert.assertEquals((Object)"my:info", (Object)seg.getSubState());
    }

    @Test
    public void testSplitWithTargetOrder() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1'><source>s1. s2.</source><target order='4'>t1-5. t2-6.</target></segment><ignorable><source> </source><target></target></ignorable><segment id='s2'><source>s3. s4. </source><target order='1'>t3-1. t4-2. </target></segment><segment id='s3'><source>s5. s6.</source><target order='3'>t5-3. t6-4. </target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        Assert.assertEquals((Object)"s1. s2. s3. s4. s5. s6.", (Object)this.getAllText(unit, false));
        Assert.assertEquals((Object)"t3-1. t4-2. t5-3. t6-4. t1-5. t2-6.", (Object)this.getAllText(unit, true));
        unit.split(0, 4, 4, 6, 6, true);
        Assert.assertEquals((Object)"s1. ", (Object)unit.getPart(0).getSource().getCodedText());
        Assert.assertEquals((Object)"t1-5. ", (Object)unit.getPart(0).getTarget().getCodedText());
        unit.split(3, 4, 4, 6, 6, true);
        Assert.assertEquals((Object)"s4. ", (Object)unit.getPart(4).getSource().getCodedText());
        Assert.assertEquals((Object)"t4-2. ", (Object)unit.getPart(4).getTarget().getCodedText());
        unit.split(5, 4, 4, 6, 6, true);
        Assert.assertEquals((Object)"s6.", (Object)unit.getPart(6).getSource().getCodedText());
        Assert.assertEquals((Object)"t6-4. ", (Object)unit.getPart(6).getTarget().getCodedText());
        Assert.assertEquals((Object)"s1. s2. s3. s4. s5. s6.", (Object)this.getAllText(unit, false));
        Assert.assertEquals((Object)"t3-1. t4-2. t5-3. t6-4. t1-5. t2-6.", (Object)this.getAllText(unit, true));
    }

    @Test
    public void testSplitWithSourceTargetInfo() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1'><source xml:space='preserve'>s1. s2.</source><target xml:space='preserve'>t1. t2.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.split(0, 4, 4, 4, 4, true);
        Assert.assertEquals((Object)"s1. ", (Object)unit.getPart(0).getSource().getCodedText());
        Assert.assertEquals((Object)"t1. ", (Object)unit.getPart(0).getTarget().getCodedText());
        Assert.assertEquals((Object)true, (Object)unit.getPart(1).getPreserveWS());
        Assert.assertEquals((Object)Directionality.INHERITED, (Object)unit.getPart(1).getSource().getDir(false));
        Assert.assertEquals((Object)Directionality.INHERITED, (Object)unit.getPart(1).getTarget().getDir(false));
    }

    @Test
    public void testJoin1() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1'><source>s1. </source><target>t1. </target></segment><segment id='s2'><source xml:space='preserve'>s2.</source><target xml:space='preserve'>t2.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.join(0, 1, true, true);
        Assert.assertEquals((Object)"s1. s2.", (Object)unit.getPart(0).getSource().getCodedText());
        Assert.assertEquals((Object)"t1. t2.", (Object)unit.getPart(0).getTarget().getCodedText());
        Assert.assertEquals((Object)true, (Object)unit.getPart(0).getPreserveWS());
        unit = this.getUnit(snippet, 1);
        unit.join(0, -1, false, false);
        Assert.assertEquals((long)1L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"s1. s2.", (Object)unit.getPart(0).getSource().getCodedText());
    }

    @Test
    public void testJoin2() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1'><source>s1. </source><target>t1. </target></segment><segment id='s2'><source>s2. </source><target>t2. </target></segment><segment id='s3' canResegment='no'><source>s3. </source><target>t3. </target></segment><segment id='s4'><source>s4. </source><target>t4. </target></segment><segment id='s5'><source>s5.</source><target>t5.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.joinAll(true);
        Assert.assertEquals((long)3L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"s1. s2. ", (Object)unit.getPart(0).getSource().getCodedText());
        Assert.assertEquals((Object)"s3. ", (Object)unit.getPart(1).getSource().getCodedText());
        Assert.assertEquals((Object)"s4. s5.", (Object)unit.getPart(2).getSource().getCodedText());
        unit = this.getUnit(snippet, 1);
        unit.join(0, -1, false, false);
        Assert.assertEquals((long)1L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"s1. s2. s3. s4. s5.", (Object)unit.getPart(0).getSource().getCodedText());
    }

    @Test
    public void testJoin3() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment id='s1' canResegment='no'><source>s1. </source><target>t1. </target></segment><segment id='s2'><source>s2. </source><target>t2. </target></segment><segment id='s3'><source>s3. </source><target>t3. </target></segment><segment id='s4' canResegment='no'><source>s4. </source><target>t4. </target></segment><segment id='s5'><source>s5. </source><target>t5. </target></segment><segment id='s6' canResegment='no'><source>s6.</source><target>t6.</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(snippet, 1);
        unit.joinAll(true);
        Assert.assertEquals((long)5L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"s1. ", (Object)unit.getPart(0).getSource().getCodedText());
        Assert.assertEquals((Object)"s2. s3. ", (Object)unit.getPart(1).getSource().getCodedText());
        Assert.assertEquals((Object)"s4. ", (Object)unit.getPart(2).getSource().getCodedText());
        Assert.assertEquals((Object)"s5. ", (Object)unit.getPart(3).getSource().getCodedText());
        Assert.assertEquals((Object)"s6.", (Object)unit.getPart(4).getSource().getCodedText());
        unit = this.getUnit(snippet, 1);
        unit.join(0, -1, false, false);
        Assert.assertEquals((long)1L, (long)unit.getPartCount());
        Assert.assertEquals((Object)"s1. s2. s3. s4. s5. s6.", (Object)unit.getPart(0).getSource().getCodedText());
    }

    @Test
    public void testNonRemovableVerification() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment><source><ph id='1'/><pc id='2' canDelete='no'>text</pc> </source><target><pc id='2' canDelete='no'>text</pc> <ph id='3' canDelete='no'/></target></segment><segment><source><ph id='3' canDelete='no'/>text </source><target>text. </target></segment><segment><source><ph id='4' canDelete='no'/>text </source></segment></unit></file></xliff>";
        Assert.assertEquals((Object)true, (Object)(this.getUnit(snippet, 1) != null ? 1 : 0));
    }

    @Test(expected=XLIFFException.class)
    public void testNonRemovableVerificationWithError() {
        String snippet = "<?xml version='1.0'?><xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='1'><segment><source><ph id='1'/><pc id='2'>text</pc> </source><target><pc id='2' canDelete='no'>text</pc> </target></segment><segment><source><ph id='3' canDelete='no'/>text </source><target>text. </target></segment></unit></file></xliff>";
        Assert.assertEquals((Object)true, (Object)(this.getUnit(snippet, 1) != null ? 1 : 0));
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidTypeValue() {
        Unit unit = new Unit("id");
        unit.setType("badValue");
    }

    @Test
    public void testAttributes() {
        Unit unit = new Unit("id");
        unit.setType("good:value");
        Assert.assertEquals((Object)"good:value", (Object)unit.getType());
        unit.setId("newId");
        Assert.assertEquals((Object)"newId", (Object)unit.getId());
        unit.setCanResegment(false);
        Assert.assertEquals((Object)false, (Object)unit.getCanResegment());
        unit.setName("name");
        Assert.assertEquals((Object)"name", (Object)unit.getName());
        unit.setTranslate(false);
        Assert.assertEquals((Object)false, (Object)unit.getTranslate());
    }

    @Test
    public void testCopyConstructor() {
        Unit u1 = new Unit("u1");
        u1.setCanResegment(false);
        Note note = (Note)u1.getNotes().add((Object)new Note("note1", Note.AppliesTo.TARGET));
        note.setId("n1");
        note.setCategory("cat");
        note.setPriority(5);
        note.getExtAttributes().setAttribute("ns", "attr", "valnote");
        u1.setSourceDir(Directionality.RTL);
        u1.setTargetDir(Directionality.RTL);
        u1.setTranslate(false);
        u1.setType("x:utype");
        Segment seg = u1.appendSegment();
        seg.setCanResegment(false);
        seg.setId("s1");
        seg.setPreserveWS(true);
        seg.setState("translated");
        seg.setSubState("x:mine");
        Fragment frag = seg.getSource();
        frag.setDir(Directionality.RTL);
        frag.append((CharSequence)"src");
        frag.append(TagType.OPENING, "1", "[c1]", true);
        frag.appendCode("2", "[c2/]");
        frag.append(TagType.CLOSING, "1", "[/c1]", true);
        Unit u2 = new Unit(u1);
        Assert.assertEquals((Object)u1.getAnnotatorsRef(), (Object)u2.getAnnotatorsRef());
        Assert.assertEquals((Object)u1.getCanResegment(), (Object)u2.getCanResegment());
        Assert.assertTrue((boolean)this.sameExtAttributes((IWithExtAttributes)u1, (IWithExtAttributes)u2));
        Assert.assertEquals((Object)u1.getId(), (Object)u2.getId());
        Assert.assertEquals((Object)u1.getName(), (Object)u2.getName());
        Assert.assertTrue((boolean)this.sameNotes((IWithNotes)u1, (IWithNotes)u2));
        Assert.assertEquals((Object)u1.getSourceDir(), (Object)u2.getSourceDir());
        Assert.assertEquals((Object)u1.getTargetDir(), (Object)u2.getTargetDir());
        Assert.assertEquals((Object)u1.getTranslate(), (Object)u2.getTranslate());
        Assert.assertEquals((Object)u1.getType(), (Object)u2.getType());
        Segment s1 = u1.getSegment(0);
        Segment s2 = u2.getSegment(0);
        Assert.assertEquals((Object)s1.getCanResegment(), (Object)s2.getCanResegment());
        Assert.assertEquals((Object)s1.getId(), (Object)s2.getId());
        Assert.assertEquals((Object)s1.getPreserveWS(), (Object)s2.getPreserveWS());
        Assert.assertEquals((Object)s1.getState(), (Object)s2.getState());
        Assert.assertEquals((Object)s1.getSubState(), (Object)s2.getSubState());
        Assert.assertTrue((boolean)this.sameFragments(s1.getSource(), s2.getSource()));
    }

    @Test
    public void testMatchWithIsolatedInMatch() {
        String xlfStr = this.getTestXlfWithIsolatedInMatch();
        Unit unit = this.getUnit(xlfStr, 1);
        Assert.assertNotNull((String)"There seems to be no unit in this xlf doc. ", (Object)unit);
    }

    @Test
    public void testMissingIsolatedAttribute() {
        try {
            String xlfStr = this.getTestXlfWithMissingIsolatedAttribute();
            this.getUnit(xlfStr, 1);
        }
        catch (XLIFFReaderException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Missing isolated='yes' for opening code id='1'"));
        }
    }

    @Test
    public void testGetMatches() {
        String xlfStr = this.getTestXlf();
        Unit unit = this.getUnit(xlfStr, 1);
        Assert.assertNotNull((String)"There seems to be no unit in this xlf doc. ", (Object)unit);
        List exactMatches = unit.getAllExactMatches();
        Assert.assertNotNull((String)"There should be some exact matches returned. ", (Object)exactMatches);
        Assert.assertEquals((String)"There should be one exact match.", (long)1L, (long)exactMatches.size());
        double minSim = 85.0;
        List simMatches = unit.getMatchesByMinimumSimilarity(minSim);
        Assert.assertNotNull((String)"There should be some matches returned. ", (Object)simMatches);
        Assert.assertEquals((String)"There should be five matches.", (long)5L, (long)simMatches.size());
        double maxSim = 90.0;
        List simRangeMatches = unit.getMatchesBySimilarityRange(minSim, maxSim);
        Assert.assertNotNull((String)"There should be some matches returned. ", (Object)simRangeMatches);
        Assert.assertEquals((String)"There should be four matches.", (long)4L, (long)simRangeMatches.size());
        int segIdx = 2;
        List segmentMatches = unit.getMatchesForSegment(segIdx);
        Assert.assertNotNull((String)("There should be some matches returned for segment " + segIdx), (Object)segmentMatches);
        Assert.assertEquals((String)("There should be six matches returned for segment with index " + segIdx), (long)6L, (long)segmentMatches.size());
        segIdx = 3;
        segmentMatches = unit.getMatchesForSegment(segIdx);
        Assert.assertNotNull((String)("There should be some matches returned for segment " + segIdx), (Object)segmentMatches);
        Assert.assertEquals((String)("There should be one match returned for segment with index " + segIdx), (long)1L, (long)segmentMatches.size());
        String ref = "#2";
        List refMatches = unit.getMatchesByRef(ref);
        Assert.assertNotNull((String)("There should be some matches returned for match ref " + ref), (Object)refMatches);
        Assert.assertEquals((String)("There should be one match for ref " + ref), (long)1L, (long)refMatches.size());
        ref = "2";
        refMatches = unit.getMatchesByRef(ref);
        Assert.assertNotNull((String)("There should be some matches returned for match ref " + ref), (Object)refMatches);
        Assert.assertEquals((String)("There should be one match for ref " + ref), (long)1L, (long)refMatches.size());
        ref = "#3";
        refMatches = unit.getMatchesByRef(ref);
        Assert.assertNotNull((String)("There should be some matches returned for match ref " + ref), (Object)refMatches);
        Assert.assertEquals((String)("There should be three matches for ref " + ref), (long)3L, (long)refMatches.size());
        ref = "3";
        refMatches = unit.getMatchesByRef(ref);
        Assert.assertNotNull((String)("There should be some matches returned for match ref " + ref), (Object)refMatches);
        Assert.assertEquals((String)("There should be three matches for ref " + ref), (long)3L, (long)refMatches.size());
    }

    @Test
    public void testNoMatches() {
        Unit unit = new Unit("id1");
        unit.appendSegment().setSource("text");
        Assert.assertEquals((long)0L, (long)unit.getAllExactMatches().size());
        Assert.assertEquals((long)0L, (long)unit.getMatchesByMinimumSimilarity(10.0).size());
        Assert.assertEquals((long)0L, (long)unit.getMatchesByRef("someRef").size());
        Assert.assertEquals((long)0L, (long)unit.getMatchesBySimilarityRange(0.0, 75.0).size());
        Assert.assertEquals((long)0L, (long)unit.getMatchesForSegment(0).size());
        Assert.assertEquals((long)0L, (long)unit.getMatches().size());
    }

    private String getTestXlfWithIsolatedInMatch() {
        String xlString = "<xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0'\r\n srcLang='en' trgLang='fr'>\r\n <file id='1'>\r\n  <unit id='1'>\r\n   <mtc:matches xmlns:mtc=\"urn:oasis:names:tc:xliff:matches:2.0\">\r\n    <mtc:match ref=\"#m1\" similarity=\"86.0\" matchSuitability=\"86.0\">\r\n     <source>text <sc id='1' isolated=\"yes\"/></source>\r\n     <target>texte <sc id='1' isolated=\"yes\"/></target>\r\n    </mtc:match>\r\n   </mtc:matches>\r\n   <segment>\r\n    <source><sm id=\"m1\" type=\"mtc:match\"/>Text <sc id='1'/><em startRef=\"m1\"/>stuff<ec startRef=\"1\"/></source>\r\n   </segment>\r\n  </unit>\r\n </file>\r\n</xliff>";
        return xlString;
    }

    private String getTestXlfWithMissingIsolatedAttribute() {
        String xlString = "<xliff xmlns='urn:oasis:names:tc:xliff:document:2.0' version='2.0'\r\n srcLang='en' trgLang='fr'>\r\n <file id='1'>\r\n  <unit id='1'>\r\n   <mtc:matches xmlns:mtc=\"urn:oasis:names:tc:xliff:matches:2.0\">\r\n    <mtc:match ref=\"#m1\" similarity=\"86.0\" matchSuitability=\"86.0\">\r\n     <source>text <sc id='1' isolated=\"yes\"/></source>\r\n     <target>texte <sc id='1' isolated=\"yes\"/></target>\r\n    </mtc:match>\r\n   </mtc:matches>\r\n   <segment>\r\n    <source><sm id=\"m1\" type=\"mtc:match\"/>Text <sc id='1'/><em startRef=\"m1\"/></source>\r\n   </segment>\r\n  </unit>\r\n </file>\r\n</xliff>";
        return xlString;
    }

    private String getTestXlf() {
        String xlfStr = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"de\"\n    xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\"\n    its:version=\"2.0\">\n    <file id=\"f1\"\n        original=\"Alice_Chapter1 EN.1.icml\">\n        <group id=\"g1\">\n            <unit id=\"ud7-4\">\n                    <mtc:matches xmlns:mtc=\"urn:oasis:names:tc:xliff:matches:2.0\">\n                        <mtc:match ref=\"#1\" type=\"other\" similarity=\"86.0\" matchSuitability=\"86.0\"\n                            >\n                            <originalData>\n                                <data id=\"d1\">&lt;Content></data>\n                                <data id=\"d2\">&lt;/Content></data>\n                                <data id=\"d3\">&lt;/Content>&lt;Br/>&lt;Br/></data>\n                            </originalData>\n                            <source>So she was considering, in her own mind (as well as she could,\n                                for the hot day made her feel very sleepy and stupid), whether the\n                                pleasure of making a daisy-chain would be worth the trouble of\n                                getting up and picking the daisies, when suddenly a White Rabbit\n                                with pink eyes ran close by her.</source>\n                            <target>Sie \u00fcberlegte sich eben, (so gut es ging, denn sie war schl\u00e4frig\n                                und dumm von der Hitze,) ob es der M\u00fche wert sei aufzustehen und\n                                G\u00e4nsebl\u00fcmchen zu pfl\u00fccken, um eine Kette damit zu machen, als\n                                pl\u00f6tzlich ein wei\u00dfes Kaninchen mit roten Augen dicht an ihr\n                                    vorbeirannte.<pc id=\"11\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"12\" canCopy=\"no\"\n                                    canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"13\"\n                                    canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"\n                                    /><pc id=\"14\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\"\n                                    dataRefStart=\"d1\"/><pc id=\"15\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d3\" dataRefStart=\"d1\"/></target>\n                        </mtc:match>\n                        <mtc:match ref=\"#1\" type=\"other\" similarity=\"86.0\" matchSuitability=\"86.0\"\n                            >\n                            <originalData>\n                                <data id=\"d1\">&lt;Content></data>\n                                <data id=\"d2\">&lt;/Content></data>\n                                <data id=\"d3\">&lt;/Content>&lt;Br/>&lt;Br/></data>\n                            </originalData>\n                            <source>So she was considering, in her own mind (as well as she could,\n                                for the hot day made her feel very sleepy and stupid), whether the\n                                pleasure of making a daisy-chain would be worth the trouble of\n                                getting up and picking the daisies, when suddenly a White Rabbit\n                                with pink eyes ran close by her.</source>\n                            <target>Sie \u00fcberlegte sich eben, (so gut es ging, denn sie war schl\u00e4frig\n                                und dumm von der Hitze,) ob es der M\u00fche werth sei aufzustehen und\n                                G\u00e4nsebl\u00fcmchen zu pfl\u00fccken, um eine Kette damit zu machen, als\n                                pl\u00f6tzlich ein wei\u00dfes Kaninchen mit rothen Augen dicht an ihr\n                                    vorbeirannte.<pc id=\"11\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"12\" canCopy=\"no\"\n                                    canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"13\"\n                                    canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"\n                                    /><pc id=\"14\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\"\n                                    dataRefStart=\"d1\"/><pc id=\"15\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d3\" dataRefStart=\"d1\"/></target>\n                        </mtc:match>\n                        <mtc:match ref=\"#1\" type=\"other\" similarity=\"85.0\" matchSuitability=\"85.0\"\n                            >\n                            <originalData>\n                                <data id=\"d1\">&lt;Content></data>\n                                <data id=\"d2\">&lt;/Content></data>\n                                <data id=\"d3\">&lt;/Content>&lt;Br/>&lt;Br/></data>\n                            </originalData>\n                            <source>So she was considering, in her own mind (as well as she could,\n                                for the hot day made her feel very sleepy and stupid), whether the\n                                pleasure of making a daisy-chain would be worth the trouble of\n                                getting up and picking the daisies, when suddenly a Blue Rabbit with\n                                pink eyes ran close by her.</source>\n                            <target>Sie \u00fcberlegte sich eben, (so gut es ging, denn sie war schl\u00e4frig\n                                und dumm von der Hitze,) ob es der M\u00fche werth sei aufzustehen und\n                                G\u00e4nsebl\u00fcmchen zu pfl\u00fccken, um eine Kette damit zu machen, als\n                                pl\u00f6tzlich ein blaues Kaninchen mit rothen Augen dicht an ihr\n                                    vorbeirannte.<pc id=\"11\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"12\" canCopy=\"no\"\n                                    canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"13\"\n                                    canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"\n                                    /><pc id=\"14\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\"\n                                    dataRefStart=\"d1\"/><pc id=\"15\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d3\" dataRefStart=\"d1\"/></target>\n                        </mtc:match>\n                        <mtc:match ref=\"#1\" type=\"other\" similarity=\"84.0\" matchSuitability=\"84.0\"\n                            >\n                            <originalData>\n                                <data id=\"d1\">&lt;Content></data>\n                                <data id=\"d2\">&lt;/Content></data>\n                                <data id=\"d3\">&lt;/Content>&lt;Br/>&lt;Br/></data>\n                            </originalData>\n                            <source>So she was considering, in her own mind (as well as she could,\n                                for the hot day made her feel very sleepy and stupid), whether the\n                                pleasure of making a daisy-chain would be worth the trouble of\n                                getting up and picking the daisies, when suddenly a White Bunny with\n                                pink eyes ran close by her.</source>\n                            <target>Sie \u00fcberlegte sich eben, (so gut es ging, denn sie war schl\u00e4frig\n                                und dumm von der Hitze,) ob es der M\u00fche werth sei aufzustehen und\n                                G\u00e4nsebl\u00fcmchen zu pfl\u00fccken, um eine Kette damit zu machen, als\n                                pl\u00f6tzlich ein wei\u00dfer Hase mit rothen Augen dicht an ihr\n                                    vorbeirannte.<pc id=\"11\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"12\" canCopy=\"no\"\n                                    canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"13\"\n                                    canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"\n                                    /><pc id=\"14\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\"\n                                    dataRefStart=\"d1\"/><pc id=\"15\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d3\" dataRefStart=\"d1\"/></target>\n                        </mtc:match>\n                        <mtc:match ref=\"#1\" type=\"other\" similarity=\"80.0\" matchSuitability=\"80.0\"\n                            >\n                            <originalData>\n                                <data id=\"d1\">&lt;Content></data>\n                                <data id=\"d2\">&lt;/Content></data>\n                                <data id=\"d3\">&lt;/Content>&lt;Br/>&lt;Br/></data>\n                            </originalData>\n                            <source> &lt;it/>&lt;it/> So she was considering, in her own mind (as\n                                well as she could, for the hot day made her feel very sleepy and\n                                stupid), whether the pleasure of making a daisy-chain would be worth\n                                the trouble of getting up and picking the daisies, when suddenly a\n                                White Rabbit with pink eyes ran close by her. </source>\n                            <target>\n                                <pc id=\"11\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\"\n                                    dataRefStart=\"d1\"/><pc id=\"12\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d2\" dataRefStart=\"d1\"/> Sie \u00fcberlegte sich eben, (so\n                                gut es ging, denn sie war schl\u00e4frig und dumm von der Hitze,) ob es\n                                der M\u00fche wert sei aufzustehen und G\u00e4nsebl\u00fcmchen zu pfl\u00fccken, um eine\n                                Kette damit zu machen, als pl\u00f6tzlich ein wei\u00dfes Kaninchen mit roten\n                                Augen dicht an ihr vorbeirannte. <pc id=\"13\" canCopy=\"no\"\n                                    canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"14\"\n                                    canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"\n                                    /><pc id=\"15\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d3\"\n                                    dataRefStart=\"d1\"/></target>\n                        </mtc:match>\n                        <mtc:match ref=\"#1\" type=\"other\" similarity=\"80.0\" matchSuitability=\"80.0\"\n                            >\n                            <originalData>\n                                <data id=\"d1\">&lt;Content></data>\n                                <data id=\"d2\">&lt;/Content></data>\n                                <data id=\"d3\">&lt;/Content>&lt;Br/>&lt;Br/></data>\n                            </originalData>\n                            <source>So she was considering, in her own mind (as well as she could,\n                                for the hot day made her feel very sleepy and stupid), whether the\n                                pleasure of making a daisy-chain would be worth the trouble of\n                                getting up and picking the daisies, when suddenly a Blue Bunny with\n                                orange spies ran close by her.</source>\n                            <target>Sie \u00fcberlegte sich eben, (so gut es ging, denn sie war schl\u00e4frig\n                                und dumm von der Hitze,) ob es der M\u00fche werth sei aufzustehen und\n                                G\u00e4nsebl\u00fcmchen zu pfl\u00fccken, um eine Kette damit zu machen, als\n                                pl\u00f6tzlich ein blauer Hase mit orangenen Spionen dicht an ihr\n                                    vorbeirannte.<pc id=\"11\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"12\" canCopy=\"no\"\n                                    canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"13\"\n                                    canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"\n                                    /><pc id=\"14\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\"\n                                    dataRefStart=\"d1\"/><pc id=\"15\" canCopy=\"no\" canDelete=\"no\"\n                                    dataRefEnd=\"d3\" dataRefStart=\"d1\"/></target>\n                        </mtc:match>\n                        <mtc:match ref=\"#2\" type=\"other\" similarity=\"89.0\" matchSuitability=\"89.0\"\n                            >\n                            <originalData>\n                                <data id=\"d1\">&lt;Content></data>\n                                <data id=\"d2\">&lt;/Content></data>\n                            </originalData>\n                            <source>There was nothing so very remarkable in that; nor did Alice\n                                think it so very much out of the way to hear the Rabbit say to\n                                itself \"Oh dear! </source>\n                            <target>Dies war grade nicht sehr; merkw\u00fcrdig; Alice fand es auch nicht\n                                sehr au\u00dferordentlich, da\u00df sie das Kaninchen sagen h\u00f6rte: \u00bb Oh\n                                Jemine! <pc id=\"18\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\"\n                                    dataRefStart=\"d1\"/><sc id=\"19\" canOverlap=\"no\" isolated=\"yes\"\n                                    canCopy=\"no\" canDelete=\"no\" dataRef=\"d1\"/></target>\n                        </mtc:match>\n                        <mtc:match ref=\"#3\" type=\"other\" similarity=\"100.0\" matchSuitability=\"100.0\"\n                            >\n                            <source>Would the fall never come to an end? </source>\n                            <target>Wollte denn der Fall nie endigen? </target>\n                        </mtc:match>\n                        <mtc:match ref=\"#3\" type=\"other\" similarity=\"84.0\" matchSuitability=\"84.0\"\n                            >\n                            <source>Would the autumn never come to an end? </source>\n                            <target>Wollte denn der Herbst nie endigen? </target>\n                        </mtc:match>\n                        <mtc:match ref=\"#3\" type=\"other\" similarity=\"84.0\" matchSuitability=\"84.0\"\n                            >\n                            <source>Would the winter never come to an end? </source>\n                            <target>Wollte denn der Winter nie endigen? </target>\n                        </mtc:match>\n                    </mtc:matches>\n                    \n                    <originalData>\n                        <data id=\"d1\">&lt;Content></data>\n                        <data id=\"d2\">&lt;/Content></data>\n                        <data id=\"d3\">&lt;/Content>&lt;Br/>&lt;Br/></data>\n                    </originalData>\n                    <segment>\n                        <source xml:space=\"preserve\"><pc id=\"4\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">Alice was beginning to get very tired of sitting by her sister on the </pc><sc id=\"5\" canOverlap=\"no\" canCopy=\"no\" canDelete=\"no\" dataRef=\"d1\"/>bank, and of having nothing to do. </source>\n                        <target xml:space=\"preserve\"><pc id=\"4\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">Alice was beginning to get very tired of sitting by her sister on the </pc><sc id=\"5\" canOverlap=\"no\" canCopy=\"no\" canDelete=\"no\" dataRef=\"d1\"/>bank, and of having nothing to do. </target>\n                    </segment>\n                    <segment>\n                        <source xml:space=\"preserve\">Once or twice she had peeped into the <ec startRef=\"5\" canOverlap=\"no\" canCopy=\"no\" canDelete=\"no\" dataRef=\"d2\"/><pc id=\"6\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">book her sister was reading, but it had no pictures or conversations in </pc><pc id=\"7\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">it, \u201cand what is the use of a book,\u201d thought Alice, \u201cwithout pictures or </pc><pc id=\"8\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d3\" dataRefStart=\"d1\">conversations?\u201d</pc></source>\n                        <target xml:space=\"preserve\">Once or twice she had peeped into the <ec startRef=\"5\" canOverlap=\"no\" canCopy=\"no\" canDelete=\"no\" dataRef=\"d2\"/><pc id=\"6\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">book her sister was reading, but it had no pictures or conversations in </pc><pc id=\"7\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">it, \u201cand what is the use of a book,\u201d thought Alice, \u201cwithout pictures or </pc><pc id=\"8\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d3\" dataRefStart=\"d1\">conversations?\u201d</pc></target>\n                    </segment>\n                    <segment state=\"initial\">\n                        <source xml:space=\"preserve\"><mrk id=\"1\" type=\"mtc:match\"><pc id=\"11\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">So she was considering in her own mind (as well as she could, for the </pc><pc id=\"12\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">day made her feel very sleepy and stupid), whether the pleasure of </pc><pc id=\"13\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">making a daisy-chain would be worth the trouble of getting up and </pc><pc id=\"14\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">picking the daisies, when suddenly a White Rabbit with pink eyes ran </pc><pc id=\"15\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d3\" dataRefStart=\"d1\">close by her.</pc></mrk></source>\n                        <target xml:space=\"preserve\">Sie \u00fcberlegte sich eben, (so gut es ging, denn sie war schl\u00e4frig und dumm von der Hitze,) ob es der M\u00fche wert sei aufzustehen und G\u00e4nsebl\u00fcmchen zu pfl\u00fccken, um eine Kette damit zu machen, als pl\u00f6tzlich ein wei\u00dfes Kaninchen mit roten Augen dicht an ihr vorbeirannte.<pc id=\"11\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"12\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"13\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"14\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><pc id=\"15\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d3\" dataRefStart=\"d1\"/></target>\n                    </segment>\n                    <segment state=\"initial\">\n                        <source xml:space=\"preserve\"><sm id=\"2\" type=\"mtc:match\"/><pc id=\"18\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\">There was nothing so very remarkable in that, nor did Alice think it so </pc><sc id=\"19\" canOverlap=\"no\" canCopy=\"no\" canDelete=\"no\" dataRef=\"d1\"/>very much out of the way to hear the Rabbit say to itself, \u201cOh dear! <em startRef=\"2\"/></source>\n                        <target xml:space=\"preserve\">Dies war grade nicht sehr; merkw\u00fcrdig; Alice fand es auch nicht sehr au\u00dferordentlich, da\u00df sie das Kaninchen sagen h\u00f6rte: \u00bb Oh Jemine! <pc id=\"18\" canCopy=\"no\" canDelete=\"no\" dataRefEnd=\"d2\" dataRefStart=\"d1\"/><sc id=\"19\" canOverlap=\"no\" canCopy=\"no\" canDelete=\"no\" dataRef=\"d1\"/></target>\n                    </segment>\n                    <segment>\n                        <source xml:space=\"preserve\">Oh <ec startRef=\"19\" canOverlap=\"no\" canCopy=\"no\" canDelete=\"no\" dataRef=\"d2\"/>dear! </source>\n                        <target xml:space=\"preserve\">Oh <ec startRef=\"19\" canOverlap=\"no\" canCopy=\"no\" canDelete=\"no\" dataRef=\"d2\"/>dear! </target>\n                    </segment>\n                    <segment>\n                        <source xml:space=\"preserve\">I shall be too late!\u201d </source>\n                        <target xml:space=\"preserve\">I shall be too late!\u201d </target>\n                    </segment>\n                    <!-- snip -->\n                    <segment>\n                        <source xml:space=\"preserve\">Down, down, down! </source>\n                        <target xml:space=\"preserve\">Down, down, down! </target>\n                    </segment>\n                    <segment state=\"initial\">\n                        <source xml:space=\"preserve\"><mrk id=\"3\" type=\"mtc:match\">Would the fall never come to an end? </mrk></source>\n                        <target xml:space=\"preserve\">Wollte denn der Fall nie endigen? </target>\n                    </segment>\n                </unit>\n        </group>\n    </file>\n</xliff>\n";
        return xlfStr;
    }

    private boolean sameFragments(Fragment f1, Fragment f2) {
        String ct1 = f1.getCodedText();
        String ct2 = f2.getCodedText();
        for (int i = 0; i < ct1.length(); ++i) {
            char c1 = ct1.charAt(i);
            char c2 = ct2.charAt(i);
            Assert.assertEquals((long)c1, (long)c2);
            if (!Fragment.isChar1((char)c1)) continue;
            int key1 = Fragment.toKey((int)c1, (int)ct1.charAt(i + 1));
            int key2 = Fragment.toKey((int)c2, (int)ct2.charAt(i + 1));
            ++i;
            Tag bm1 = f1.getTag(key1);
            Tag bm2 = f2.getTag(key2);
            Assert.assertEquals((Object)bm1.getId(), (Object)bm2.getId());
            Assert.assertEquals((Object)bm1.getTagType(), (Object)bm2.getTagType());
            Assert.assertEquals((Object)bm1.getType(), (Object)bm2.getType());
            Assert.assertTrue((boolean)this.sameExtAttributes((IWithExtAttributes)bm1, (IWithExtAttributes)bm2));
            if (bm1 instanceof CTag) {
                CTag cm1 = (CTag)bm1;
                CTag cm2 = (CTag)bm2;
                Assert.assertEquals((Object)cm1.getCanCopy(), (Object)cm2.getCanCopy());
                Assert.assertEquals((Object)cm1.getCanDelete(), (Object)cm2.getCanDelete());
                Assert.assertEquals((Object)cm1.getCanOverlap(), (Object)cm2.getCanOverlap());
                Assert.assertEquals((Object)cm1.getCanReorder(), (Object)cm2.getCanReorder());
                Assert.assertEquals((Object)cm1.getCopyOf(), (Object)cm2.getCopyOf());
                Assert.assertEquals((Object)cm1.getDataDir(), (Object)cm2.getDataDir());
                Assert.assertEquals((Object)cm1.getDataRef(), (Object)cm2.getDataRef());
                Assert.assertEquals((Object)cm1.getDir(), (Object)cm2.getDir());
                Assert.assertEquals((Object)cm1.getDisp(), (Object)cm2.getDisp());
                Assert.assertEquals((Object)cm1.getEquiv(), (Object)cm2.getEquiv());
                Assert.assertEquals((Object)cm1.isInitialWithData(), (Object)cm2.isInitialWithData());
                Assert.assertEquals((Object)cm1.getData(), (Object)cm2.getData());
                Assert.assertEquals((Object)cm1.getSubFlows(), (Object)cm2.getSubFlows());
                Assert.assertEquals((Object)cm1.getSubType(), (Object)cm2.getSubType());
                continue;
            }
            MTag am1 = (MTag)bm1;
            MTag am2 = (MTag)bm2;
            Assert.assertEquals((Object)am1.getRef(), (Object)am2.getRef());
            Assert.assertEquals((Object)am1.getTranslate(), (Object)am2.getTranslate());
            Assert.assertEquals((Object)am1.getValue(), (Object)am2.getValue());
        }
        return true;
    }

    private boolean sameExtAttributes(IWithExtAttributes o1, IWithExtAttributes o2) {
        for (ExtAttribute a1 : o1.getExtAttributes()) {
            ExtAttribute a2 = o2.getExtAttributes().getAttribute(a1.getNamespaceURI(), a1.getLocalPart());
            Assert.assertEquals((Object)a1.getValue(), (Object)a2.getValue());
            Assert.assertEquals((Object)a1.getPrefix(), (Object)a2.getPrefix());
        }
        return true;
    }

    private boolean sameNotes(IWithNotes o1, IWithNotes o2) {
        Assert.assertEquals((long)o1.getNoteCount(), (long)o2.getNoteCount());
        Iterator iter1 = o1.getNotes().iterator();
        Iterator iter2 = o2.getNotes().iterator();
        while (iter1.hasNext()) {
            Assert.assertTrue((boolean)iter2.hasNext());
            Note n1 = (Note)iter1.next();
            Note n2 = (Note)iter2.next();
            Assert.assertEquals((Object)n1.getAppliesTo(), (Object)n2.getAppliesTo());
            Assert.assertEquals((Object)n1.getCategory(), (Object)n2.getCategory());
            Assert.assertEquals((Object)n1.getId(), (Object)n2.getId());
            Assert.assertEquals((long)n1.getPriority(), (long)n2.getPriority());
            Assert.assertEquals((Object)n1.getText(), (Object)n2.getText());
            Assert.assertTrue((boolean)this.sameExtAttributes((IWithExtAttributes)n1, (IWithExtAttributes)n2));
        }
        return true;
    }

    private void pseudoTranslateSource(Unit unit) {
        for (Part part : unit) {
            Fragment frag = part.getSource();
            StringBuilder tmp = new StringBuilder(frag.getCodedText());
            for (int i = 0; i < tmp.length(); ++i) {
                if (Fragment.isChar1((char)tmp.charAt(i))) {
                    ++i;
                    continue;
                }
                tmp.setCharAt(i, 'Z');
            }
            frag.setCodedText(tmp.toString());
        }
    }

    private String getAllText(Unit unit, boolean target) {
        StringBuilder tmp = new StringBuilder();
        if (target) {
            List list = unit.getTargetOrderedParts();
            for (Part part : list) {
                tmp.append(U.getTargetOrSource(part).toXLIFF());
            }
        } else {
            for (Part part : unit) {
                tmp.append(part.getSource().toXLIFF());
            }
        }
        return tmp.toString();
    }

    private Unit getUnit(String snippet, int pos) {
        int count = 0;
        try (XLIFFReader reader = new XLIFFReader();){
            reader.open(snippet);
            while (reader.hasNext()) {
                Event event = reader.next();
                if (!event.isUnit() || ++count != pos) continue;
                Unit unit = event.getUnit();
                return unit;
            }
            Unit unit = null;
            return unit;
        }
    }
}

