/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.lib.xliff2.URIPrefixes;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;

public class URIPrefixesTest {
    private final String root = U.getParentDir(this, "/example.xlf");

    @Test
    public void testResolveWithDefaults() {
        URIPrefixes upr = new URIPrefixes();
        Assert.assertEquals((Object)"urn:oasis:names:tc:xliff:glossary:2.0", upr.resolve("gls").get(0));
        Assert.assertEquals((Object)"urn:oasis:names:tc:xliff:matches:2.0", upr.resolve("mtc").get(0));
        Assert.assertEquals((Object)"urn:oasis:names:tc:xliff:resourcedata:2.0", upr.resolve("res").get(0));
    }

    @Test
    public void testResolveUnknown() {
        Assert.assertEquals(null, (Object)new URIPrefixes().resolve("xyz"));
        Assert.assertEquals(null, (Object)new URIPrefixes().resolve("GLS"));
    }

    @Test
    public void testCustomPrefixes() {
        URIPrefixes upr = new URIPrefixes(new File(this.root + "/extra-prefixes.properties"));
        List list = upr.resolve("tbx");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"urn:iso:std:iso:30042:ed-1:v1:en", list.get(0));
        list = upr.resolve("gls");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"urn:oasis:names:tc:xliff:glossary:2.0", list.get(0));
        Assert.assertEquals((Object)"testGLSv2.x", list.get(1));
    }

    @Test
    public void testManualCustomPrefixes() {
        URIPrefixes upr = new URIPrefixes();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("myURI1", "p1");
        map.put("myURITwo", "p2");
        map.put("myURI1bis", "p1");
        upr.add(map);
        List list = upr.resolve("p2");
        Assert.assertEquals((Object)"myURITwo", list.get(0));
        list = upr.resolve("p1");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"myURI1", list.get(0));
        Assert.assertEquals((Object)"myURI1bis", list.get(1));
    }

    @Test(expected=XLIFFException.class)
    public void testBadCustomPrefix_TooShort() {
        URIPrefixes upr = new URIPrefixes(new File(this.root + "/bad-prefix-tooshort.properties"));
        upr.resolve("xyz");
    }

    @Test(expected=XLIFFException.class)
    public void testBadCustomPrefix_NotNMTOKEN() {
        URIPrefixes upr = new URIPrefixes(new File(this.root + "/bad-prefix-notnmtoken.properties"));
        upr.resolve("xyz");
    }

    @Test
    public void testBadCustomPrefix_DuplicatedURIs() {
        URIPrefixes upr = new URIPrefixes(new File(this.root + "/extra-prefixes.properties"));
        List uris = upr.resolve("notTakenIntoAccount");
        Assert.assertEquals(null, (Object)uris);
        uris = upr.resolve("my");
        Assert.assertEquals((Object)"myNS", uris.get(0));
    }

    @Test
    public void testRegistryLoader() {
        URIPrefixes upr = new URIPrefixes();
        try {
            Map map = upr.loadFromRegistry();
            Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
            List uris = (List)map.get("my");
            Assert.assertTrue((null != uris ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)uris.size());
            Assert.assertEquals((Object)"http://example.org/myXLIFFExtensionURI", uris.get(0));
        }
        catch (XLIFFException e) {
            System.err.println("WARNING: Error when accessing the prefix registry: " + e.getMessage());
        }
    }
}

