/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import java.util.List;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.junit.Assert;
import org.junit.Test;

public class GeneralTest {
    @Test
    public void testAddTarget() {
        Unit unit = this.createSimpleUnit();
        Segment segment = unit.getSegment(0);
        Fragment frag = segment.getTarget(Part.GetTarget.CLONE_SOURCE);
        Assert.assertTrue((boolean)frag.equals((Object)segment.getSource()));
    }

    @Test
    public void testAccessMarkers() {
        Unit unit = this.createSimpleUnit();
        Segment segment = unit.getSegment(0);
        Fragment fragment = segment.getSource();
        String ct = fragment.getCodedText();
        for (int i = 0; i < ct.length(); ++i) {
            if (!Fragment.isChar1((char)ct.charAt(i))) continue;
            int key = Fragment.toKey((int)ct.charAt(i), (int)ct.charAt(++i));
            Tag bm = fragment.getTag(key);
            Assert.assertTrue((bm != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAccessUnsupportedModule() {
        Unit unit = this.createSimpleUnit();
        List elems = unit.getExtElements().find("urn:oasis:names:tc:xliff:glossary:2.0", "glossary");
        Assert.assertEquals((long)1L, (long)elems.size());
    }

    private Unit createSimpleUnit() {
        Unit unit = new Unit("id");
        Fragment src = unit.appendSegment().getSource();
        src.append((CharSequence)"Hello ");
        src.append(TagType.OPENING, "1", "<B>", false);
        src.append((CharSequence)"World");
        src.append(TagType.CLOSING, "1", "</B>", false);
        src.append((CharSequence)"!");
        unit.getExtAttributes().setAttribute("urn:oasis:names:tc:xliff:fs:2.0", "fs", "p");
        ExtElements elems = unit.getExtElements();
        ExtElement glossary = elems.add("urn:oasis:names:tc:xliff:glossary:2.0", "glossary", "gls");
        ExtElement glossEntry = glossary.addElement("glossEntry");
        ExtElement term = glossEntry.addElement("term");
        term.addContent("my term");
        return unit;
    }
}

