/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.List;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.ITSItems;
import net.sf.okapi.lib.xliff2.its.LocQualityIssue;
import net.sf.okapi.lib.xliff2.its.LocQualityIssues;
import net.sf.okapi.lib.xliff2.its.MTConfidence;
import net.sf.okapi.lib.xliff2.its.Provenance;
import net.sf.okapi.lib.xliff2.its.Provenances;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;

public class ITSReaderTest {
    private static final String STARTDOC = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\">";

    @Test
    public void testLQIStandOff() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\" its:annotatorsRef='localization-quality-issue|tool1'> <unit id=\"id\">  <its:locQualityIssues xml:id=\"its1\">   <its:locQualityIssue locQualityIssueType=\"grammar\"/>   <its:locQualityIssue locQualityIssueComment=\"comment\" annotatorsRef='localization-quality-issue|tool2'/>  </its:locQualityIssues>  <segment><source>source</source></segment> </unit></file></xliff>";
        Unit unit = U.getUnit(text);
        Assert.assertTrue((boolean)unit.hasITSGroup());
        Assert.assertFalse((boolean)unit.hasExtElements());
        List groups = unit.getITSGroups();
        LocQualityIssues lqIssues = (LocQualityIssues)groups.get(0);
        Assert.assertEquals((Object)"its1", (Object)lqIssues.getGroupId());
        LocQualityIssue lqi = (LocQualityIssue)lqIssues.getList().get(0);
        Assert.assertEquals((Object)"grammar", (Object)lqi.getType());
        Assert.assertEquals((Object)"tool1", (Object)lqi.getAnnotatorRef());
        lqi = (LocQualityIssue)lqIssues.getList().get(1);
        Assert.assertEquals(null, (Object)lqi.getType());
        Assert.assertEquals((Object)"comment", (Object)lqi.getComment());
        Assert.assertEquals((Object)"tool2", (Object)lqi.getAnnotatorRef());
    }

    @Test
    public void testLQIAttributes() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\" its:annotatorsRef='localization-quality-issue|myTool1'> <unit id=\"id\" its:annotatorsRef='localization-quality-issue|myTool2'>  <segment><source><mrk id='1' type='its:its' its:locQualityIssueType='grammar'  its:annotatorsRef='localization-quality-issue|myTool3' its:locQualityIssueSeverity='20' >source</mrk></source></segment> </unit></file></xliff>";
        Unit unit = U.getUnit(text);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Assert.assertTrue((boolean)am.hasITSItem());
        ITSItems items = am.getITSItems();
        LocQualityIssue lqi = (LocQualityIssue)items.get(LocQualityIssue.class);
        Assert.assertEquals((Object)"grammar", (Object)lqi.getType());
        Assert.assertEquals((double)20.0, (double)lqi.getSeverity(), (double)0.0);
        Assert.assertEquals((Object)"myTool3", (Object)lqi.getAnnotatorRef());
        Assert.assertFalse((boolean)am.hasExtAttribute());
    }

    @Test
    public void testProvStandOff() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\" its:annotatorsRef='provenance|myTool1'> <unit id=\"id\">  <its:provenanceRecords xml:id='p1'>   <its:provenanceRecord     toolRef='tool11Ref' person='person11' orgRef='org11Ref'    revTool='tool12' revPersonRef='person12Ref' revOrg='org12'    provRef='provRef11'/>   <its:provenanceRecord     tool='tool21' personRef='person21Ref' org='org21'    revToolRef='tool22Ref' revPerson='person22' revOrgRef='org22Ref'    provRef='provRef22'/>  </its:provenanceRecords>  <segment><source><mrk id='1' type='its:its' its:provenanceRecordsRef='#its=p1' >source</mrk></source></segment> </unit></file></xliff>";
        Unit unit = U.getUnit(text);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Assert.assertFalse((boolean)am.hasExtAttribute());
        Assert.assertTrue((boolean)am.hasITSItem());
        Provenances provs = (Provenances)am.getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"p1", (Object)provs.getGroupId());
        Assert.assertEquals((long)2L, (long)provs.getList().size());
        Provenance prov = (Provenance)provs.getList().get(0);
        Assert.assertEquals((Object)"tool11Ref", (Object)prov.getToolRef());
        Assert.assertEquals((Object)"tool12", (Object)prov.getRevTool());
        Assert.assertEquals((Object)"person11", (Object)prov.getPerson());
        Assert.assertEquals((Object)"person12Ref", (Object)prov.getRevPersonRef());
        Assert.assertEquals((Object)"org11Ref", (Object)prov.getOrgRef());
        Assert.assertEquals((Object)"org12", (Object)prov.getRevOrg());
        Assert.assertEquals((Object)"provRef11", (Object)prov.getProvRef());
        Assert.assertEquals((Object)"myTool1", (Object)prov.getAnnotatorRef());
    }

    @Test
    public void testProvAttributes() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\" its:annotatorsRef='provenance|myTool1'> <unit id=\"id\">  <segment><source><mrk id='1' type='its:its' its:tool='tool1' its:person='person1' its:org='org1' its:revTool='tool2' its:revPerson='person2' its:revOrg='org2' its:provRef='provRef1'>source</mrk></source></segment> </unit></file></xliff>";
        Unit unit = U.getUnit(text);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Assert.assertFalse((boolean)am.hasExtAttribute());
        Assert.assertTrue((boolean)am.hasITSItem());
        Provenance prov = (Provenance)am.getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"tool1", (Object)prov.getTool());
        Assert.assertEquals((Object)"tool2", (Object)prov.getRevTool());
        Assert.assertEquals((Object)"person1", (Object)prov.getPerson());
        Assert.assertEquals((Object)"person2", (Object)prov.getRevPerson());
        Assert.assertEquals((Object)"org1", (Object)prov.getOrg());
        Assert.assertEquals((Object)"org2", (Object)prov.getRevOrg());
        Assert.assertEquals((Object)"provRef1", (Object)prov.getProvRef());
        Assert.assertEquals((Object)"myTool1", (Object)prov.getAnnotatorRef());
    }

    @Test
    public void testProvRefAttributes() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\" its:annotatorsRef='provenance|myTool1'> <unit id=\"id\">  <segment><source><mrk id='1' type='its:its' its:toolRef='tool1' its:personRef='person1' its:orgRef='org1' its:revToolRef='tool2' its:revPersonRef='person2' its:revOrgRef='org2' >source</mrk></source></segment> </unit></file></xliff>";
        Unit unit = U.getUnit(text);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Assert.assertFalse((boolean)am.hasExtAttribute());
        Assert.assertTrue((boolean)am.hasITSItem());
        Provenance prov = (Provenance)am.getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"tool1", (Object)prov.getToolRef());
        Assert.assertEquals((Object)"tool2", (Object)prov.getRevToolRef());
        Assert.assertEquals((Object)"person1", (Object)prov.getPersonRef());
        Assert.assertEquals((Object)"person2", (Object)prov.getRevPersonRef());
        Assert.assertEquals((Object)"org1", (Object)prov.getOrgRef());
        Assert.assertEquals((Object)"org2", (Object)prov.getRevOrgRef());
        Assert.assertEquals((Object)"myTool1", (Object)prov.getAnnotatorRef());
    }

    @Test
    public void testAnnotatorsRef() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\" its:annotatorsRef='mt-confidence|refOnFile'> <unit id='id'>  <segment><source><mrk id='1' type='its:its' its:mtConfidence='0.5' >source</mrk></source></segment> </unit></file></xliff>";
        Unit unit = U.getUnit(text);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        MTConfidence ann = (MTConfidence)am.getITSItems().get(MTConfidence.class);
        Assert.assertEquals((double)0.5, (double)ann.getMtConfidence(), (double)0.0);
        Assert.assertEquals((Object)"refOnFile", (Object)ann.getAnnotatorRef());
        text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\" its:annotatorsRef='mt-confidence|refOnFile'> <unit id='id' its:annotatorsRef='mt-confidence|refOnUnit'>  <segment><source><mrk id='1' type='its:its' its:mtConfidence='0.5' >source</mrk></source></segment> </unit></file></xliff>";
        unit = U.getUnit(text);
        am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        ann = (MTConfidence)am.getITSItems().get(MTConfidence.class);
        Assert.assertEquals((Object)"refOnUnit", (Object)ann.getAnnotatorRef());
        text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\" its:annotatorsRef='mt-confidence|refOnFile'> <unit id='id' its:annotatorsRef='mt-confidence|refOnUnit'>  <segment><source><mrk id='1' type='its:its' its:mtConfidence='0.5' its:annotatorsRef='mt-confidence|refOnMrk'>source</mrk></source></segment> </unit></file></xliff>";
        unit = U.getUnit(text);
        am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        ann = (MTConfidence)am.getITSItems().get(MTConfidence.class);
        Assert.assertEquals((Object)"refOnMrk", (Object)ann.getAnnotatorRef());
    }

    @Test
    public void testRefToStandOff() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\"> <unit id=\"id\">  <its:locQualityIssues xml:id=\"its1\">   <its:locQualityIssue locQualityIssueComment=\"comment1\"/>   <its:locQualityIssue locQualityIssueComment=\"comment2\"/>  </its:locQualityIssues>  <segment><source><mrk id='1' type='its:its' its:locQualityIssuesRef='#its=its1'>source</mrk></source></segment> </unit></file></xliff>";
        Unit unit = U.getUnit(text);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Assert.assertTrue((boolean)am.hasITSItem());
        LocQualityIssues issues = (LocQualityIssues)am.getITSItems().get(LocQualityIssue.class);
        Assert.assertEquals((Object)"comment2", (Object)((LocQualityIssue)issues.getList().get(1)).getComment());
        Assert.assertFalse((boolean)unit.hasITSGroup());
    }

    @Test(expected=InvalidParameterException.class)
    public void textBadIdentifierInAnnotatorsRef() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\"> <unit id=\"id\" its:annotatorsRef=\"badIdent|value\"><segment><source>text</source></segment> </unit></file></xliff>";
        U.getEvents(text);
    }

    @Test(expected=InvalidParameterException.class)
    public void textMissingIdentifierInAnnotatorsRef() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\"> <unit id=\"id\" its:annotatorsRef=\"missing-dc-identifier\"><segment><source>text</source></segment> </unit></file></xliff>";
        U.getEvents(text);
    }

    @Test(expected=InvalidParameterException.class)
    public void textBadSeparatorInAnnotatorsRef() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\"> <unit id=\"id\" its:annotatorsRef=\"translate|uri1;terminology|uri2\"><segment><source>text</source></segment> </unit></file></xliff>";
        U.getEvents(text);
    }

    public void textAnnotatorsRefTwoValues() {
        String text = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"><file id=\"f1\"> <unit id=\"id\" its:annotatorsRef=\"provenance|tool1 translate|tool2\"><segment><source>text</source></segment> </unit></file></xliff>";
        Unit unit = U.getUnit(text);
        AnnotatorsRef ar = unit.getAnnotatorsRef();
        Assert.assertEquals((Object)"tool1", (Object)ar.get("provenance"));
        Assert.assertEquals((Object)"tool2", (Object)ar.get("translate"));
    }
}

