/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.junit.Assert;
import org.junit.Test;

public class UtilTest {
    @Test
    public void testIsValidNmtoken() {
        String supChar = new StringBuilder().appendCodePoint(134047).toString();
        Assert.assertEquals((Object)true, (Object)Util.isValidNmtoken((String)"123"));
        Assert.assertEquals((Object)true, (Object)Util.isValidNmtoken((String)"abc"));
        Assert.assertEquals((Object)true, (Object)Util.isValidNmtoken((String)"\u0100etc"));
        Assert.assertEquals((Object)true, (Object)Util.isValidNmtoken((String)".id"));
        Assert.assertEquals((Object)true, (Object)Util.isValidNmtoken((String)("id" + supChar)));
        Assert.assertEquals((Object)false, (Object)Util.isValidNmtoken((String)"#id"));
        Assert.assertEquals((Object)false, (Object)Util.isValidNmtoken((String)"val/"));
        Assert.assertEquals((Object)false, (Object)Util.isValidNmtoken((String)"id&"));
        Assert.assertEquals((Object)false, (Object)Util.isValidNmtoken((String)"~ab"));
        Assert.assertEquals((Object)false, (Object)Util.isValidNmtoken((String)"a=b"));
        Assert.assertEquals((Object)false, (Object)Util.isValidNmtoken((String)"id$"));
        Assert.assertEquals((Object)false, (Object)Util.isValidNmtoken((String)(supChar + "@")));
        Assert.assertEquals((Object)false, (Object)Util.isValidNmtoken((String)"id|"));
    }

    @Test
    public void testRemoveExtensions() {
        Unit unit = new Unit("u1");
        Segment seg = unit.appendSegment();
        seg.setSource("text");
        unit.getExtAttributes().setAttribute("myNS", "attr1", "val1");
        unit.getExtAttributes().setAttribute("urn:oasis:names:tc:xliff:fs:2.0", "fs", "p");
        unit.getExtAttributes().setAttribute("myNS", "attr3", "val3");
        unit.getExtAttributes().setAttribute("myNS", "attr4", "val4");
        unit.getExtElements().add(new ExtElement(new QName("myNS", "elem1")));
        unit.getExtElements().add(new ExtElement(new QName("myNS", "elem2")));
        unit.getExtElements().add(new ExtElement(new QName("urn:oasis:names:tc:xliff:glossary:2.0", "gloss")));
        unit.getExtElements().add(new ExtElement(new QName("myNS", "elem4")));
        Assert.assertEquals((Object)true, (Object)unit.hasExtAttribute());
        Assert.assertEquals((long)4L, (long)unit.getExtAttributes().size());
        Assert.assertEquals((Object)true, (Object)unit.hasExtElements());
        Assert.assertEquals((long)4L, (long)unit.getExtElements().size());
        Util.removeExtensions((Object)unit);
        Assert.assertEquals((long)1L, (long)unit.getExtAttributes().size());
        Assert.assertEquals((Object)"p", (Object)unit.getExtAttributeValue("urn:oasis:names:tc:xliff:fs:2.0", "fs"));
        Assert.assertEquals((long)1L, (long)unit.getExtElements().size());
        Assert.assertEquals((Object)"gloss", (Object)unit.getExtElements().get(0).getQName().getLocalPart());
    }

    @Test
    public void testLang() {
        Assert.assertTrue((Util.validateLang((String)"en") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"en-us") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"i-klingon") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"mN-cYrL-Mn") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"en-x-US") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"es-419") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"az-Arab-x-AZE-derbend") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"sl-Latn-IT-rozaj") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"zh-cmn-Hant-HK") == null ? 1 : 0) != 0);
        Assert.assertTrue((Util.validateLang((String)"en-Latn-GB-boont-r-extended-sequence-x-private") == null ? 1 : 0) != 0);
        Assert.assertFalse((Util.validateLang(null) == null ? 1 : 0) != 0);
        Assert.assertFalse((Util.validateLang((String)"") == null ? 1 : 0) != 0);
        Assert.assertFalse((Util.validateLang((String)"f-Latn") == null ? 1 : 0) != 0);
        Assert.assertFalse((Util.validateLang((String)"fra-FX") == null ? 1 : 0) != 0);
        Assert.assertFalse((Util.validateLang((String)"zh-Latm-CN") == null ? 1 : 0) != 0);
        Assert.assertFalse((Util.validateLang((String)"de-DE-1902") == null ? 1 : 0) != 0);
        Assert.assertFalse((Util.validateLang((String)"fr-shadok") == null ? 1 : 0) != 0);
    }

    @Test
    public void testSupports() {
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:matches:2.0"));
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:metadata:2.0"));
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:glossary:2.0"));
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:validation:2.0"));
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:changetracking:2.0"));
        Assert.assertFalse((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:fs:2.0"));
        Assert.assertFalse((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:resourcedata:2.0"));
        Assert.assertFalse((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:sizerestriction:2.0"));
    }

    @Test
    public void testIsValidXML() {
        Assert.assertTrue((boolean)Util.isValidInXML((int)99));
        Assert.assertTrue((boolean)Util.isValidInXML((int)0x10FFFF));
        Assert.assertFalse((boolean)Util.isValidInXML((int)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)Util.isValidInXML((int)-1879048193));
        Assert.assertFalse((boolean)Util.isValidInXML((int)0x110000));
        Assert.assertFalse((boolean)Util.isValidInXML((int)12));
    }
}

