/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import java.util.Iterator;
import net.sf.okapi.lib.xliff2.NSContext;
import org.junit.Assert;
import org.junit.Test;

public class NSContextTest {
    @Test
    public void testDefaults() {
        NSContext nsc = new NSContext();
        Assert.assertEquals((Object)"xml", (Object)nsc.getPrefix("http://www.w3.org/XML/1998/namespace"));
        Assert.assertEquals((Object)"xmlns", (Object)nsc.getPrefix("http://www.w3.org/2000/xmlns/"));
        Assert.assertEquals(null, (Object)nsc.getPrefix(""));
        Iterator iter = nsc.getPrefixes("http://www.w3.org/XML/1998/namespace");
        Assert.assertEquals(iter.next(), (Object)"xml");
        Assert.assertFalse((boolean)iter.hasNext());
        iter = nsc.getPrefixes("http://www.w3.org/2000/xmlns/");
        Assert.assertEquals(iter.next(), (Object)"xmlns");
        Assert.assertFalse((boolean)iter.hasNext());
        iter = nsc.getPrefixes("");
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((Object)"http://www.w3.org/XML/1998/namespace", (Object)nsc.getNamespaceURI("xml"));
        Assert.assertEquals((Object)"http://www.w3.org/2000/xmlns/", (Object)nsc.getNamespaceURI("xmlns"));
        Assert.assertEquals((Object)"", (Object)nsc.getNamespaceURI("not_a_prefix"));
    }

    @Test
    public void testAdd() {
        NSContext nsc = new NSContext("abc", "abcURI");
        nsc.put("xyz", "xyzURI");
        nsc.put("abc2", "abcURI");
        Assert.assertEquals((Object)"abcURI", (Object)nsc.getNamespaceURI("abc"));
        Assert.assertEquals((Object)"abcURI", (Object)nsc.getNamespaceURI("abc2"));
        Assert.assertEquals((Object)"xyz", (Object)nsc.getPrefix("xyzURI"));
        String res = nsc.getPrefix("abcURI");
        Assert.assertTrue((res.equals("abc") || res.equals("abc2") ? 1 : 0) != 0);
        Iterator iter = nsc.getPrefixes("xyzURI");
        Assert.assertEquals(iter.next(), (Object)"xyz");
        Assert.assertFalse((boolean)iter.hasNext());
        iter = nsc.getPrefixes("abcURI");
        String res1 = (String)iter.next();
        String res2 = (String)iter.next();
        Assert.assertTrue((res1.equals("abc") || res1.equals("abc2") ? 1 : 0) != 0);
        Assert.assertTrue((res2.equals("abc") || res2.equals("abc2") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)res1.equals(res2));
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertTrue((boolean)nsc.containsPair("xyz", "xyzURI"));
        Assert.assertTrue((boolean)nsc.containsPair("abc", "abcURI"));
        Assert.assertTrue((boolean)nsc.containsPair("abc2", "abcURI"));
        Assert.assertFalse((boolean)nsc.containsPair("zzz", "abcURI"));
        Assert.assertFalse((boolean)nsc.containsPair("abc", "zzzURI"));
    }
}

