/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class PatternItem {
    public static final String SAME = "<same>";
    public String source;
    public String target;
    public boolean enabled;
    public String description;
    public int severity;
    public boolean fromSource;
    public boolean singlePattern;
    private Pattern srcPat;
    private Pattern trgPat;

    public static List<PatternItem> loadFile(String path) {
        ArrayList<PatternItem> list = new ArrayList<PatternItem>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            String line = br.readLine();
            while (line != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                String[] parts = line.split("\t", -2);
                if (parts.length < 6) {
                    throw new OkapiIOException("Missing one or more tabs in line:\n" + line);
                }
                int severity = 1;
                try {
                    severity = Integer.valueOf(parts[2]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                PatternItem item = new PatternItem(parts[3], parts[4], parts[0].equals("1"), severity, parts[1].equals("1"), parts[5]);
                if (parts.length == 7) {
                    item.singlePattern = parts[6].equals("1");
                }
                list.add(item);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading pattern file.", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing pattern file.", (Throwable)e);
                }
            }
        }
        return list;
    }

    public static List<PatternItem> saveFile(String path, List<PatternItem> list) {
        String lineBreak = System.getProperty("line.separator");
        try (PrintWriter pr = new PrintWriter(path, StandardCharsets.UTF_8.name());){
            for (PatternItem item : list) {
                pr.write((item.enabled ? "1" : "0") + "\t" + (item.fromSource ? "1" : "0") + "\t" + item.severity + "\t" + item.source + "\t" + item.target + "\t" + item.description + "\t" + (item.singlePattern ? "1" : "0") + lineBreak);
            }
            pr.flush();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading pattern file.", (Throwable)e);
        }
        return list;
    }

    public PatternItem(String source, String target, boolean enabled, int severity) {
        this.create(source, target, enabled, severity, true, null);
    }

    public PatternItem(String source, String target, boolean enabled, int severity, String message) {
        this.create(source, target, enabled, severity, true, message);
    }

    public PatternItem(String source, String target, boolean enabled, int severity, boolean fromSource, String message) {
        this.create(source, target, enabled, severity, fromSource, message);
    }

    private void create(String source, String target, boolean enabled, int severity, boolean fromSource, String message) {
        this.source = source;
        this.target = target;
        this.enabled = enabled;
        this.description = message;
        this.severity = severity;
        this.fromSource = fromSource;
    }

    public void compile() {
        int p;
        if (!this.fromSource) {
            if (this.singlePattern) {
                this.srcPat = null;
            } else {
                p = this.source.indexOf("$");
                this.srcPat = this.source.contains(SAME) || p > -1 && p < this.source.length() - 1 ? null : Pattern.compile(this.source);
            }
        } else {
            this.srcPat = Pattern.compile(this.source);
        }
        if (this.fromSource) {
            if (this.singlePattern) {
                this.trgPat = null;
            } else {
                p = this.target.indexOf("$");
                this.trgPat = this.target.contains(SAME) || p > -1 && p < this.target.length() - 1 ? null : Pattern.compile(this.target);
            }
        } else {
            this.trgPat = Pattern.compile(this.target);
        }
    }

    public Pattern getSourcePattern() {
        return this.srcPat;
    }

    public Pattern getTargetPattern() {
        return this.trgPat;
    }

    public Pattern getTargetSmartPattern(Matcher srcMatcher) {
        int grpCount;
        if (this.trgPat != null) {
            return this.trgPat;
        }
        String tmp = this.target.replace(SAME, "(" + Pattern.quote(srcMatcher.group()) + ")");
        for (int i = grpCount = srcMatcher.groupCount(); i > 0; --i) {
            String grp = srcMatcher.group(i);
            tmp = tmp.replace("$" + i, grp == null ? "" : Pattern.quote(grp));
        }
        return Pattern.compile(tmp);
    }

    public Pattern getSourceSmartPattern(Matcher trgMatcher) {
        int grpCount;
        if (this.srcPat != null) {
            return this.srcPat;
        }
        String tmp = this.source.replace(SAME, "(" + Pattern.quote(trgMatcher.group()) + ")");
        for (int i = grpCount = trgMatcher.groupCount(); i > 0; --i) {
            String grp = trgMatcher.group(i);
            tmp = tmp.replace("$" + i, grp == null ? "" : Pattern.quote(grp));
        }
        return Pattern.compile(tmp);
    }
}

