/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizableChecker
extends AbstractChecker {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private NumberFormat sourceNumbers;
    private NumberFormat targetNumbers;
    private DateFormat sourceShortDates;
    private DateFormat targetShortDates;
    private DateFormat sourceMediumDates;
    private DateFormat targetMediumDates;
    private DateFormat sourceLongDates;
    private DateFormat targetLongDates;
    private DateFormat sourceFullDates;
    private DateFormat targetFullDates;
    private DateFormat sourceShortTime;
    private DateFormat targetShortTime;
    private DateFormat sourceMediumTime;
    private DateFormat targetMediumTime;
    private DateFormat sourceLongTime;
    private DateFormat targetLongTime;
    private DateFormat sourceFullTime;
    private DateFormat targetFullTime;

    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        super.startProcess(sourceLocale, targetLocale, params, issues);
        this.sourceNumbers = NumberFormat.getInstance((Locale)sourceLocale.toJavaLocale());
        this.targetNumbers = NumberFormat.getInstance((Locale)targetLocale.toJavaLocale());
        this.sourceShortDates = DateFormat.getDateInstance((int)3, (Locale)sourceLocale.toJavaLocale());
        this.targetShortDates = DateFormat.getDateInstance((int)3, (Locale)targetLocale.toJavaLocale());
        this.sourceMediumDates = DateFormat.getDateInstance((int)2, (Locale)sourceLocale.toJavaLocale());
        this.targetMediumDates = DateFormat.getDateInstance((int)2, (Locale)targetLocale.toJavaLocale());
        this.sourceLongDates = DateFormat.getDateInstance((int)1, (Locale)sourceLocale.toJavaLocale());
        this.targetLongDates = DateFormat.getDateInstance((int)1, (Locale)targetLocale.toJavaLocale());
        this.sourceFullDates = DateFormat.getDateInstance((int)0, (Locale)sourceLocale.toJavaLocale());
        this.targetFullDates = DateFormat.getDateInstance((int)0, (Locale)targetLocale.toJavaLocale());
        this.sourceShortTime = DateFormat.getTimeInstance((int)3, (Locale)sourceLocale.toJavaLocale());
        this.targetShortTime = DateFormat.getTimeInstance((int)3, (Locale)targetLocale.toJavaLocale());
        this.sourceMediumTime = DateFormat.getTimeInstance((int)2, (Locale)sourceLocale.toJavaLocale());
        this.targetMediumTime = DateFormat.getTimeInstance((int)2, (Locale)targetLocale.toJavaLocale());
        this.sourceLongTime = DateFormat.getTimeInstance((int)1, (Locale)sourceLocale.toJavaLocale());
        this.targetLongTime = DateFormat.getTimeInstance((int)1, (Locale)targetLocale.toJavaLocale());
        this.sourceFullTime = DateFormat.getTimeInstance((int)0, (Locale)sourceLocale.toJavaLocale());
        this.targetFullTime = DateFormat.getTimeInstance((int)0, (Locale)targetLocale.toJavaLocale());
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        super.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        super.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.getTrgLoc());
        if (trgCont == null || !srcCont.hasText() || !trgCont.hasText()) {
            return;
        }
        String srcOri = srcCont.getUnSegmentedContentCopy().getText();
        String trgOri = trgCont.getUnSegmentedContentCopy().getText();
        try {
            this.checkLocalizables(srcOri.trim(), trgOri.trim(), tu, trgCont);
        }
        catch (Exception e) {
            this.LOGGER.error("Error in checkLocalizables: {}", (Object)srcOri);
            throw e;
        }
        this.setAnnotationIds(srcCont, trgCont);
    }

    private void checkLocalizables(String srcOri, String trgOri, ITextUnit tu, TextContainer trgCont) {
        Set<Localizable> trgNumbers;
        Set<Localizable> srcNumbers;
        Set<Localizable> srcDates = this.findDates(srcOri, this.sourceFullDates);
        Set<Localizable> trgDates = this.findDates(trgOri, this.targetFullDates);
        srcDates.addAll(this.findDates(srcOri, this.sourceLongDates));
        trgDates.addAll(this.findDates(trgOri, this.targetLongDates));
        srcDates.addAll(this.findDates(srcOri, this.sourceMediumDates));
        trgDates.addAll(this.findDates(trgOri, this.targetMediumDates));
        srcDates.addAll(this.findDates(srcOri, this.sourceShortDates));
        trgDates.addAll(this.findDates(trgOri, this.targetShortDates));
        if (!srcDates.equals(trgDates)) {
            for (Localizable loc : srcDates) {
                if (trgDates.contains(loc)) continue;
                this.logIssue(IssueType.SUSPECT_DATE_TIME, tu, loc, trgCont);
            }
        }
        Set<Localizable> srcTimes = this.findTimes(srcOri, this.sourceFullTime, srcDates);
        Set<Localizable> trgTimes = this.findTimes(trgOri, this.targetFullTime, trgDates);
        srcTimes.addAll(this.findTimes(srcOri, this.sourceLongTime, srcDates));
        trgTimes.addAll(this.findTimes(trgOri, this.targetLongTime, trgDates));
        srcTimes.addAll(this.findTimes(srcOri, this.sourceMediumTime, srcDates));
        trgTimes.addAll(this.findTimes(trgOri, this.targetMediumTime, trgDates));
        srcTimes.addAll(this.findTimes(srcOri, this.sourceShortTime, srcDates));
        trgTimes.addAll(this.findTimes(trgOri, this.targetShortTime, trgDates));
        if (!srcTimes.equals(trgTimes)) {
            for (Localizable loc : srcTimes) {
                if (trgTimes.contains(loc)) continue;
                this.logIssue(IssueType.SUSPECT_DATE_TIME, tu, loc, trgCont);
            }
        }
        if (!(srcNumbers = this.findNumbers(srcOri, this.sourceNumbers, srcDates, srcTimes)).equals(trgNumbers = this.findNumbers(trgOri, this.targetNumbers, trgDates, trgTimes))) {
            for (Localizable loc : srcNumbers) {
                if (trgNumbers.contains(loc)) continue;
                this.logIssue(IssueType.SUSPECT_NUMBER, tu, loc, trgCont);
            }
        }
    }

    private Set<Localizable> findDates(String text, DateFormat parser) {
        ParsePosition pos = new ParsePosition(0);
        HashSet<Localizable> dates = new HashSet<Localizable>();
        for (int i = 0; i < text.length() && pos.getIndex() < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            pos.setIndex(i);
            Date d = parser.parse(text, pos);
            if (d == null) continue;
            dates.add(new Localizable(d, text.substring(i, pos.getIndex()), i));
            i = pos.getIndex();
        }
        return dates;
    }

    private Set<Localizable> findTimes(String text, DateFormat parser, Set<Localizable> dates) {
        ParsePosition pos = new ParsePosition(0);
        HashSet<Localizable> times = new HashSet<Localizable>();
        for (int i = 0; i < text.length() && pos.getIndex() < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i)) || this.alreadyParsed(i, dates)) continue;
            pos.setIndex(i);
            Date d = parser.parse(text, pos);
            if (d == null) continue;
            times.add(new Localizable(d, text.substring(i, pos.getIndex()), i));
            i = pos.getIndex();
        }
        return times;
    }

    private Set<Localizable> findNumbers(String text, NumberFormat parser, Set<Localizable> dates, Set<Localizable> times) {
        ParsePosition pos = new ParsePosition(0);
        HashSet<Localizable> numbers = new HashSet<Localizable>();
        for (int i = 0; i < text.length() && pos.getIndex() < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i)) || this.alreadyParsed(i, dates) || this.alreadyParsed(i, times)) continue;
            pos.setIndex(i);
            Number n = parser.parse(text, pos);
            if (n == null) continue;
            numbers.add(new Localizable(n, text.substring(i, pos.getIndex()), i));
            i = pos.getIndex();
        }
        return numbers;
    }

    private void logIssue(IssueType issueType, ITextUnit tu, Localizable loc, TextContainer tc) {
        this.addAnnotationAndReportIssue(issueType, tu, tc, null, String.format("Number, date or time may be missing or not properly localized: '%s'", loc.original), loc.position, loc.original.length() + loc.position, 0, -1, 50.0, tu.getSource().toString(), tc.toString(), null);
    }

    private boolean alreadyParsed(int i, Set<Localizable> datesOrTimes) {
        for (Localizable loc : datesOrTimes) {
            if (i < loc.position || i > loc.original.length() + loc.position) continue;
            return true;
        }
        return false;
    }

    private class Localizable {
        Number number;
        Date date;
        String original;
        int position;

        public Localizable(Number number, String original, int position) {
            this(original, position);
            this.number = number;
        }

        public Localizable(Date date, String original, int position) {
            this(original, position);
            this.date = date;
        }

        private Localizable(String original, int position) {
            this.original = original;
            this.position = position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
            result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Localizable)) {
                return false;
            }
            Localizable other = (Localizable)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
                return false;
            }
            return !(this.number == null ? other.number != null : !this.number.equals(other.number));
        }

        public String toString() {
            return "Localizable [number=" + this.number + ", date=" + this.date + "]";
        }

        private LocalizableChecker getOuterType() {
            return LocalizableChecker.this;
        }
    }
}

