/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.annotation.SkipCheckAnnotation;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;

public class LengthChecker
extends AbstractChecker {
    private CharsetEncoder encoder2 = null;

    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        super.startProcess(sourceLocale, targetLocale, params, issues);
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        super.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        super.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.getTrgLoc());
        if (trgCont == null) {
            return;
        }
        if (this.getParams().getCheckStorageSize()) {
            this.checkStorageSize(tu, trgCont);
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg;
            if (srcSeg.getAnnotation(SkipCheckAnnotation.class) != null || (trgSeg = trgSegs.get(srcSeg.getId())) == null || !this.getParams().getCheckMaxCharLength() && !this.getParams().getCheckMinCharLength() && !this.getParams().getCheckAbsoluteMaxCharLength() || trgSeg.text.isEmpty()) continue;
            this.checkLengths(srcSeg, trgSeg, tu);
        }
        this.setAnnotationIds(srcCont, trgCont);
    }

    private void checkStorageSize(ITextUnit tu, TextContainer trgTc) {
        if (trgTc == null) {
            return;
        }
        GenericAnnotations anns = (GenericAnnotations)trgTc.getAnnotation(GenericAnnotations.class);
        if (anns == null) {
            return;
        }
        GenericAnnotation ga = anns.getFirstAnnotation("its-storagesize");
        if (ga == null) {
            return;
        }
        try {
            CharBuffer cbuf;
            int max = ga.getInteger("storagesizeSize");
            String enc = ga.getString("storagesizeEncoding");
            if (this.encoder2 == null || !this.encoder2.charset().name().equals(enc)) {
                this.encoder2 = Charset.forName(enc).newEncoder();
            }
            String lb = ga.getString("storagesizeLinebreak");
            TextFragment tf = trgTc.contentIsOneSegment() ? trgTc.getFirstContent() : trgTc.getUnSegmentedContentCopy();
            String tmp = TextUnitUtil.getText((TextFragment)tf);
            if (lb.equals("crlf")) {
                tmp = tmp.replaceAll("\n", "\r\n");
            }
            if (!this.encoder2.canEncode((CharSequence)(cbuf = CharBuffer.wrap(tmp)))) {
                this.addAnnotationAndReportIssue(IssueType.TARGET_LENGTH, tu, trgTc, null, String.format("Cannot encode one or more characters of the target using %s.", enc), 0, -1, 0, -1, 100.0, this.getDisplay(tu.getSource()), this.getDisplay(trgTc), null);
                return;
            }
            ByteBuffer buf = this.encoder2.encode(cbuf);
            int len = buf.limit();
            Object bom = "";
            if (len > 2) {
                bom = (String)bom + buf.get(0);
                if (((String)(bom = (String)bom + buf.get(1))).equals("-2-1") || ((String)bom).equals("-1-2")) {
                    len -= 2;
                }
                if (len > 3) {
                    bom = (String)bom + buf.get(2);
                    if (((String)(bom = (String)bom + buf.get(3))).endsWith("00-2-1")) {
                        len -= 4;
                    } else if (((String)bom).equals("-1-200")) {
                        len -= 2;
                    }
                }
            }
            if (len > max) {
                this.addAnnotationAndReportIssue(IssueType.TARGET_LENGTH, tu, trgTc, null, String.format("Number of bytes in the target (using %s) is: %d. Number allowed: %d.", enc, len, max), 0, -1, 0, -1, 100.0, this.getDisplay(tu.getSource()), this.getDisplay(trgTc), null);
            }
        }
        catch (Throwable e) {
            this.addAnnotationAndReportIssue(IssueType.TARGET_LENGTH, tu, trgTc, null, "Problem when trying use use ITS storage size property: " + e.getMessage(), 0, -1, 0, -1, 100.0, tu.getSource().toString(), trgTc.toString(), null);
        }
    }

    private void checkLengths(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        int n;
        int max;
        int srcLen = TextUnitUtil.getText((TextFragment)srcSeg.text, null).length();
        int trgLen = TextUnitUtil.getText((TextFragment)trgSeg.text, null).length();
        if (this.getParams().getCheckAbsoluteMaxCharLength() && trgLen > (max = this.getParams().getAbsoluteMaxCharLength())) {
            n = trgLen - max;
            this.addAnnotationAndReportIssue(IssueType.TARGET_LENGTH, tu, tu.getTarget(this.getTrgLoc()), srcSeg.getId(), String.format("The target is longer than %d (by %d).", max, n), 0, -1, this.getParams().getUseGenericCodes() ? LengthChecker.fromFragmentToGeneric(trgSeg.getContent(), max) : max, this.getParams().getUseGenericCodes() ? LengthChecker.fromFragmentToGeneric(trgSeg.getContent(), trgLen) : trgLen, 100.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), null);
        }
        if (this.getParams().getCheckMaxCharLength()) {
            if (srcLen <= this.getParams().getMaxCharLengthBreak()) {
                n = srcLen == 0 ? 0 : srcLen * this.getParams().getMaxCharLengthBelow() / 100;
            } else {
                int n2 = n = srcLen == 0 ? 0 : srcLen * this.getParams().getMaxCharLengthAbove() / 100;
            }
            if (trgLen > n) {
                double d = (double)trgLen / (srcLen == 0 ? 1.0 : (double)srcLen) * 100.0;
                this.addAnnotationAndReportIssue(IssueType.TARGET_LENGTH, tu, tu.getTarget(this.getTrgLoc()), srcSeg.getId(), String.format("The target is suspiciously longer than its source (%.2f%% of the source).", d), 0, -1, 0, -1, 1.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), null);
            }
        }
        if (this.getParams().getCheckMinCharLength()) {
            if (srcLen <= this.getParams().getMinCharLengthBreak()) {
                n = srcLen == 0 ? 0 : srcLen * this.getParams().getMinCharLengthBelow() / 100;
            } else {
                int n3 = n = srcLen == 0 ? 0 : srcLen * this.getParams().getMinCharLengthAbove() / 100;
            }
            if (trgSeg.text.getCodedText().length() < n) {
                double d = (double)trgLen / (srcLen == 0 ? 1.0 : (double)srcLen) * 100.0;
                this.addAnnotationAndReportIssue(IssueType.TARGET_LENGTH, tu, tu.getTarget(this.getTrgLoc()), srcSeg.getId(), String.format("The target is suspiciously shorter than its source (%.2f%% of the source).", d), 0, -1, 0, -1, 1.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), null);
            }
        }
    }
}

