/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.verification.Issue;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class LanguageToolConnector {
    private ArrayList<Issue> issues = new ArrayList();
    private String lang;
    private String motherTongue;
    private String serverUrl;
    private boolean bilingualMode;
    private JSONParser jsonParser = new JSONParser();

    public void initialize(LocaleId locId, LocaleId motherLocId, String serverUrl, boolean bilingualMode) {
        this.lang = locId.getLanguage();
        this.motherTongue = motherLocId.getLanguage();
        if (!((String)serverUrl).endsWith("/")) {
            serverUrl = (String)serverUrl + "/";
        }
        this.serverUrl = serverUrl;
        this.bilingualMode = bilingualMode;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    protected JSONObject sendRequest(URL url) throws IOException, ParseException {
        URLConnection conn = url.openConnection();
        return (JSONObject)this.jsonParser.parse((Reader)new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
    }

    public int checkSegment(URI docId, String subDocId, Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        this.issues.clear();
        if (!trgSeg.text.hasText()) {
            return 0;
        }
        String ctext = trgSeg.text.getCodedText();
        try {
            URL url = this.bilingualMode ? new URL(this.serverUrl + String.format("v2/check?language=%s&text=%s&srctext=%s&motherTongue=%s", this.lang, URLEncoder.encode(ctext, "UTF-8"), URLEncoder.encode(srcSeg.text.getCodedText(), "UTF-8"), this.motherTongue)) : new URL(this.serverUrl + String.format("v2/check?language=%s&text=%s", this.lang, URLEncoder.encode(ctext, "UTF-8")));
            JSONObject object = this.sendRequest(url);
            JSONArray matches = (JSONArray)object.get((Object)"matches");
            for (Object match : matches) {
                JSONObject error = (JSONObject)match;
                String msg = (String)error.get((Object)"message");
                Long start = (Long)error.get((Object)"offset");
                Long end = start + (Long)error.get((Object)"length");
                Issue issue = new Issue(docId, subDocId, IssueType.LANGUAGETOOL_ERROR, tu.getId(), trgSeg.getId(), msg, 0, 0, TextFragment.fromFragmentToString((TextFragment)trgSeg.text, (int)start.intValue()), TextFragment.fromFragmentToString((TextFragment)trgSeg.text, (int)end.intValue()), 1.0, tu.getName());
                this.issues.add(issue);
                JSONObject rule = (JSONObject)error.get((Object)"rule");
                String itsType = (String)rule.get((Object)"issueType");
                if (itsType == null) continue;
                issue.setString("lqiType", itsType);
            }
        }
        catch (Throwable e) {
            this.issues.add(new Issue(docId, subDocId, IssueType.LANGUAGETOOL_ERROR, tu.getId(), trgSeg.getId(), "Error with LanguageTool server. All LT checks are skipped from this text unit on. " + e.getMessage(), 0, -99, 0, -1, 2.0, tu.getName()));
        }
        return this.issues.size();
    }
}

