/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.annotation.SkipCheckAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;

public class InlineCodesChecker
extends AbstractChecker {
    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        super.startProcess(sourceLocale, targetLocale, params, issues);
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        super.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        super.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.getTrgLoc());
        if (trgCont == null) {
            return;
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg;
            if (srcSeg.getAnnotation(SkipCheckAnnotation.class) != null || (trgSeg = trgSegs.get(srcSeg.getId())) == null || !this.getParams().getCodeDifference()) continue;
            this.checkInlineCodes(srcSeg, trgSeg, tu, trgCont);
        }
        this.setAnnotationIds(srcCont, trgCont);
    }

    private ArrayList<Code> stripNoiseCodes(Segment seg) {
        ArrayList<Code> list = new ArrayList<Code>(seg.text.getCodes());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Code code = (Code)iter.next();
            if (!this.getParams().getTypesToIgnore().contains(code.getType() + ";") || code.getType().isEmpty()) continue;
            iter.remove();
        }
        return list;
    }

    private String buildCodeList(List<Code> list) {
        StringBuilder tmp = new StringBuilder();
        for (Code code : list) {
            if (tmp.length() > 0) {
                tmp.append(", ");
            }
            if (this.getParams().getUseGenericCodes()) {
                switch (code.getTagType()) {
                    case PLACEHOLDER: {
                        tmp.append("<" + code.getId() + "/>");
                        break;
                    }
                    case OPENING: {
                        tmp.append("<" + code.getId() + ">");
                        break;
                    }
                    case CLOSING: {
                        tmp.append("</" + code.getId() + ">");
                    }
                }
                continue;
            }
            if (code.getData().isEmpty()) {
                tmp.append(code.getOuterData().replaceAll("></x>", "/>"));
                continue;
            }
            tmp.append("\"" + code.getData() + "\"");
        }
        return tmp.toString();
    }

    private String buildOpenCloseSequence(ArrayList<Code> list) {
        StringBuilder sb = new StringBuilder();
        for (Code code : list) {
            switch (code.getTagType()) {
                case OPENING: {
                    sb.append("o");
                    break;
                }
                case CLOSING: {
                    sb.append("c");
                    break;
                }
                case PLACEHOLDER: {
                    String tmp = code.getData();
                    int ch = 112;
                    if (!Util.isEmpty((String)tmp) && this.getParams().getGuessOpenClose()) {
                        if (tmp.startsWith("</")) {
                            ch = 99;
                        } else if (tmp.startsWith("<")) {
                            ch = 111;
                        }
                        if (tmp.endsWith("/>")) {
                            ch = 112;
                        }
                    }
                    sb.append((char)ch);
                }
            }
        }
        return sb.toString();
    }

    private List<SimpleCode> buildSimpleCodeslist(ArrayList<Code> list) {
        ArrayList<SimpleCode> simpleCodesList = new ArrayList<SimpleCode>(list.size());
        list.forEach(code -> {
            SimpleCode sc = new SimpleCode((Code)code);
            switch (code.getTagType()) {
                case OPENING: 
                case CLOSING: {
                    break;
                }
                case PLACEHOLDER: {
                    String tmp = code.getData();
                    TextFragment.TagType tt = TextFragment.TagType.PLACEHOLDER;
                    if (!Util.isEmpty((String)tmp) && this.getParams().getGuessOpenClose()) {
                        if (tmp.startsWith("</")) {
                            tt = TextFragment.TagType.CLOSING;
                        } else if (tmp.startsWith("<")) {
                            tt = TextFragment.TagType.OPENING;
                        }
                        if (tmp.endsWith("/>")) {
                            tt = TextFragment.TagType.PLACEHOLDER;
                        }
                    }
                    sc.type = tt;
                }
            }
            simpleCodesList.add(sc);
        });
        return simpleCodesList;
    }

    private void checkInlineCodes(Segment srcSeg, Segment trgSeg, ITextUnit tu, TextContainer trgCont) {
        Iterator<Code> iter;
        ArrayList<Code> srcList = this.stripNoiseCodes(srcSeg);
        ArrayList<Code> trgList = this.stripNoiseCodes(trgSeg);
        if (srcList.isEmpty() && trgList.isEmpty()) {
            return;
        }
        String srcOC = null;
        String trgOC = null;
        List<SimpleCode> srcSimpleCodes = null;
        List<SimpleCode> trgSimpleCodes = null;
        if (this.getParams().getStrictCodeOrder()) {
            srcSimpleCodes = this.buildSimpleCodeslist(srcList);
            trgSimpleCodes = this.buildSimpleCodeslist(trgList);
        } else {
            srcOC = this.buildOpenCloseSequence(srcList);
            trgOC = this.buildOpenCloseSequence(trgList);
        }
        boolean checkOC = true;
        Iterator<Code> srcIter = srcList.iterator();
        block0: while (srcIter.hasNext()) {
            Code srcCode = srcIter.next();
            Iterator<Code> trgIter = trgList.iterator();
            while (trgIter.hasNext()) {
                boolean okToRemove;
                Code trgCode = trgIter.next();
                if (trgCode.getId() != srcCode.getId() || !trgCode.getType().equals(srcCode.getType())) continue;
                boolean bl = okToRemove = trgCode.getData().isEmpty() && srcCode.getData().isEmpty();
                if (!okToRemove) {
                    if (trgCode.getData().equals(srcCode.getData())) {
                        okToRemove = true;
                    } else if (trgCode.getTagType() == TextFragment.TagType.CLOSING && srcCode.getTagType() == TextFragment.TagType.OPENING || trgCode.getTagType() == TextFragment.TagType.OPENING && srcCode.getTagType() == TextFragment.TagType.CLOSING) {
                        okToRemove = true;
                    }
                }
                if (!okToRemove) continue block0;
                trgIter.remove();
                srcIter.remove();
                continue block0;
            }
        }
        if (!srcList.isEmpty()) {
            iter = srcList.iterator();
            while (iter.hasNext()) {
                Code trgCode = iter.next();
                if (this.getParams().missingCodesAllowed.contains(trgCode.getData())) {
                    iter.remove();
                    continue;
                }
                if (!trgCode.isDeleteable()) continue;
                iter.remove();
            }
        }
        if (!srcList.isEmpty()) {
            this.addAnnotationAndReportIssue(IssueType.MISSING_CODE, tu, trgCont, srcSeg.getId(), "Missing placeholders in the target: " + this.buildCodeList(srcList), 0, -1, 0, -1, 50.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), srcList);
            checkOC = false;
        }
        if (!trgList.isEmpty()) {
            iter = trgList.iterator();
            while (iter.hasNext()) {
                Code srcCode = iter.next();
                if (this.getParams().extraCodesAllowed.contains(srcCode.getData())) {
                    iter.remove();
                    continue;
                }
                if (!srcCode.isDeleteable()) continue;
                iter.remove();
            }
        }
        if (!trgList.isEmpty()) {
            this.addAnnotationAndReportIssue(IssueType.EXTRA_CODE, tu, trgCont, srcSeg.getId(), "Extra placeholders in the target: " + this.buildCodeList(trgList), 0, -1, 0, -1, 50.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), trgList);
            checkOC = false;
        }
        if (checkOC && !this.getParams().getStrictCodeOrder()) {
            int j = 0;
            boolean done = false;
            for (int i = 0; i < srcOC.length(); ++i) {
                block27: {
                    if (srcOC.charAt(i) == 'p') continue;
                    while (true) {
                        if (trgOC.length() <= j) {
                            this.addAnnotationAndReportIssue(IssueType.SUSPECT_CODE, tu, trgCont, srcSeg.getId(), "Suspect sequence of opening and closing target placeholders.", 0, -1, 0, -1, 50.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), trgList);
                            done = true;
                            break block27;
                        }
                        if (trgOC.charAt(j) != 'p') break;
                        ++j;
                    }
                    if (trgOC.charAt(j) != srcOC.charAt(i)) {
                        this.addAnnotationAndReportIssue(IssueType.SUSPECT_CODE, tu, trgCont, srcSeg.getId(), String.format("Suspect sequence of opening and closing placeholders in the target (placeholder %d).", i + 1), 0, -1, 0, -1, 50.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), trgList);
                        done = true;
                    } else {
                        ++j;
                    }
                }
                if (done) break;
            }
        }
        if (checkOC && this.getParams().getStrictCodeOrder()) {
            int j = 0;
            for (int i = 0; i < srcSimpleCodes.size(); ++i) {
                SimpleCode srcSC = srcSimpleCodes.get(i);
                if (trgSimpleCodes.size() <= j) {
                    if (srcSC.isDeleteable) continue;
                    this.addAnnotationAndReportIssue(IssueType.SUSPECT_CODE, tu, trgCont, srcSeg.getId(), "Suspect sequence of target inline codes.", 0, -1, 0, -1, 50.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), trgList);
                    break;
                }
                SimpleCode trgSC = trgSimpleCodes.get(j);
                if (srcSC.type != trgSC.type || srcSC.id != trgSC.id) {
                    if (srcSC.isDeleteable) continue;
                    this.addAnnotationAndReportIssue(IssueType.SUSPECT_CODE, tu, trgCont, srcSeg.getId(), String.format("Suspect sequence of codes in target: source code ID=%d (%s), target code ID=%d (%s)).", srcSC.id, srcSC.type, trgSC.id, trgSC.type), 0, -1, 0, -1, 50.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), trgList);
                    break;
                }
                ++j;
            }
        }
    }

    private static class SimpleCode {
        TextFragment.TagType type;
        int id;
        boolean isDeleteable;

        SimpleCode(Code code) {
            this.type = code.getTagType();
            this.id = code.getId();
            this.isDeleteable = code.isDeleteable();
        }
    }
}

