/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.annotation.SkipCheckAnnotation;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;

public class GeneralChecker
extends AbstractChecker {
    private String doubledWordExceptions;
    private BreakIterator breakIterator;
    private static final Pattern UWHITESPACE = Pattern.compile("[\\t\\v\\n\\f\\r\\p{Z}]+");

    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        super.startProcess(sourceLocale, targetLocale, params, issues);
        if (params.getDoubledWord()) {
            this.breakIterator = BreakIterator.getWordInstance((ULocale)targetLocale.toIcuLocale());
            this.doubledWordExceptions = ";" + params.getDoubledWordExceptions().toLowerCase() + ";";
        }
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        super.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        super.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.getTrgLoc());
        if (trgCont == null) {
            if (!this.isMonolingual()) {
                this.addAnnotationAndReportIssue(IssueType.MISSING_TARGETTU, tu, tu.getSource(), null, "Missing translation.", 0, -1, 0, -1, 100.0, this.getDisplay(srcCont), "", null);
            }
            return;
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcSegs) {
            if (srcSeg.getAnnotation(SkipCheckAnnotation.class) != null) continue;
            Segment trgSeg = trgSegs.get(srcSeg.getId());
            if (trgSeg == null) {
                this.addAnnotationAndReportIssue(IssueType.MISSING_TARGETSEG, tu, srcCont, srcSeg.getId(), "The source segment has no corresponding target segment.", 0, -1, 0, -1, 100.0, this.getDisplay(srcSeg.getContent()), "", null);
                continue;
            }
            if (this.getParams().getEmptyTarget() && trgSeg.text.isEmpty() && !srcSeg.text.isEmpty()) {
                this.addAnnotationAndReportIssue(IssueType.EMPTY_TARGETSEG, tu, srcCont, srcSeg.getId(), "The target segment is empty, but its source is not empty.", 0, -1, 0, -1, 100.0, this.getDisplay(srcSeg.getContent()), "", null);
                continue;
            }
            if (this.getParams().getEmptySource() && srcSeg.text.isEmpty() && !trgSeg.text.isEmpty()) {
                this.addAnnotationAndReportIssue(IssueType.EMPTY_SOURCESEG, tu, srcCont, srcSeg.getId(), "The target segment is not empty, but its source is empty.", 0, -1, 0, -1, 100.0, this.getDisplay(srcSeg.getContent()), "", null);
                continue;
            }
            List<PatternItem> patterns = null;
            if (this.getParams().getCheckPatterns()) {
                patterns = this.getParams().getPatterns();
                boolean hasSame = false;
                for (PatternItem item : patterns) {
                    if (!item.enabled) continue;
                    if (item.target != null && item.target.equals("<same>")) {
                        hasSame = true;
                    }
                    item.compile();
                }
                if (!hasSame) {
                    patterns = null;
                }
            }
            if (this.getParams().getTargetSameAsSource() && (this.getParams().getTargetSameAsSourceForSameLanguage() || !this.getSrcLoc().sameLanguageAs(this.getTrgLoc())) && this.hasMeaningfullText(srcSeg.text) && srcSeg.text.compareTo(trgSeg.text, this.getParams().getTargetSameAsSourceWithCodes() ? TextFragment.CompareMode.CODE_DATA_ONLY : TextFragment.CompareMode.IGNORE_CODE) == 0) {
                boolean warn = true;
                if (patterns != null) {
                    for (PatternItem item : patterns) {
                        Matcher m;
                        String ctext = srcSeg.text.getCodedText();
                        if (!item.enabled || item.target == null || !item.target.equals("<same>") || !(m = item.getSourcePattern().matcher(ctext)).find()) continue;
                        warn = !ctext.equals(m.group());
                        break;
                    }
                }
                if (warn) {
                    this.addAnnotationAndReportIssue(IssueType.TARGET_SAME_AS_SOURCE, tu, srcCont, srcSeg.getId(), "Translation is the same as the source.", 0, -1, 0, -1, 50.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), null);
                }
            }
            this.checkSuspectPatterns(srcSeg, trgSeg, tu);
        }
        for (Segment trgSeg : trgSegs) {
            Segment srcSeg;
            if (trgSeg.getAnnotation(SkipCheckAnnotation.class) != null || (srcSeg = srcSegs.get(trgSeg.getId())) != null) continue;
            this.addAnnotationAndReportIssue(IssueType.EXTRA_TARGETSEG, tu, trgCont, trgSeg.getId(), String.format("Extra target segment (id=%s).", trgSeg.getId()), 0, -1, 0, -1, 100.0, "", this.getDisplay(trgSeg.getContent()), null);
        }
        Segment firstSeg = srcSegs.get(0);
        Segment lastSeg = srcSegs.getLast();
        if (firstSeg.getAnnotation(SkipCheckAnnotation.class) == null || lastSeg.getAnnotation(SkipCheckAnnotation.class) == null) {
            TextFragment srcFrag = null;
            srcFrag = srcCont.contentIsOneSegment() ? srcCont.getFirstContent() : srcCont.getUnSegmentedContentCopy();
            TextFragment trgFrag = null;
            trgFrag = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
            this.checkWhiteSpaces(srcFrag, trgFrag, tu, firstSeg.getId(), lastSeg.getId());
        }
        this.setAnnotationIds(srcCont, trgCont);
    }

    private boolean hasMeaningfullText(TextFragment frag) {
        if (this.getParams().getTargetSameAsSourceWithNumbers()) {
            return WORDCHARS.matcher(frag.getCodedText()).find();
        }
        return WORDCHARS_NONUMBERS.matcher(frag.getCodedText()).find();
    }

    private boolean isSpaceWeCareAbout(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    private void checkWhiteSpaces(TextFragment srcFrag, TextFragment trgFrag, ITextUnit tu, String firstSegId, String lastSegId) {
        String srcCT = srcFrag.getCodedText();
        String trgCT = trgFrag.getCodedText();
        if (this.getParams().getLeadingWS()) {
            int pos;
            int i;
            if (trgCT.length() == 0) {
                return;
            }
            for (i = 0; i < srcCT.length() && this.isSpaceWeCareAbout(srcCT.charAt(i)); ++i) {
                if (srcCT.length() > i) {
                    if (trgCT.length() - 1 >= i && trgCT.charAt(i) == srcCT.charAt(i)) continue;
                    pos = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(srcFrag, i) : i;
                    this.addAnnotationAndReportIssue(IssueType.MISSINGORDIFF_LEADINGWS, tu, tu.getSource(), firstSegId, String.format("Missing or different leading white space at position %d.", pos), pos, pos + 1, 0, -1, 1.0, this.getDisplay(srcFrag), this.getDisplay(trgFrag), null);
                    break;
                }
                pos = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(srcFrag, i) : i;
                this.addAnnotationAndReportIssue(IssueType.MISSING_LEADINGWS, tu, tu.getSource(), firstSegId, String.format("Missing leading white space at position %d.", pos), pos, pos + 1, 0, -1, 1.0, this.getDisplay(srcFrag), this.getDisplay(trgFrag), null);
            }
            for (i = 0; i < trgCT.length() && this.isSpaceWeCareAbout(trgCT.charAt(i)); ++i) {
                if (srcCT.length() > i) {
                    if (srcCT.length() - 1 >= i && srcCT.charAt(i) == trgCT.charAt(i)) continue;
                    pos = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(trgFrag, i) : i;
                    this.addAnnotationAndReportIssue(IssueType.EXTRAORDIFF_LEADINGWS, tu, tu.getTarget(this.getTrgLoc()), firstSegId, String.format("Extra or different leading white space at position %d.", pos), 0, -1, pos, pos + 1, 1.0, this.getDisplay(srcFrag), this.getDisplay(trgFrag), null);
                    break;
                }
                pos = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(trgFrag, i) : i;
                this.addAnnotationAndReportIssue(IssueType.EXTRA_LEADINGWS, tu, tu.getTarget(this.getTrgLoc()), firstSegId, String.format("Extra leading white space at position %d.", pos), 0, -1, pos, pos + 1, 1.0, this.getDisplay(srcFrag), this.getDisplay(trgFrag), null);
            }
        }
        if (this.getParams().getTrailingWS()) {
            int pos;
            int i;
            int j = trgCT.length() - 1;
            for (i = srcCT.length() - 1; i >= 0 && this.isSpaceWeCareAbout(srcCT.charAt(i)); --i) {
                if (j >= 0) {
                    int n = pos = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(srcFrag, i) : i;
                    if (trgCT.length() - 1 < j || trgCT.charAt(j) != srcCT.charAt(i)) {
                        this.addAnnotationAndReportIssue(IssueType.MISSINGORDIFF_TRAILINGWS, tu, tu.getSource(), lastSegId, String.format("Missing or different trailing white space at position %d", pos), pos, pos + 1, 0, -1, 1.0, this.getDisplay(srcFrag), this.getDisplay(trgFrag), null);
                        break;
                    }
                } else {
                    pos = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(srcFrag, i) : i;
                    this.addAnnotationAndReportIssue(IssueType.MISSING_TRAILINGWS, tu, tu.getSource(), lastSegId, String.format("Missing trailing white space at position %d.", pos), pos, pos + 1, 0, -1, 1.0, this.getDisplay(srcFrag), this.getDisplay(trgFrag), null);
                }
                --j;
            }
            j = srcCT.length() - 1;
            for (i = trgCT.length() - 1; i >= 0 && this.isSpaceWeCareAbout(trgCT.charAt(i)); --i) {
                if (j >= 0) {
                    if (srcCT.length() - 1 < j || srcCT.charAt(j) != trgCT.charAt(i)) {
                        pos = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(trgFrag, i) : i;
                        this.addAnnotationAndReportIssue(IssueType.EXTRAORDIFF_TRAILINGWS, tu, tu.getTarget(this.getTrgLoc()), lastSegId, String.format("Extra or different trailing white space at position %d.", pos), 0, -1, pos, pos + 1, 1.0, this.getDisplay(srcFrag), this.getDisplay(trgFrag), null);
                        break;
                    }
                } else {
                    pos = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(trgFrag, i) : i;
                    this.addAnnotationAndReportIssue(IssueType.EXTRA_TRAILINGWS, tu, tu.getTarget(this.getTrgLoc()), lastSegId, String.format("Extra white trailing space at position %d.", pos), 0, -1, pos, pos + 1, 1.0, this.getDisplay(srcFrag), this.getDisplay(trgFrag), null);
                }
                --j;
            }
        }
    }

    private void checkSuspectPatterns(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        String trgCText = trgSeg.text.getCodedText();
        if (this.getParams().getDoubledWord()) {
            this.breakIterator.setText(trgCText);
            int previousPosition = this.breakIterator.first();
            int currentPosition = this.breakIterator.next();
            String previousWord = null;
            while (currentPosition != -1) {
                String currentWord = trgCText.substring(previousPosition, currentPosition);
                if (this.breakIterator.getRuleStatus() > 100) {
                    if (currentWord.equals(previousWord)) {
                        if (!this.doubledWordExceptions.contains(";" + currentWord.toLowerCase() + ";")) {
                            int dispStart = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(trgSeg.text, previousPosition) : TextFragment.fromFragmentToString((TextFragment)trgSeg.text, (int)previousPosition);
                            int dispEnd = this.getParams().getUseGenericCodes() ? GeneralChecker.fromFragmentToGeneric(trgSeg.text, currentPosition) : TextFragment.fromFragmentToString((TextFragment)trgSeg.text, (int)currentPosition);
                            this.addAnnotationAndReportIssue(IssueType.SUSPECT_PATTERN, tu, tu.getTarget(this.getTrgLoc()), srcSeg.getId(), String.format("Double word: \"%s\" found in the target.", currentWord), 0, -1, dispStart, dispEnd, 100.0, this.getDisplay(srcSeg.getContent()), this.getDisplay(trgSeg.getContent()), null);
                        }
                    } else {
                        previousWord = currentWord;
                    }
                } else if (!UWHITESPACE.matcher(currentWord).matches()) {
                    previousWord = null;
                }
                previousPosition = currentPosition;
                currentPosition = this.breakIterator.next();
            }
        }
    }
}

