/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.SkipCheckAnnotation;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.LengthChecker;
import net.sf.okapi.lib.verification.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LengthCheckerTest {
    private static final String SOURCE_TEXT = "Hello world.";
    private static final String TARGET_TEXT = "Hello world, but longer.";
    private static final LocaleId SOURCE_LOCALE = LocaleId.ENGLISH;
    private static final LocaleId TARGET_LOCALE = LocaleId.FRENCH;
    private LengthChecker checker;
    private List<Issue> issues;

    @Before
    public void setUp() {
        this.checker = new LengthChecker();
        this.issues = new ArrayList<Issue>();
        Parameters params = new Parameters();
        params.setCheckAbsoluteMaxCharLength(true);
        params.setAbsoluteMaxCharLength(25);
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
    }

    @Test
    public void testBadLength() {
        TextContainer trgTc = new TextContainer(TARGET_TEXT);
        trgTc.setAnnotation((IAnnotation)new GenericAnnotations(new GenericAnnotation("its-storagesize", new Object[]{"storagesizeLinebreak", "crlf", "storagesizeSize", TARGET_TEXT.length() - 5, "storagesizeEncoding", "utf-8"})));
        TextUnit tu = new TextUnit("tu1", SOURCE_TEXT);
        tu.createTarget(TARGET_LOCALE, true, 7);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Issue issue = this.issues.get(0);
        Assert.assertEquals((long)2L, (long)issue.getDisplaySeverity());
        Assert.assertEquals((Object)"Number of bytes in the target (using utf-8) is: 24. Number allowed: 19.", (Object)issue.getMessage());
        this.assertSourceAndTargetInIssue(tu, issue);
    }

    @Test
    public void testBadChar() {
        String targetText = "Encode error: \u6565.";
        TextContainer trgTc = new TextContainer("Encode error: \u6565.");
        trgTc.setAnnotation((IAnnotation)new GenericAnnotations(new GenericAnnotation("its-storagesize", new Object[]{"storagesizeLinebreak", "crlf", "storagesizeSize", 35, "storagesizeEncoding", "iso-8859-1"})));
        TextUnit tu = new TextUnit("tu1", SOURCE_TEXT);
        tu.createTarget(TARGET_LOCALE, true, 7);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Issue issue = this.issues.get(0);
        Assert.assertEquals((long)2L, (long)issue.getDisplaySeverity());
        Assert.assertEquals((Object)"Cannot encode one or more characters of the target using iso-8859-1.", (Object)issue.getMessage());
        this.assertSourceAndTargetInIssue(tu, issue);
    }

    @Test
    public void testAbsoluteMaxChar() {
        String targetText = "Hello world, but longer. And a bit more.";
        TextContainer trgTc = new TextContainer("Hello world, but longer. And a bit more.");
        TextUnit tu = new TextUnit("tu1", SOURCE_TEXT);
        tu.createTarget(TARGET_LOCALE, true, 7);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Issue issue = this.issues.get(0);
        Assert.assertEquals((long)2L, (long)issue.getDisplaySeverity());
        Assert.assertEquals((Object)"The target is longer than 25 (by 15).", (Object)issue.getMessage());
        this.assertSourceAndTargetInIssue(tu, issue);
    }

    @Test
    public void testAbsoluteMaxCharWithSegmentSkipped() {
        String targetText = "Hello world, but longer. And a bit more.";
        TextContainer trgTc = new TextContainer("Hello world, but longer. And a bit more.");
        TextUnit tu = new TextUnit("tu1", SOURCE_TEXT);
        tu.createTarget(TARGET_LOCALE, true, 7);
        tu.setTarget(TARGET_LOCALE, trgTc);
        tu.getSource().getFirstSegment().setAnnotation((IAnnotation)new SkipCheckAnnotation());
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        Iterator anns = tu.getSource().getFirstSegment().getAnnotations().iterator();
        anns.next();
        anns.remove();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
    }

    @Test
    public void testAbsoluteMinChar() {
        String targetText = "Hello world, but longer. And a bit more.";
        TextContainer trgTc = new TextContainer("Hello world, but longer. And a bit more.");
        TextUnit tu = new TextUnit("tu1", SOURCE_TEXT);
        tu.createTarget(TARGET_LOCALE, true, 7);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Issue issue = this.issues.get(0);
        Assert.assertEquals((long)2L, (long)issue.getDisplaySeverity());
        Assert.assertEquals((Object)"The target is longer than 25 (by 15).", (Object)issue.getMessage());
        this.assertSourceAndTargetInIssue(tu, issue);
    }

    private void assertSourceAndTargetInIssue(TextUnit tu, Issue issue) {
        Assert.assertEquals((Object)tu.getSource().toString(), (Object)issue.getSource());
        Assert.assertEquals((Object)tu.getTarget(TARGET_LOCALE).toString(), (Object)issue.getTarget());
    }
}

