/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.annotation.SkipCheckAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.verification.InlineCodesChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InlineCodesCheckerTest {
    private static final LocaleId SOURCE_LOCALE = LocaleId.ENGLISH;
    private static final LocaleId TARGET_LOCALE = LocaleId.FRENCH;
    private InlineCodesChecker checker;
    private List<Issue> issues;

    @Before
    public void setUp() {
        this.checker = new InlineCodesChecker();
        this.issues = new ArrayList<Issue>();
    }

    @Test
    public void testOrderNoStrictOrder() {
        Parameters params = new Parameters();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        srcFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        trgTc = new TextContainer();
        trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
    }

    @Test
    public void testWithAndWithoutSkip() {
        Parameters params = new Parameters();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        Segment seg = new Segment("s1");
        TextFragment tf = seg.getContent();
        tf.append(TextFragment.TagType.OPENING, "a", null, 1);
        tf.append(TextFragment.TagType.PLACEHOLDER, "b", null, 2);
        tf.append(TextFragment.TagType.CLOSING, "a", null, 1);
        srcTc.append((TextPart)seg);
        seg = new Segment("s2");
        tf = seg.getContent();
        tf.append(TextFragment.TagType.OPENING, "c", null, 1);
        tf.append(TextFragment.TagType.CLOSING, "c", null, 1);
        srcTc.append((TextPart)seg);
        TextContainer trgTc = new TextContainer();
        seg = new Segment("s1");
        tf = seg.getContent();
        tf.append(TextFragment.TagType.OPENING, "a", null, 1);
        tf.append(TextFragment.TagType.CLOSING, "a", null, 1);
        trgTc.append((TextPart)seg);
        seg = new Segment("s2");
        tf = seg.getContent();
        tf.append(TextFragment.TagType.OPENING, "c", null, 1);
        trgTc.append((TextPart)seg);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)2L, (long)this.issues.size());
        Assert.assertEquals((Object)"s1", (Object)this.issues.get(0).getSegId());
        Assert.assertEquals((Object)IssueType.MISSING_CODE, (Object)this.issues.get(0).getIssueType());
        Assert.assertEquals((Object)"s2", (Object)this.issues.get(1).getSegId());
        Assert.assertEquals((Object)IssueType.MISSING_CODE, (Object)this.issues.get(1).getIssueType());
        TextPart tp = (TextPart)srcTc.getParts().get(1);
        tp.setAnnotation((IAnnotation)new SkipCheckAnnotation());
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"s1", (Object)this.issues.get(0).getSegId());
        Assert.assertEquals((Object)IssueType.MISSING_CODE, (Object)this.issues.get(0).getIssueType());
        tp = (TextPart)srcTc.getParts().get(0);
        tp.setAnnotation((IAnnotation)new SkipCheckAnnotation());
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
    }

    @Test
    public void testMissingDeleteableCode() {
        Parameters params = new Parameters();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        srcFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        Code c1 = new Code(TextFragment.TagType.PLACEHOLDER, "p", "<p/>");
        c1.setDeleteable(true);
        c1.setId(22);
        srcFrag.append(c1);
        srcFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
    }

    @Test
    public void testMissingNoDeleteableCode() {
        Parameters params = new Parameters();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        srcFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "p", "<p/>", 33);
        srcFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertTrue((boolean)this.issues.get(0).getMessage().contains("Missing placeholders in the target: \"<p/>\""));
    }

    @Test
    public void testMissingNoDeleteableCodeUsingGeneric() {
        Parameters params = new Parameters();
        params.setUseGenericCodes(true);
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        srcFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "p", "<p/>", 33);
        srcFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertTrue((boolean)this.issues.get(0).getMessage().contains("Missing placeholders in the target: <33/>"));
    }

    @Test
    public void testMissingSimilarUsingGeneric() {
        Parameters params = new Parameters();
        params.setUseGenericCodes(true);
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append(TextFragment.TagType.OPENING, "a", "<a>", 1);
        srcFrag.append(TextFragment.TagType.CLOSING, "a", "</a>", 1);
        srcFrag.append(TextFragment.TagType.OPENING, "b", "<b>", 2);
        srcFrag.append(TextFragment.TagType.CLOSING, "b", "</b>", 2);
        srcFrag.append(TextFragment.TagType.OPENING, "b", "<b>", 3);
        srcFrag.append(TextFragment.TagType.CLOSING, "b", "</b>", 3);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", "<a>", 1);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", "</a>", 1);
        trgFrag.append(TextFragment.TagType.OPENING, "b", "<b>", 3);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", "</b>", 3);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertTrue((boolean)this.issues.get(0).getMessage().contains("Missing placeholders in the target: <2>, </2>"));
    }

    @Test
    public void testOrderWithStrictOrder() {
        Parameters params = new Parameters();
        params.setStrictCodeOrder(true);
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        srcFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        trgTc = new TextContainer();
        trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertTrue((boolean)this.issues.get(0).getMessage().contains("source code ID=1 (OPENING), target code ID=2 (OPENING)"));
    }

    @Test
    public void testLongSequenceWithStrictOrder() {
        Parameters params = new Parameters();
        params.setStrictCodeOrder(true);
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        srcFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "c", null, 3);
        srcFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "d", null, 4);
        srcFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "c", null, 3);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "d", null, 4);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        trgTc = new TextContainer();
        trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", null, 1);
        trgFrag.append(TextFragment.TagType.OPENING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "c", null, 3);
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "d", null, 4);
        trgFrag.append(TextFragment.TagType.CLOSING, "b", null, 2);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", null, 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertTrue((boolean)this.issues.get(0).getMessage().contains("source code ID=2 (CLOSING), target code ID=4 (PLACEHOLDER)"));
    }

    @Test
    public void testDeletableCodesWithStrictOrder() {
        Parameters params = new Parameters();
        params.setStrictCodeOrder(true);
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append(TextFragment.TagType.OPENING, "a", "<a>", 1);
        Code c1 = new Code(TextFragment.TagType.PLACEHOLDER, "p", "<p/>");
        c1.setDeleteable(true);
        c1.setId(2);
        srcFrag.append(c1);
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "c", "<c/>", 3);
        srcFrag.append(TextFragment.TagType.CLOSING, "a", "</a>", 1);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", "<a>", 1);
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "c", "<c/>", 3);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", "</a>", 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        trgTc = new TextContainer();
        trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", "<a>", 1);
        c1 = new Code(TextFragment.TagType.PLACEHOLDER, "p", "<p/>");
        c1.setDeleteable(true);
        c1.setId(2);
        trgFrag.append(c1);
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "c", "<c/>", 3);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", "</a>", 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        trgTc = new TextContainer();
        trgFrag = trgTc.getFirstContent();
        trgFrag.append(TextFragment.TagType.OPENING, "a", "<a>", 1);
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "c", "<c/>", 3);
        c1 = new Code(TextFragment.TagType.PLACEHOLDER, "p", "<p/>");
        c1.setDeleteable(true);
        c1.setId(2);
        trgFrag.append(c1);
        trgFrag.append(TextFragment.TagType.CLOSING, "a", "</a>", 1);
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertTrue((boolean)this.issues.get(0).getMessage().contains("source code ID=1 (CLOSING), target code ID=2 (PLACEHOLDER)"));
    }

    @Test
    public void testMissingCodeWithEmptyType() {
        Parameters params = new Parameters();
        params.setUseGenericCodes(true);
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        TextUnit tu = new TextUnit();
        TextContainer srcTc = tu.getSource();
        TextFragment srcFrag = srcTc.getFirstContent();
        srcFrag.append("src");
        srcFrag.append(TextFragment.TagType.OPENING, "", null, 1);
        srcFrag.append(TextFragment.TagType.CLOSING, "", null, 1);
        TextContainer trgTc = new TextContainer();
        TextFragment trgFrag = trgTc.getFirstContent();
        trgFrag.append("trg");
        tu.setTarget(TARGET_LOCALE, trgTc);
        this.issues.clear();
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertTrue((boolean)this.issues.get(0).getMessage().contains("Missing placeholders in the target: <1>, </1>"));
    }
}

