/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.verification.AbstractChecker;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AbstractCheckerTests {
    @Test
    public void testFromFragmentToGeneric() {
        TextFragment frag = new TextFragment("abc");
        frag.append(TextFragment.TagType.PLACEHOLDER, "ph", "[PHLDR/]");
        frag.append("def");
        frag.append(TextFragment.TagType.PLACEHOLDER, "ph", "[PHLDR/]");
        frag.append("ghi");
        Assert.assertEquals((long)2L, (long)AbstractChecker.fromFragmentToGeneric((TextFragment)frag, (int)2));
        Assert.assertEquals((long)7L, (long)AbstractChecker.fromFragmentToGeneric((TextFragment)frag, (int)5));
        Assert.assertEquals((long)8L, (long)AbstractChecker.fromFragmentToGeneric((TextFragment)frag, (int)6));
        Assert.assertEquals((long)16L, (long)AbstractChecker.fromFragmentToGeneric((TextFragment)frag, (int)12));
    }

    @Test
    public void testFromOriginalToGeneric() {
        TextFragment frag = new TextFragment("abc");
        frag.append(TextFragment.TagType.PLACEHOLDER, "ph", "[PHLDR/]");
        frag.append("def");
        frag.append(TextFragment.TagType.PLACEHOLDER, "ph", "[PHLDR/]");
        frag.append("ghi");
        Assert.assertEquals((long)2L, (long)AbstractChecker.fromOriginalToGeneric((TextFragment)frag, (int)2));
        Assert.assertEquals((long)7L, (long)AbstractChecker.fromOriginalToGeneric((TextFragment)frag, (int)11));
        Assert.assertEquals((long)8L, (long)AbstractChecker.fromOriginalToGeneric((TextFragment)frag, (int)12));
        Assert.assertEquals((long)16L, (long)AbstractChecker.fromOriginalToGeneric((TextFragment)frag, (int)24));
    }
}

