/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceChecker {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public int checkUnitSpacing(ITextUnit tu, LocaleId trgLoc) {
        int changes = 0;
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg = tu.getTargetSegment(trgLoc, srcSeg.getId(), false);
                if (trgSeg == null) continue;
                changes += this.checkSpaces(srcSeg.text, trgSeg.text);
            }
        }
        return changes;
    }

    public int checkSpaces(TextFragment srcFrag, TextFragment trgFrag) {
        int changes;
        block19: {
            changes = 0;
            try {
                if (trgFrag.isEmpty() || !trgFrag.hasCode() || trgFrag.compareTo(srcFrag, TextFragment.CompareMode.CODE_DATA_ONLY) == 0) break block19;
                StringBuilder trgText = new StringBuilder(trgFrag.getCodedText());
                StringBuilder srcText = new StringBuilder(srcFrag.getCodedText());
                for (int tCur = 0; tCur < trgText.length(); ++tCur) {
                    if (!TextFragment.isMarker((char)trgText.charAt(tCur))) continue;
                    int tIndexBefore = 0;
                    int tIndexAfter = 0;
                    tIndexBefore = tCur == 0 ? tCur : tCur - 1;
                    tIndexAfter = tCur >= trgText.length() - 2 ? trgText.length() - 1 : tCur + 2;
                    Code tCode = trgFrag.getCode(trgText.charAt(tCur + 1));
                    block3: for (int sCur = 0; sCur < srcText.length(); ++sCur) {
                        if (!TextFragment.isMarker((char)srcText.charAt(sCur))) continue;
                        Code sCode = srcFrag.getCode(srcText.charAt(sCur + 1));
                        if (sCode.getId() == tCode.getId() && sCode.getTagType() == tCode.getTagType()) {
                            int sIndexBefore = 0;
                            int sIndexAfter = 0;
                            sIndexAfter = sCur >= srcText.length() - 2 ? srcText.length() - 1 : sCur + 2;
                            for (sIndexBefore = sCur == 0 ? sCur : sCur - 1; sIndexBefore >= 0; --sIndexBefore) {
                                if (Character.isWhitespace(srcText.charAt(sIndexBefore))) {
                                    if (tIndexBefore > 0 && !Character.isWhitespace(trgText.charAt(tIndexBefore))) {
                                        trgText.insert(tIndexBefore + 1, srcText.charAt(sIndexBefore));
                                        ++tCur;
                                        ++tIndexAfter;
                                        ++changes;
                                        continue;
                                    }
                                    if (tIndexBefore < 0) continue;
                                    if (tIndexBefore <= 0) break;
                                    --tIndexBefore;
                                    continue;
                                }
                                while (tIndexBefore >= 0 && Character.isWhitespace(trgText.charAt(tIndexBefore))) {
                                    trgText.deleteCharAt(tIndexBefore);
                                    --tCur;
                                    --tIndexAfter;
                                    ++changes;
                                    --tIndexBefore;
                                }
                                break block4;
                            }
                            while (sIndexAfter < srcText.length()) {
                                if (Character.isWhitespace(srcText.charAt(sIndexAfter))) {
                                    if (tIndexAfter < trgText.length() && !Character.isWhitespace(trgText.charAt(tIndexAfter))) {
                                        if (tIndexAfter < trgText.length() - 1) {
                                            trgText.insert(tIndexAfter, srcText.charAt(sIndexAfter));
                                            ++tIndexAfter;
                                            ++changes;
                                        }
                                    } else if (tIndexAfter < trgText.length()) {
                                        if (tIndexAfter >= trgText.length()) break block3;
                                        ++tIndexAfter;
                                    }
                                    ++sIndexAfter;
                                    continue;
                                }
                                while (tIndexAfter < trgText.length()) {
                                    if (Character.isWhitespace(trgText.charAt(tIndexAfter))) {
                                        trgText.deleteCharAt(tIndexAfter);
                                        ++changes;
                                        continue;
                                    }
                                    ++tIndexAfter;
                                    break block3;
                                }
                                break block3;
                            }
                            break;
                        }
                        ++sCur;
                    }
                    ++tCur;
                }
                if (Character.isWhitespace(srcText.charAt(0)) && !Character.isWhitespace(trgText.charAt(0))) {
                    trgText.insert(0, srcText.charAt(0));
                    ++changes;
                }
                if (Character.isWhitespace(srcText.charAt(srcText.length() - 1)) && !Character.isWhitespace(trgText.charAt(trgText.length() - 1))) {
                    trgText.insert(trgText.length(), srcText.charAt(srcText.length() - 1));
                    ++changes;
                }
                trgFrag.setCodedText(trgText.toString(), false);
            }
            catch (Throwable e) {
                this.LOGGER.error("The following error has occured \"{}\" while checking the spaces in the source: {}", (Object)e.getMessage(), (Object)srcFrag.toText());
            }
        }
        return changes;
    }
}

