/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;

public class CharactersChecker
extends AbstractChecker {
    private Pattern corruption;
    private CharsetEncoder encoder1;
    private Pattern extraCharsAllowed;
    private Pattern itsAllowedChars;
    private String itsAllowedCharsPattern;

    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        super.startProcess(sourceLocale, targetLocale, params, issues);
        this.corruption = null;
        if (params.getCorruptedCharacters()) {
            this.corruption = Pattern.compile("\\u00C3[\\u00A4-\\u00B6]|\\u00C3\\u201E|\\u00C3\\u2026|\\u00C3\\u2013");
        }
        this.encoder1 = null;
        this.extraCharsAllowed = null;
        if (params.getCheckCharacters()) {
            String charsetName = params.getCharset();
            if (!Util.isEmpty((String)charsetName)) {
                this.encoder1 = Charset.forName(charsetName).newEncoder();
            }
            if (!params.getExtraCharsAllowed().isEmpty()) {
                this.extraCharsAllowed = Pattern.compile(params.getExtraCharsAllowed());
            }
        }
        this.itsAllowedChars = null;
        this.itsAllowedCharsPattern = "\u0000";
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        super.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        super.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.getTrgLoc());
        if (this.getParams().getCheckAllowedCharacters()) {
            this.checkITSAllowedChars(tu, srcCont, true);
        }
        if (trgCont == null) {
            return;
        }
        if (this.getParams().getCheckAllowedCharacters()) {
            this.checkITSAllowedChars(tu, trgCont, false);
        }
        String trgOri = null;
        trgOri = trgCont.contentIsOneSegment() ? trgCont.toString() : trgCont.getUnSegmentedContentCopy().toText();
        if (this.getParams().getCorruptedCharacters()) {
            this.checkCorruptedCharacters(trgOri, tu, srcCont, trgCont);
        }
        if (this.getParams().getCheckCharacters()) {
            this.checkCharacters(trgOri, tu, srcCont, trgCont);
        }
        this.setAnnotationIds(srcCont, trgCont);
    }

    private void checkITSAllowedChars(ITextUnit tu, TextContainer tc, boolean isSource) {
        if (tc == null) {
            return;
        }
        GenericAnnotations anns = (GenericAnnotations)tc.getAnnotation(GenericAnnotations.class);
        if (anns == null) {
            return;
        }
        GenericAnnotation ga = anns.getFirstAnnotation("its-allowedchars");
        if (ga == null) {
            return;
        }
        try {
            TextFragment tf;
            String tmp;
            Matcher m;
            Object pattern = ga.getString("allowedcharsValue");
            if (this.itsAllowedChars == null || !this.itsAllowedCharsPattern.equals(pattern)) {
                this.itsAllowedCharsPattern = pattern;
                if (((String)pattern).startsWith("[^")) {
                    pattern = "[" + ((String)pattern).substring(2);
                } else if (((String)pattern).startsWith("[")) {
                    pattern = "[^" + ((String)pattern).substring(1);
                } else {
                    throw new OkapiException("Pattern should start with '[' or '[^'.");
                }
                this.itsAllowedChars = Pattern.compile((String)pattern);
            }
            if (!(m = this.itsAllowedChars.matcher(tmp = TextUnitUtil.getText((TextFragment)(tf = tc.contentIsOneSegment() ? tc.getFirstContent() : tc.getUnSegmentedContentCopy())))).find()) {
                return;
            }
            int ss = 0;
            int ts = 0;
            int se = -1;
            int te = -1;
            if (isSource) {
                ss = this.getParams().getUseGenericCodes() ? CharactersChecker.fromStrippedToGeneric(tf, m.start()) : CharactersChecker.fromStrippedToString(tf, m.start());
                se = this.getParams().getUseGenericCodes() ? CharactersChecker.fromStrippedToGeneric(tf, m.end()) : CharactersChecker.fromStrippedToString(tf, m.end());
            } else {
                ts = this.getParams().getUseGenericCodes() ? CharactersChecker.fromStrippedToGeneric(tf, m.start()) : CharactersChecker.fromStrippedToString(tf, m.start());
                te = this.getParams().getUseGenericCodes() ? CharactersChecker.fromStrippedToGeneric(tf, m.end()) : CharactersChecker.fromStrippedToString(tf, m.end());
            }
            this.addAnnotationAndReportIssue(IssueType.ALLOWED_CHARACTERS, tu, tc, null, String.format("Character not allowed: '%s' (pattern: '%s'", m.group(), this.itsAllowedCharsPattern), ss, se, ts, te, 100.0, isSource ? this.getDisplay(tc) : "N/A", isSource ? "N/A" : this.getDisplay(tc), null);
        }
        catch (Throwable e) {
            this.addAnnotationAndReportIssue(IssueType.ALLOWED_CHARACTERS, tu, tc, null, String.format("Error when trying to check ITS allowed characters pattern '%s'. " + e.getMessage(), this.itsAllowedCharsPattern), 0, -1, 0, -1, 100.0, isSource ? this.getDisplay(tc) : "N/A", isSource ? "N/A" : this.getDisplay(tc), null);
        }
    }

    private void checkCharacters(String trgOri, ITextUnit tu, TextContainer srcCont, TextContainer trgCont) {
        StringBuilder badChars = new StringBuilder();
        int pos = -1;
        char badChar = '\u0000';
        int count = 0;
        TextFragment trgFrag = null;
        for (int i = 0; i < trgOri.length(); ++i) {
            Matcher m;
            char ch = trgOri.charAt(i);
            if (this.encoder1 == null ? this.extraCharsAllowed != null && (m = this.extraCharsAllowed.matcher(trgOri.subSequence(i, i + 1))).find() : this.encoder1.canEncode(ch) || this.extraCharsAllowed != null && (m = this.extraCharsAllowed.matcher(trgOri.subSequence(i, i + 1))).find()) continue;
            if (++count > 1) {
                if (ch == badChar || badChars.indexOf(String.valueOf(ch)) != -1) continue;
                badChars.append(ch);
                continue;
            }
            pos = i;
            badChar = ch;
        }
        if (pos > -1) {
            int start = pos;
            if (this.getParams().getUseGenericCodes()) {
                if (trgFrag == null) {
                    trgFrag = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
                }
                start = CharactersChecker.fromOriginalToGeneric(trgFrag, pos);
            }
            if (badChars.length() > 0) {
                this.addAnnotationAndReportIssue(IssueType.ALLOWED_CHARACTERS, tu, trgCont, null, String.format("The character '%c' (U+%04X) is not allowed in the target text. Other forbidden characters found: ", badChar, (int)badChar) + badChars.toString(), 0, -1, start, start + 1, 50.0, this.getDisplay(srcCont), this.getDisplay(trgCont), null);
            } else {
                this.addAnnotationAndReportIssue(IssueType.ALLOWED_CHARACTERS, tu, trgCont, null, String.format("The character '%c' (U+%04X) is not allowed in the target text.", badChar, (int)badChar), 0, -1, start, start + 1, 50.0, this.getDisplay(srcCont), this.getDisplay(trgCont), null);
            }
        }
    }

    private void checkCorruptedCharacters(String trgOri, ITextUnit tu, TextContainer srcCont, TextContainer trgCont) {
        Matcher m = this.corruption.matcher(trgOri);
        if (m.find()) {
            int start = m.start();
            int end = m.end();
            if (this.getParams().getUseGenericCodes()) {
                TextFragment trgFrag = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
                start = CharactersChecker.fromOriginalToGeneric(trgFrag, start);
                end = CharactersChecker.fromOriginalToGeneric(trgFrag, end);
            }
            this.addAnnotationAndReportIssue(IssueType.SUSPECT_PATTERN, tu, trgCont, null, String.format("Possible corrupted characters in the target (for example: \"%s\").", m.group()), 0, -1, start, end, 100.0, this.getDisplay(srcCont), this.getDisplay(trgCont), null);
        }
    }
}

