/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.annotation.SkipCheckAnnotation;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.verification.GeneralChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GeneralCheckerTests {
    private static final LocaleId SOURCE_LOCALE = LocaleId.ENGLISH;
    private static final LocaleId TARGET_LOCALE = LocaleId.FRENCH;
    private GeneralChecker checker;
    private List<Issue> issues;

    private void runTest(String srcText, String trgText, List<PatternItem> patterns, boolean withNumbers) {
        TextUnit tu = new TextUnit("tu1", srcText);
        tu.setTargetContent(TARGET_LOCALE, new TextFragment(trgText));
        Parameters params = new Parameters();
        params.setTargetSameAsSourceWithNumbers(withNumbers);
        if (patterns != null) {
            params.setCheckPatterns(true);
            params.setPatterns(patterns);
        }
        this.issues.clear();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        this.checker.processTextUnit((ITextUnit)tu);
    }

    @Before
    public void setUp() {
        this.checker = new GeneralChecker();
        this.issues = new ArrayList<Issue>();
    }

    @Test
    public void testTargetSameAsSourceNoPatterns() {
        this.runTest("Text aaa", "Text bbb", null, true);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runTest("Text aaa", "Text aaa", null, true);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)this.issues.get(0).getIssueType());
    }

    @Test
    public void testWithAndWithoutSkip() {
        TextUnit tu = new TextUnit("tu1", "text");
        tu.setTargetContent(TARGET_LOCALE, new TextFragment("text"));
        this.issues.clear();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, new Parameters(), this.issues);
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)this.issues.get(0).getIssueType());
        tu.getSource().getFirstSegment().setAnnotation((IAnnotation)new SkipCheckAnnotation());
        this.issues.clear();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, new Parameters(), this.issues);
        this.checker.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((long)0L, (long)this.issues.size());
    }

    @Test
    public void testTargetSameAsSourceWithPattern() {
        PatternItem item = new PatternItem("aaa", "bbb", true, 10, false, "error");
        ArrayList<Object> patterns = new ArrayList<PatternItem>();
        patterns.add(item);
        this.runTest("aaa", "aaa", patterns, true);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)this.issues.get(0).getIssueType());
        item = new PatternItem("aaa", "<same>", true, 10, false, "error");
        patterns = new ArrayList();
        patterns.add(item);
        this.runTest("aaa", "aaa", patterns, true);
        Assert.assertEquals((long)0L, (long)this.issues.size());
    }

    @Test
    public void testTargetSameAsSourceWithComplexPatterns() {
        PatternItem item = new PatternItem("aaa", null, true, 10, true, "error");
        item.singlePattern = true;
        ArrayList<PatternItem> patterns = new ArrayList<PatternItem>();
        patterns.add(item);
        item = new PatternItem("aaa", "<same>", true, 10, false, "error");
        patterns.add(item);
        this.runTest("aaa", "aaa", patterns, true);
        Assert.assertEquals((long)0L, (long)this.issues.size());
    }

    @Test
    public void testTargetSameAsSourceHavingNumbers() {
        this.runTest("123", "123", null, true);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)this.issues.get(0).getIssueType());
        this.runTest("123", "123", null, false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runTest("(123.,-+)*/", "(123.,-+)*/", null, false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runTest("123a", "123a", null, true);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)this.issues.get(0).getIssueType());
    }
}

