/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;
import net.sf.okapi.lib.verification.PatternsChecker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PatternsCheckerTests {
    private static final LocaleId SOURCE_LOCALE = LocaleId.ENGLISH;
    private static final LocaleId TARGET_LOCALE = LocaleId.FRENCH;
    private PatternsChecker checker;
    private List<Issue> issues;

    @Before
    public void setUp() {
        this.checker = new PatternsChecker();
        this.issues = new ArrayList<Issue>();
    }

    @Test
    public void testNormalSameInTarget() {
        this.runPatternTest("Text aaa", "Texte aaa", "aaa", "<same>", true, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("Text aaa", "Texte AaA", "aaa", "<same>", true, "test=@@", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"test=aaa", (Object)this.issues.get(0).getMessage());
    }

    @Test
    public void testSinglePatternTarget() {
        this.runPatternTest("Text", "Texte aaa", null, "aaa", false, "test=@@", true);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"test=aaa", (Object)this.issues.get(0).getMessage());
        this.runPatternTest("Text", "Texte aaa", null, "aaa", false, "test", true);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"\"aaa\" found in target. (from rule: test).", (Object)this.issues.get(0).getMessage());
        this.runPatternTest("Text", "Texte a A a", "NOT USED", "(?i)a", false, "test", true);
        Assert.assertEquals((long)3L, (long)this.issues.size());
        Issue issue = this.issues.get(0);
        Assert.assertEquals((Object)"\"a\" found in target. (from rule: test).", (Object)issue.getMessage());
        Assert.assertEquals((long)6L, (long)issue.getTargetStart());
        Assert.assertEquals((long)7L, (long)issue.getTargetEnd());
        issue = this.issues.get(1);
        Assert.assertEquals((Object)"\"A\" found in target. (from rule: test).", (Object)issue.getMessage());
        Assert.assertEquals((long)8L, (long)issue.getTargetStart());
        Assert.assertEquals((long)9L, (long)issue.getTargetEnd());
        issue = this.issues.get(2);
        Assert.assertEquals((Object)"\"a\" found in target. (from rule: test).", (Object)issue.getMessage());
        Assert.assertEquals((long)10L, (long)issue.getTargetStart());
        Assert.assertEquals((long)11L, (long)issue.getTargetEnd());
    }

    @Test
    public void testSinglePatternSource() {
        this.runPatternTest("Text aaa", "Texte", "aaa", null, true, "test=@@", true);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"test=aaa", (Object)this.issues.get(0).getMessage());
        this.runPatternTest("Text aaa", "Texte", "aaa", null, true, "test", true);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"\"aaa\" found in source. (from rule: test).", (Object)this.issues.get(0).getMessage());
        this.runPatternTest("Text a A a", "Texte", "(?i)a", "NOT USED", true, "test", true);
        Assert.assertEquals((long)3L, (long)this.issues.size());
        Issue issue = this.issues.get(0);
        Assert.assertEquals((Object)"\"a\" found in source. (from rule: test).", (Object)issue.getMessage());
        Assert.assertEquals((long)5L, (long)issue.getSourceStart());
        Assert.assertEquals((long)6L, (long)issue.getSourceEnd());
        issue = this.issues.get(1);
        Assert.assertEquals((Object)"\"A\" found in source. (from rule: test).", (Object)issue.getMessage());
        Assert.assertEquals((long)7L, (long)issue.getSourceStart());
        Assert.assertEquals((long)8L, (long)issue.getSourceEnd());
        issue = this.issues.get(2);
        Assert.assertEquals((Object)"\"a\" found in source. (from rule: test).", (Object)issue.getMessage());
        Assert.assertEquals((long)9L, (long)issue.getSourceStart());
        Assert.assertEquals((long)10L, (long)issue.getSourceEnd());
    }

    @Test
    public void testNormalSameInSource() {
        this.runPatternTest("Text aaa", "Texte aaa", "<same>", "aaa", false, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("Text BBB", "Texte aaa", "<same>", "aaa", false, "test", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"The target part \"aaa\" is not in the source. (from rule: test).", (Object)this.issues.get(0).getMessage());
    }

    @Test
    public void testNormalWithLiteralSame() {
        this.runPatternTest("Text <same>", "Texte <same>", "\\u003Csame>", "\\u003Csame>", true, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("Text <same>", "Texte <SAme>", "\\u003Csame>", "<same>", true, "test", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"The source part \"<same>\" is not in the target (from rule: test).", (Object)this.issues.get(0).getMessage());
    }

    @Test
    public void testSameWithExpressionInTarget() {
        this.runPatternTest("Text.", "Texte.zz", "\\p{P}$", "<same>zz$", true, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("Text.", "Texte.zz", "zz$", "<same>$", true, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("Text.", "Texte,", "\\p{P}$", "<same>$", true, "test (@@)", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"test (.)", (Object)this.issues.get(0).getMessage());
        this.runPatternTest("Text.", "Texte.Z", "\\p{P}$", "<same>$", true, "test", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"The source part \".\" has no correspondence in the target (from rule: test).", (Object)this.issues.get(0).getMessage());
    }

    @Test
    public void testSameWithExpressionInSource() {
        this.runPatternTest("Text.zz", "Texte.", "<same>zz$", "\\p{P}$", false, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("Text.zz", "Texte.", "<same>$", "zz$", false, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("Text,", "Texte.", "<same>$", "\\p{P}$", false, "test", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"The target part \".\" has no correspondence in the source. (from rule: test).", (Object)this.issues.get(0).getMessage());
        this.runPatternTest("Text.Z", "Texte.", "<same>$", "\\p{P}$", false, "test", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"The target part \".\" has no correspondence in the source. (from rule: test).", (Object)this.issues.get(0).getMessage());
    }

    @Test
    public void testCapturesInTarget() {
        this.runPatternTest("Text.zz", "Texte.zz", "(\\p{P})(.*?)$", "$1$2", true, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("Text.zz", "Texte.ZZ", "(\\p{P})(.*?)$", "$1$2", true, "test", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        this.runPatternTest("Text.", "Texte.", "\\p{P}$", "<same>$", true, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
        this.runPatternTest("abcdef", "fedcba", "(a)(b)(c)(d)(e)(f)", "$6$5$4$3$2$1", true, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
    }

    @Test
    public void testEscapingInSame() {
        String needingEscape = "<([{\\^-=$!|]})?*+.>";
        this.runPatternTest("z" + needingEscape + "Xz", "_" + needingEscape + "_", "(\\Q" + needingEscape + "\\E)X", "_<same>_", true, "test", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"The source part \"<([{\\^-=$!|]})?*+.>X\" has no correspondence in the target (from rule: test).", (Object)this.issues.get(0).getMessage());
        this.runPatternTest("z" + needingEscape + "Xz", "_" + needingEscape + "X_", "(\\Q" + needingEscape + "\\E)X", "_<same>_", true, "test", false);
        Assert.assertEquals((long)0L, (long)this.issues.size());
    }

    @Test
    public void testComplexPatternWithGroups() {
        this.runPatternTest("test 1056 test", "test", "([0-9]{1})[.,[\\u0020\\u0007\\u00a0]]?([0-9]{1,3})([.,[\\u0020\\u0007\\u00a0]]?([0-9]{1,3}))?", "$1$2$3", true, "test", false);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((Object)"The source part \"1056\" has no correspondence in the target (from rule: test).", (Object)this.issues.get(0).getMessage());
    }

    private void runPatternTest(String srcText, String trgText, String srcExpression, String trgExpression, boolean fromSource, String message, boolean singlePattern) {
        TextUnit tu = new TextUnit("tu1", srcText);
        tu.setTargetContent(TARGET_LOCALE, new TextFragment(trgText));
        Parameters params = new Parameters();
        ArrayList<PatternItem> patterns = new ArrayList<PatternItem>();
        PatternItem item = new PatternItem(srcExpression, trgExpression, true, 10, fromSource, message);
        item.singlePattern = singlePattern;
        patterns.add(item);
        params.setPatterns(patterns);
        if (message.contains("@@")) {
            params.setShowOnlyPatternDescription(true);
        }
        this.issues.clear();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        this.checker.processTextUnit((ITextUnit)tu);
    }
}

