/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.verification.SpaceChecker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpaceCheckerTest {
    private final LocaleId locFR = LocaleId.FRENCH;
    private GenericContent fmt;
    private SpaceChecker checker;

    @Before
    public void setUp() {
        this.fmt = new GenericContent();
        this.checker = new SpaceChecker();
    }

    @Test
    public void testEmptyCase() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t3.");
        TextFragment trgTf = new TextFragment();
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testMatchingCase() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t3.");
        TextFragment trgTf = new TextFragment("t1 ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append("t2");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append(" t3.");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1 <1>t2</1> t3.", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1 <b>t2</b> t3.", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testStartCase() {
        TextFragment srcTf = new TextFragment();
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t1");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t2.");
        TextFragment trgTf = new TextFragment();
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" t1 ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append(" t2.");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"<1>t1</1> t2.", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"<b>t1</b> t2.", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testEndCase() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        TextFragment trgTf = new TextFragment("t1 ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" t2 ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1 <1>t2</1>", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1 <b>t2</b>", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testSrcMultipleSpaceBefore() {
        TextFragment srcTf = new TextFragment("t1  ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        TextFragment trgTf = new TextFragment("t1 ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" t2 ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1  <1>t2</1>", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1  <b>t2</b>", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testTrgMultipleSpaceBefore() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        TextFragment trgTf = new TextFragment("t1  ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" t2 ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1 <1>t2</1>", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1 <b>t2</b>", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testMultipleSpaceAfter() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("  t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        TextFragment trgTf = new TextFragment("t1 ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" t2 ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1 <1>  t2</1>", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1 <b>  t2</b>", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testNoSpaceSrc() {
        TextFragment srcTf = new TextFragment("t1");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append("t3");
        TextFragment trgTf = new TextFragment("t1  ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append("t2 ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append("   t3");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1<1>t2</1>t3", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1<b>t2</b>t3", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testNoSpaceTrg() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t3");
        TextFragment trgTf = new TextFragment("t1");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append("t2");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append("t3");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1 <1>t2</1> t3", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1 <b>t2</b> t3", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testTrgMultiInsert() {
        TextFragment srcTf = new TextFragment("t1  ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("  t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t3");
        TextFragment trgTf = new TextFragment("t1");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append("t2");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append("t3");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1  <1>  t2</1> t3", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1  <b>  t2</b> t3", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testSimpleRemoval() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t3.");
        TextFragment trgTf = new TextFragment("t1 ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" t2 ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append(" t3.");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1 <1>t2</1> t3.", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1 <b>t2</b> t3.", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testMultiCode() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t3 ");
        srcTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        srcTf.append("t4");
        srcTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        srcTf.append(" t5");
        TextFragment trgTf = new TextFragment("t1 ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" t2 ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append(" t3  ");
        trgTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        trgTf.append(" t4    ");
        trgTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        trgTf.append("t5");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1 <1>t2</1> t3 <2>t4</2> t5", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1 <b>t2</b> t3 <i>t4</i> t5", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testMultiNested() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        srcTf.append(" t3");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t4 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t5");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        TextFragment trgTf = new TextFragment("t1 ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" ");
        trgTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        trgTf.append(" t2 ");
        trgTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        trgTf.append(" t3  ");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append("t4 ");
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append("  t5");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"t1 <1><2>t2</2> t3</1> t4 <3>t5</3>", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"t1 <b><i>t2</i> t3</b> t4 <b>t5</b>", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testMultiCodeWithReorg() {
        TextFragment srcTf = new TextFragment("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        srcTf.append(" t3");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t4");
        TextFragment trgTf = new TextFragment();
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append(" ");
        trgTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        trgTf.append("t2  ");
        trgTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        trgTf.append("t3");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append(" ");
        trgTf.append(" t1 ");
        trgTf.append("t4");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"<1><2>t2</2> t3</1> t1 t4", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"<b><i>t2</i> t3</b> t1 t4", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testInitialSpaceSrc() {
        TextFragment srcTf = new TextFragment(" ");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        srcTf.append(" t3");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t4");
        TextFragment trgTf = new TextFragment();
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append("t1");
        trgTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        trgTf.append("t2  ");
        trgTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        trgTf.append("t3");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append("t4");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)" <1>t1 <2>t2</2> t3</1> t4", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)" <b>t1 <i>t2</i> t3</b> t4", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testTrailingSpaceSrc() {
        TextFragment srcTf = new TextFragment("");
        srcTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf.append("t1 ");
        srcTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        srcTf.append("t2");
        srcTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        srcTf.append(" t3");
        srcTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf.append(" t4 ");
        TextFragment trgTf = new TextFragment();
        trgTf.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf.append("t1");
        trgTf.append(TextFragment.TagType.OPENING, "italic", "<i>");
        trgTf.append("t2  ");
        trgTf.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        trgTf.append("t3");
        trgTf.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf.append("t4");
        this.checker.checkSpaces(srcTf, trgTf);
        Assert.assertEquals((Object)"<1>t1 <2>t2</2> t3</1> t4 ", (Object)this.fmt.setContent(trgTf).toString());
        Assert.assertEquals((Object)"<b>t1 <i>t2</i> t3</b> t4 ", (Object)this.fmt.setContent(trgTf).toString(true));
    }

    @Test
    public void testTUSimpleCase() {
        TextFragment srcTf1 = new TextFragment("t1 ");
        srcTf1.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf1.append("t2");
        srcTf1.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf1.append(" t3.");
        TextFragment srcTf2 = new TextFragment("t1 ");
        srcTf2.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf2.append(TextFragment.TagType.OPENING, "italic", "<i>");
        srcTf2.append("t2");
        srcTf2.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        srcTf2.append(" t3");
        srcTf2.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf2.append(" t4.");
        TextFragment frTf1 = new TextFragment("t1 ");
        frTf1.append(TextFragment.TagType.OPENING, "bold", "<b>");
        frTf1.append(" t2 ");
        frTf1.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        frTf1.append(" t3.");
        TextFragment frTf2 = new TextFragment();
        frTf2.append(TextFragment.TagType.OPENING, "bold", "<b>");
        frTf2.append(" ");
        frTf2.append(TextFragment.TagType.OPENING, "italic", "<i>");
        frTf2.append("t2  ");
        frTf2.append(TextFragment.TagType.CLOSING, "italic", "</i>");
        frTf2.append("t3");
        frTf2.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        frTf2.append(" ");
        frTf2.append(" t1 ");
        frTf2.append("t4.");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf1));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg2", srcTf2));
        TextContainer frTc = tu.createTarget(this.locFR, true, 0);
        frTc.append((TextPart)new Segment("seg1", frTf1));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg2", frTf2));
        this.checker.checkUnitSpacing((ITextUnit)tu, this.locFR);
        Assert.assertEquals((Object)"[t1 <1>t2</1> t3.] [<1><2>t2</2> t3</1> t1 t4.]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[t1 <b>t2</b> t3.] [<b><i>t2</i> t3</b> t1 t4.]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }

    @Test
    public void tuEndingCodeWithSpace() {
        TextFragment srcTf1 = new TextFragment();
        srcTf1.append(TextFragment.TagType.OPENING, "span", "<span>");
        srcTf1.append(TextFragment.TagType.OPENING, "strong", "<strong>");
        srcTf1.append("t1");
        srcTf1.append(TextFragment.TagType.CLOSING, "strong", "</strong>");
        srcTf1.append(TextFragment.TagType.CLOSING, "span", "</span>");
        srcTf1.append(" ");
        srcTf1.append(TextFragment.TagType.OPENING, "span", "<span>");
        srcTf1.append(TextFragment.TagType.OPENING, "em", "<em>");
        srcTf1.append("t2");
        srcTf1.append(TextFragment.TagType.CLOSING, "em", "</em>");
        srcTf1.append(TextFragment.TagType.CLOSING, "span", "</span>");
        TextFragment frTf1 = new TextFragment();
        frTf1.append(TextFragment.TagType.OPENING, "span", "<span>");
        frTf1.append(TextFragment.TagType.OPENING, "strong", "<strong>");
        frTf1.append("t1");
        frTf1.append(TextFragment.TagType.CLOSING, "strong", "</strong>");
        frTf1.append(TextFragment.TagType.CLOSING, "span", "</span>");
        frTf1.append(TextFragment.TagType.OPENING, "span", "<span>");
        frTf1.append(" ");
        frTf1.append(TextFragment.TagType.OPENING, "em", "<em>");
        frTf1.append("t2");
        frTf1.append(TextFragment.TagType.CLOSING, "em", "</em>");
        frTf1.append(TextFragment.TagType.CLOSING, "span", "</span>");
        frTf1.append(" ");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf1));
        TextContainer frTc = tu.createTarget(this.locFR, true, 0);
        frTc.append((TextPart)new Segment("seg1", frTf1));
        this.checker.checkUnitSpacing((ITextUnit)tu, this.locFR);
        Assert.assertEquals((Object)"[<1><2>t1</2></1> <3><4>t2</4></3>]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[<span><strong>t1</strong></span> <span><em>t2</em></span>]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }
}

