/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.verification.CharactersChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CharactersCheckerTests {
    private static final LocaleId SOURCE_LOCALE = LocaleId.ENGLISH;
    private static final LocaleId TARGET_LOCALE = LocaleId.FRENCH;
    private CharactersChecker checker;
    private List<Issue> issues;

    private void runTest(TextContainer srcCont, TextContainer trgCont, Parameters params) {
        TextUnit tu = new TextUnit("tu1");
        tu.setSource(srcCont);
        tu.setTarget(TARGET_LOCALE, trgCont);
        this.issues.clear();
        this.checker.startProcess(SOURCE_LOCALE, TARGET_LOCALE, params, this.issues);
        this.checker.processTextUnit((ITextUnit)tu);
    }

    @Before
    public void setUp() {
        this.checker = new CharactersChecker();
        this.issues = new ArrayList<Issue>();
    }

    @Test
    public void testCharset() {
        Parameters params = new Parameters();
        params.setCheckCharacters(true);
        params.setCheckAllowedCharacters(false);
        params.setUseGenericCodes(false);
        params.setCharset("us-ascii");
        TextFragment srcFrag = new TextFragment("a");
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "br", "[CODE/]");
        srcFrag.append("b \u039e c");
        TextContainer srcCont = new TextContainer(srcFrag);
        TextFragment trgFrag = new TextFragment("qwerty");
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "br", "[CODE/]");
        trgFrag.append("y \u039e z");
        TextContainer trgCont = new TextContainer(trgFrag);
        this.runTest(srcCont, trgCont, params);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((long)15L, (long)this.issues.get(0).getTargetStart());
        Assert.assertEquals((long)16L, (long)this.issues.get(0).getTargetEnd());
        Assert.assertEquals((Object)"qwerty[CODE/]y \u039e z", (Object)this.issues.get(0).getTarget());
        params.setUseGenericCodes(true);
        this.runTest(srcCont, trgCont, params);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((long)12L, (long)this.issues.get(0).getTargetStart());
        Assert.assertEquals((long)13L, (long)this.issues.get(0).getTargetEnd());
        Assert.assertEquals((Object)"qwerty<1/>y \u039e z", (Object)this.issues.get(0).getTarget());
    }

    @Test
    public void testCorruptedChars() {
        Parameters params = new Parameters();
        params.setCheckCharacters(false);
        params.setCheckAllowedCharacters(false);
        params.setCorruptedCharacters(true);
        params.setUseGenericCodes(false);
        TextFragment srcFrag = new TextFragment("a");
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "br", "[CODE/]");
        srcFrag.append("b \u00c3\u00a4 c");
        TextContainer srcCont = new TextContainer(srcFrag);
        TextFragment trgFrag = new TextFragment("qwerty");
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "br", "[CODE/]");
        trgFrag.append("y \u00c3\u00a4 z");
        TextContainer trgCont = new TextContainer(trgFrag);
        this.runTest(srcCont, trgCont, params);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((long)15L, (long)this.issues.get(0).getTargetStart());
        Assert.assertEquals((long)17L, (long)this.issues.get(0).getTargetEnd());
        Assert.assertEquals((Object)"qwerty[CODE/]y \u00c3\u00a4 z", (Object)this.issues.get(0).getTarget());
        params.setUseGenericCodes(true);
        this.runTest(srcCont, trgCont, params);
        Assert.assertEquals((long)1L, (long)this.issues.size());
        Assert.assertEquals((long)12L, (long)this.issues.get(0).getTargetStart());
        Assert.assertEquals((long)14L, (long)this.issues.get(0).getTargetEnd());
        Assert.assertEquals((Object)"qwerty<1/>y \u00c3\u00a4 z", (Object)this.issues.get(0).getTarget());
    }

    @Test
    public void testITSAnnotation() {
        Parameters params = new Parameters();
        params.setCheckCharacters(false);
        params.setCheckAllowedCharacters(true);
        params.setUseGenericCodes(false);
        TextFragment srcFrag = new TextFragment("a");
        srcFrag.append(TextFragment.TagType.PLACEHOLDER, "br", "[CODE/]");
        srcFrag.append("bcd");
        TextContainer srcCont = new TextContainer(srcFrag);
        GenericAnnotation ga = new GenericAnnotation("its-allowedchars");
        ga.setString("allowedcharsValue", "[abc]");
        GenericAnnotation.addAnnotation((TextContainer)srcCont, (GenericAnnotation)ga);
        TextFragment trgFrag = new TextFragment("qwerty");
        trgFrag.append(TextFragment.TagType.PLACEHOLDER, "br", "[CODE/]");
        trgFrag.append("qwertZ");
        TextContainer trgCont = new TextContainer(trgFrag);
        GenericAnnotation ga2 = new GenericAnnotation("its-allowedchars");
        ga2.setString("allowedcharsValue", "[qwerty]");
        GenericAnnotation.addAnnotation((TextContainer)trgCont, (GenericAnnotation)ga2);
        this.runTest(srcCont, trgCont, params);
        Assert.assertEquals((long)2L, (long)this.issues.size());
        Issue issue = this.issues.get(0);
        Assert.assertEquals((long)10L, (long)issue.getSourceStart());
        Assert.assertEquals((long)11L, (long)issue.getSourceEnd());
        Assert.assertEquals((Object)"a[CODE/]bcd", (Object)issue.getSource());
        issue = this.issues.get(1);
        Assert.assertEquals((long)18L, (long)issue.getTargetStart());
        Assert.assertEquals((long)19L, (long)issue.getTargetEnd());
        Assert.assertEquals((Object)"qwerty[CODE/]qwertZ", (Object)issue.getTarget());
        params.setUseGenericCodes(true);
        this.runTest(srcCont, trgCont, params);
        Assert.assertEquals((long)2L, (long)this.issues.size());
        issue = this.issues.get(0);
        Assert.assertEquals((long)7L, (long)issue.getSourceStart());
        Assert.assertEquals((long)8L, (long)issue.getSourceEnd());
        Assert.assertEquals((Object)"a<1/>bcd", (Object)issue.getSource());
        issue = this.issues.get(1);
        Assert.assertEquals((long)15L, (long)issue.getTargetStart());
        Assert.assertEquals((long)16L, (long)issue.getTargetEnd());
        Assert.assertEquals((Object)"qwerty<1/>qwertZ", (Object)issue.getTarget());
    }
}

