/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.verification.JarLSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateXliffSchema {
    public static final String XLIFF12_TRANSITIONAL_SCHEMA = "xliff-core-1.2-transitional.xsd";
    public static final String XLIFF12_STRICT_SCHEMA = "xliff-core-1.2-strict.xsd";
    private static final Validator TRANSITIONAL_VALIDATOR = ValidateXliffSchema.createValidator("xliff-core-1.2-transitional.xsd");
    private static final Validator STRICT_VALIDATOR = ValidateXliffSchema.createValidator("xliff-core-1.2-strict.xsd");

    private static Validator createValidator(String schemaName) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            JarLSResourceResolver jarResolver = new JarLSResourceResolver();
            factory.setResourceResolver(jarResolver);
            InputStream is = ValidateXliffSchema.class.getResourceAsStream(schemaName);
            return factory.newSchema(new StreamSource(is)).newValidator();
        }
        catch (SAXException sAXException) {
            throw new OkapiIOException("XLIFF Schame Validation : internal error, invalid " + schemaName);
        }
    }

    public static boolean validateXliffSchema(InputStream inStream) {
        return ValidateXliffSchema.validateXliffSchema(inStream, XLIFF12_TRANSITIONAL_SCHEMA);
    }

    public static boolean validateXliffSchema(InputStream inStream, String schemaName) {
        Validator validator = null;
        switch (schemaName) {
            case "xliff-core-1.2-transitional.xsd": {
                validator = TRANSITIONAL_VALIDATOR;
                break;
            }
            case "xliff-core-1.2-strict.xsd": {
                validator = STRICT_VALIDATOR;
                break;
            }
            default: {
                validator = null;
            }
        }
        if (validator == null) {
            return true;
        }
        try {
            validator.validate(new StreamSource(inStream));
            return true;
        }
        catch (SAXParseException ex) {
            String message = ex.getMessage();
            if (!message.startsWith("Duplicate key value [") || !message.endsWith("] declared for identity constraint of element \"file\".")) {
                String errorString = String.format("XLIFF Validation Error [%d, %d]:\n  %s\n  %s", ex.getLineNumber(), ex.getColumnNumber(), ex.getSystemId(), ex.getMessage());
                throw new OkapiIOException(errorString);
            }
        }
        catch (Exception ex) {
            throw new OkapiIOException("XLIFF Validation Error: " + ex.getMessage());
        }
        return false;
    }

    public static boolean validateXliffSchema(URI fileURI) {
        return ValidateXliffSchema.validateXliffSchema(fileURI, XLIFF12_TRANSITIONAL_SCHEMA);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateXliffSchema(URI fileURI, String schemaName) {
        try (FileInputStream inStream = new FileInputStream(new File(fileURI));){
            boolean bl = ValidateXliffSchema.validateXliffSchema(inStream, schemaName);
            return bl;
        }
        catch (IOException ex) {
            throw new OkapiIOException("XLIFF Validation Error: " + ex.getMessage());
        }
    }
}

