/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.virtualdb.jdbc.h2;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.virtualdb.IVDocument;
import net.sf.okapi.virtualdb.IVItem;
import net.sf.okapi.virtualdb.IVRepository;
import net.sf.okapi.virtualdb.KeyAndSegId;
import net.sf.okapi.virtualdb.jdbc.IDBAccess;
import net.sf.okapi.virtualdb.jdbc.h2.H2Document;
import net.sf.okapi.virtualdb.jdbc.h2.H2DocumentIterator;
import net.sf.okapi.virtualdb.jdbc.h2.H2Group;
import net.sf.okapi.virtualdb.jdbc.h2.H2Importer;
import net.sf.okapi.virtualdb.jdbc.h2.H2Navigator;
import net.sf.okapi.virtualdb.jdbc.h2.H2SubDocument;
import net.sf.okapi.virtualdb.jdbc.h2.H2TextUnit;

public class H2Access
implements IDBAccess {
    public static final int ITEMKIND_DOCUMENT = 0;
    public static final int ITEMKIND_SUBDOCUMENT = 1;
    public static final int ITEMKIND_GROUP = 2;
    public static final int ITEMKIND_TEXTUNIT = 3;
    public static final String H2DB_EXT = ".h2.db";
    public static final int VERSION = 100;
    public static final String INFO_TBLNAME = "INFO";
    public static final String INFO_KEY = "KEY";
    public static final String INFO_VERSION = "VERSION";
    public static final String INFO_EXTRA1 = "EXTRA1";
    public static final String ITMS_TBLNAME = "ITMS";
    public static final String ITMS_KEY = "KEY";
    public static final String ITMS_DKEY = "DKEY";
    public static final String ITMS_PARENT = "PARENT";
    public static final String ITMS_FCHILD = "FCHILD";
    public static final String ITMS_PREV = "PREV";
    public static final String ITMS_NEXT = "NEXT";
    public static final String ITMS_KIND = "KIND";
    public static final String ITMS_LEVEL = "LEVEL";
    public static final String ITMS_XID = "XID";
    public static final String ITMS_NAME = "NAME";
    public static final String ITMS_TYPE = "TYPE";
    public static final String TUNS_TBLNAME = "TUNS";
    public static final String TUNS_KEY = "KEY";
    public static final String TUNS_IKEY = "IKEY";
    public static final String TUNS_CTEXT = "CTEXT";
    public static final String TUNS_CODES = "CODES";
    public static final String TUNS_TRGCTEXT = "TRGCTEXT";
    public static final String TUNS_TRGCODES = "TRGCODES";
    public static final String SEGS_TBLNAME = "SEGS";
    public static final String SEGS_KEY = "KEY";
    public static final String SEGS_IKEY = "IKEY";
    public static final String SEGS_SID = "SID";
    public static final String SEGS_CTEXT = "CTEXT";
    public static final String SEGS_TRGCTEXT = "TRGCTEXT";
    private H2Access self;
    private IDBAccess.RepositoryType repoType;
    private String baseDir;
    private Connection conn = null;
    private PreparedStatement pstmItemByKey;
    private PreparedStatement pstmItemById;
    private IFilterConfigurationMapper fcMapper;

    public H2Access(IFilterConfigurationMapper fcMapper) {
        this.initialize(IDBAccess.RepositoryType.INMEMORY, fcMapper);
    }

    public H2Access(String baseDirectory, IFilterConfigurationMapper fcMapper) {
        this.initialize(IDBAccess.RepositoryType.LOCAL, fcMapper);
        this.baseDir = baseDirectory;
        if (!this.baseDir.endsWith("/") || !this.baseDir.endsWith("\\")) {
            this.baseDir = this.baseDir + "/";
        }
    }

    private void initialize(IDBAccess.RepositoryType repositoryType, IFilterConfigurationMapper fcMapper) {
        this.repoType = repositoryType;
        this.fcMapper = fcMapper;
        this.self = this;
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public void close() {
        try {
            if (this.pstmItemByKey != null) {
                this.pstmItemByKey.close();
                this.pstmItemByKey = null;
            }
            if (this.pstmItemById != null) {
                this.pstmItemById.close();
                this.pstmItemById = null;
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    private void initGlobal() throws SQLException {
        if (this.conn == null) {
            return;
        }
        this.pstmItemByKey = this.conn.prepareStatement("select * from ITMS left join TUNS on ITMS.KEY=TUNS.IKEY WHERE ITMS.KEY=?");
        this.pstmItemById = this.conn.prepareStatement("select * from ITMS left join TUNS on ITMS.KEY=TUNS.IKEY where ITMS.XID=? and ITMS.DKEY=?");
    }

    @Override
    public void open(String name, IVRepository.OpeningMode mode) {
        this.close();
        if (name.endsWith(H2DB_EXT)) {
            name = name.substring(0, name.length() - H2DB_EXT.length());
        }
        String connStr = null;
        switch (this.repoType) {
            case INMEMORY: {
                connStr = "jdbc:h2:" + name;
                if (mode != IVRepository.OpeningMode.MUST_EXIST) break;
                connStr = connStr + ";IFEXISTS=TRUE";
                break;
            }
            case LOCAL: {
                File file;
                String path = this.baseDir + name;
                if (mode == IVRepository.OpeningMode.OVERWRITE && (file = new File(path + H2DB_EXT)).exists()) {
                    this.deleteFiles(path);
                }
                Util.createDirectories((String)path);
                connStr = "jdbc:h2:" + this.baseDir + name;
                if (mode != IVRepository.OpeningMode.MUST_EXIST) break;
                connStr = connStr + ";IFEXISTS=TRUE";
                break;
            }
            default: {
                throw new OkapiException("Unsupported repository type.");
            }
        }
        try {
            this.conn = DriverManager.getConnection(connStr, "sa", "");
            this.conn.setAutoCommit(true);
            this.createTables();
            this.initGlobal();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    @Override
    public void open(String name) {
        this.close();
        String connStr = null;
        switch (this.repoType) {
            case INMEMORY: {
                connStr = "jdbc:h2:mem:" + name + ";IFEXISTS=TRUE";
                break;
            }
            case LOCAL: {
                connStr = "jdbc:h2:" + this.baseDir + name + ";IFEXISTS=TRUE";
                break;
            }
            default: {
                throw new OkapiException("Unsupported repository type.");
            }
        }
        try {
            this.conn = DriverManager.getConnection(connStr, "sa", "");
            this.conn.setAutoCommit(true);
            this.initGlobal();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    @Override
    public void create(String name) {
        this.close();
        String connStr = null;
        switch (this.repoType) {
            case INMEMORY: {
                connStr = "jdbc:h2:mem:" + name;
                break;
            }
            case LOCAL: {
                String path = this.baseDir + name;
                File file = new File(path + H2DB_EXT);
                if (file.exists()) {
                    this.deleteFiles(path);
                } else {
                    Util.createDirectories((String)path);
                }
                connStr = "jdbc:h2:" + path;
                break;
            }
            default: {
                throw new OkapiException("Unsupported repository type.");
            }
        }
        try {
            this.conn = DriverManager.getConnection(connStr, "sa", "");
            this.createTables();
            this.initGlobal();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    private void deleteFiles(String path) {
        String filename;
        String dir = Util.getDirectoryName((String)path);
        File d = new File(dir);
        class WildcharFilenameFilter
        implements FilenameFilter {
            String filename;

            public WildcharFilenameFilter(String filename) {
                this.filename = filename;
            }

            @Override
            public boolean accept(File dir, String name) {
                return Pattern.matches(this.filename + "\\..*?\\.db", name);
            }
        }
        File[] list = d.listFiles(new WildcharFilenameFilter(filename = Util.getFilename((String)path, (boolean)false)));
        if (list == null) {
            return;
        }
        for (File f : list) {
            f.delete();
        }
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("delete()");
    }

    @Override
    public Iterable<IVDocument> documents() {
        return new Iterable<IVDocument>(){

            @Override
            public Iterator<IVDocument> iterator() {
                return new H2DocumentIterator(H2Access.this.self);
            }
        };
    }

    List<Long> getDocumentsKeys() {
        Statement stm = null;
        try {
            stm = this.conn.createStatement();
            ResultSet rs = stm.executeQuery(String.format("select KEY from ITMS where KIND=%d", 0));
            ArrayList<Long> list = new ArrayList<Long>();
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
            ArrayList<Long> arrayList = list;
            return arrayList;
        }
        catch (Throwable e) {
            throw new OkapiException("Error reading keys.\n" + e.getMessage());
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    List<Long> getItemsKeys(long docKey, boolean tuOnly) {
        Statement stm = null;
        try {
            stm = this.conn.createStatement();
            String query = "select KEY from ITMS";
            if (docKey == -1L) {
                if (tuOnly) {
                    query = query + String.format(" where KIND=%d", 3);
                }
            } else {
                query = query + String.format(" where DKEY=%d", docKey);
                if (tuOnly) {
                    query = query + String.format(" and KIND=%d", 3);
                }
            }
            ResultSet rs = stm.executeQuery(query);
            ArrayList<Long> list = new ArrayList<Long>();
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
            ArrayList<Long> arrayList = list;
            return arrayList;
        }
        catch (Throwable e) {
            throw new OkapiException("Error reading keys.\n" + e.getMessage());
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    @Override
    public String importDocument(RawDocument rd) {
        H2Importer imp = new H2Importer(this, this.fcMapper);
        imp.importDocument(rd);
        return null;
    }

    @Override
    public long importDocumentReturnKey(RawDocument rd) {
        H2Importer imp = new H2Importer(this, this.fcMapper);
        return imp.importDocument(rd);
    }

    private void createTables() {
        Statement stm = null;
        try {
            ResultSet rs = this.conn.getMetaData().getTables(null, null, INFO_TBLNAME, null);
            if (rs.next()) {
                return;
            }
            stm = this.conn.createStatement();
            stm.execute("CREATE TABLE INFO (KEY INTEGER PRIMARY KEY,VERSION INTEGER,EXTRA1 BLOB)");
            stm.execute("CREATE TABLE ITMS (KEY INTEGER IDENTITY PRIMARY KEY,DKEY INTEGER,PARENT INTEGER,FCHILD INTEGER,PREV INTEGER,NEXT INTEGER,KIND INTEGER,LEVEL INTEGER,XID VARCHAR,NAME VARCHAR,TYPE VARCHAR)");
            stm.execute("CREATE TABLE TUNS (KEY INTEGER IDENTITY PRIMARY KEY,IKEY INTEGER REFERENCES ITMS(KEY) ON DELETE CASCADE,CTEXT VARCHAR,CODES VARCHAR,TRGCTEXT VARCHAR,TRGCODES VARCHAR)");
            stm.execute(String.format("INSERT INTO %s (%s,%s) VALUES(%d,%d)", INFO_TBLNAME, "KEY", INFO_VERSION, 1, 100));
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    void saveDocument(H2Document doc) {
        Statement pstm = null;
        try {
            pstm = this.conn.prepareStatement(String.format("update ITMS set %s=?, %s=? where %s=?", ITMS_PREV, ITMS_NEXT, "KEY"));
            pstm.setLong(1, doc.previous);
            pstm.setLong(2, doc.next);
            pstm.setLong(3, doc.key);
            pstm.execute();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    protected void saveTextUnit(H2TextUnit htu) {
        Statement pstm = null;
        try {
            pstm = this.conn.prepareStatement(String.format("update TUNS set %s=?, %s=? where %s=?", "TRGCTEXT", TUNS_TRGCODES, "IKEY"));
            String[] trgData = this.targetsToStorage(htu.getTextUnit());
            pstm.setString(1, trgData[0]);
            pstm.setString(2, trgData[1]);
            pstm.setLong(3, htu.getKey());
            pstm.execute();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    IVItem getItemFromExtractionId(H2Document doc, String id) {
        try {
            this.pstmItemById.setString(1, id);
            this.pstmItemById.setLong(2, doc.key);
            ResultSet rs = this.pstmItemById.executeQuery();
            if (!rs.first()) {
                return null;
            }
            IVItem it = this.fillItem(doc, rs);
            return it;
        }
        catch (Throwable e) {
            throw new OkapiException("Error reading an item.\n" + e.getMessage());
        }
    }

    IVItem getItemFromItemKey(H2Document doc, long itemKey) {
        if (itemKey == -1L) {
            return null;
        }
        try {
            this.pstmItemByKey.setLong(1, itemKey);
            ResultSet rs = this.pstmItemByKey.executeQuery();
            if (!rs.first()) {
                return null;
            }
            return this.fillItem(doc, rs);
        }
        catch (Throwable e) {
            throw new OkapiException("Error reading an item.\n" + e.getMessage());
        }
    }

    private IVItem fillItem(H2Document doc, ResultSet rs) {
        IVItem item = null;
        try {
            switch (rs.getInt(ITMS_KIND)) {
                case 3: {
                    H2TextUnit htu = new H2TextUnit(rs.getLong("IKEY"), doc, rs.getString(ITMS_XID), rs.getString(ITMS_NAME), rs.getString(ITMS_TYPE));
                    htu.fillPointers(rs.getLong(ITMS_PARENT), rs.getLong(ITMS_PREV), rs.getLong(ITMS_NEXT));
                    ITextUnit tu = htu.getTextUnit();
                    tu.setSource(TextContainer.splitStorageToContent((String)rs.getString("CTEXT"), (String)rs.getString(TUNS_CODES)));
                    this.storageToTargets(tu, rs.getString("TRGCTEXT"), rs.getString(TUNS_TRGCODES));
                    item = htu;
                    break;
                }
                case 2: {
                    H2Group grp = new H2Group(rs.getLong("ITMS.KEY"), doc, rs.getString(ITMS_XID), rs.getString(ITMS_NAME), rs.getString(ITMS_TYPE));
                    grp.fillPointers(rs.getLong(ITMS_PARENT), rs.getLong(ITMS_FCHILD), rs.getLong(ITMS_PREV), rs.getLong(ITMS_NEXT));
                    item = grp;
                    break;
                }
                case 1: {
                    H2SubDocument sd = new H2SubDocument(rs.getLong("ITMS.KEY"), doc, rs.getString(ITMS_XID), rs.getString(ITMS_NAME), rs.getString(ITMS_TYPE));
                    sd.fillPointers(rs.getLong(ITMS_PARENT), rs.getLong(ITMS_FCHILD), rs.getLong(ITMS_PREV), rs.getLong(ITMS_NEXT));
                    item = sd;
                    break;
                }
                case 0: {
                    H2Document newDoc = new H2Document(this, rs.getLong("ITMS.KEY"), rs.getString(ITMS_XID), rs.getString(ITMS_NAME), rs.getString(ITMS_TYPE));
                    newDoc.fillPointers(rs.getLong(ITMS_PARENT), rs.getLong(ITMS_FCHILD), rs.getLong(ITMS_PREV), rs.getLong(ITMS_NEXT));
                    item = newDoc;
                }
            }
            return item;
        }
        catch (Throwable e) {
            throw new OkapiException("Error filling item.\n" + e.getMessage());
        }
    }

    @Override
    public IVDocument getDocument(long itemKey) {
        Statement stm = null;
        H2Document doc = null;
        try {
            stm = this.conn.createStatement();
            ResultSet rs = stm.executeQuery(String.format("select * from ITMS where KEY=%d", itemKey));
            if (rs.first()) {
                doc = new H2Document(this, itemKey, rs.getString(ITMS_XID), rs.getString(ITMS_NAME), rs.getString(ITMS_TYPE));
                doc.fillPointers(rs.getLong(ITMS_PARENT), rs.getLong(ITMS_FCHILD), rs.getLong(ITMS_PREV), rs.getLong(ITMS_NEXT));
            }
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
        return doc;
    }

    void completeItemsWriting(LinkedHashMap<Long, H2Navigator> items) {
        Statement pstm = null;
        try {
            pstm = this.conn.prepareStatement(String.format("UPDATE %s SET %s=?, %s=?, %s=?, %s=?, %s=? WHERE %s=?", ITMS_TBLNAME, ITMS_PARENT, ITMS_LEVEL, ITMS_FCHILD, ITMS_PREV, ITMS_NEXT, "KEY"));
            for (H2Navigator item : items.values()) {
                pstm.setLong(1, item.parent);
                pstm.setLong(2, item.level);
                pstm.setLong(3, item.firstChild);
                pstm.setLong(4, item.previous);
                pstm.setLong(5, item.next);
                pstm.setLong(6, item.key);
                pstm.execute();
            }
            pstm.close();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    long writeResourceData(INameable res, IVItem.ItemType type, long docKey) {
        long itemKey = -1L;
        Statement pstm = null;
        try {
            pstm = this.conn.prepareStatement(String.format("INSERT INTO %s (%s,%s,%s,%s,%s) VALUES(?,?,?,?,?);", ITMS_TBLNAME, ITMS_DKEY, ITMS_KIND, ITMS_XID, ITMS_NAME, ITMS_TYPE));
            pstm.setLong(1, docKey);
            switch (type) {
                case DOCUMENT: {
                    pstm.setShort(2, (short)0);
                    break;
                }
                case SUB_DOCUMENT: {
                    pstm.setShort(2, (short)1);
                    break;
                }
                case GROUP: {
                    pstm.setShort(2, (short)2);
                    break;
                }
            }
            pstm.setString(3, res.getId());
            pstm.setString(4, res.getName());
            pstm.setString(5, res.getType());
            pstm.execute();
            ResultSet keys = pstm.getGeneratedKeys();
            if (keys.first()) {
                itemKey = keys.getLong(1);
            }
            pstm.close();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
        return itemKey;
    }

    @Override
    public void removeDocument(IVDocument vdoc) {
        Statement pstm = null;
        try {
            H2Document doc = (H2Document)vdoc;
            if (doc.previous > -1L) {
                pstm = this.conn.prepareStatement(String.format("UPDATE %s SET %s=? WHERE %s=?", ITMS_TBLNAME, ITMS_NEXT, "KEY"));
                pstm.setLong(1, doc.next);
                pstm.setLong(2, doc.previous);
                pstm.execute();
                pstm.close();
            }
            if (doc.next > -1L) {
                pstm = this.conn.prepareStatement(String.format("UPDATE %s SET %s=? WHERE %s=?", ITMS_TBLNAME, ITMS_PREV, "KEY"));
                pstm.setLong(1, doc.previous);
                pstm.setLong(2, doc.next);
                pstm.execute();
                pstm.close();
            }
            pstm = this.conn.prepareStatement(String.format("delete from %s where %s=?", ITMS_TBLNAME, ITMS_DKEY));
            pstm.setLong(1, doc.key);
            pstm.execute();
            pstm.close();
            pstm = this.conn.prepareStatement(String.format("delete from %s where %s=?", ITMS_TBLNAME, "KEY"));
            pstm.setLong(1, doc.key);
            pstm.execute();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    long writeTextUnitData(ITextUnit tu, long docKey) {
        long itemKey = -1L;
        Statement pstm = null;
        try {
            pstm = this.conn.prepareStatement(String.format("INSERT INTO %s (%s,%s,%s,%s,%s) VALUES(?,?,?,?,?);", ITMS_TBLNAME, ITMS_DKEY, ITMS_KIND, ITMS_XID, ITMS_NAME, ITMS_TYPE));
            pstm.setLong(1, docKey);
            pstm.setShort(2, (short)3);
            pstm.setString(3, tu.getId());
            pstm.setString(4, tu.getName());
            pstm.setString(5, tu.getType());
            pstm.execute();
            ResultSet keys = pstm.getGeneratedKeys();
            if (keys.first()) {
                itemKey = keys.getLong(1);
            }
            pstm.close();
            pstm = this.conn.prepareStatement(String.format("INSERT INTO %s (%s,%s,%s,%s,%s) VALUES(?,?,?,?,?);", TUNS_TBLNAME, "IKEY", "CTEXT", TUNS_CODES, "TRGCTEXT", TUNS_TRGCODES));
            String[] srcData = TextContainer.contentToSplitStorage((TextContainer)tu.getSource());
            String[] trgData = this.targetsToStorage(tu);
            pstm.setLong(1, itemKey);
            pstm.setString(2, srcData[0]);
            pstm.setString(3, srcData[1]);
            pstm.setString(4, trgData[0]);
            pstm.setString(5, trgData[1]);
            pstm.execute();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
        return itemKey;
    }

    private String[] targetsToStorage(ITextUnit tu) {
        String[] res = new String[2];
        StringBuilder tmp0 = new StringBuilder();
        StringBuilder tmp1 = new StringBuilder();
        for (LocaleId loc : tu.getTargetLocales()) {
            TextContainer tc = tu.getTarget(loc);
            tmp0.append(loc.toString() + "|");
            String[] data = TextContainer.contentToSplitStorage((TextContainer)tc);
            tmp0.append(data[0]);
            tmp0.append("\u0093");
            tmp1.append(data[1]);
            tmp1.append("\u0093");
        }
        res[0] = tmp0.toString();
        res[1] = tmp1.toString();
        return res;
    }

    private void storageToTargets(ITextUnit tu, String ctext, String codes) {
        String[] codesParts = codes.split("\u0093", -2);
        String[] ctextParts = ctext.split("\u0093", -2);
        for (int i = 0; i < ctextParts.length - 1; ++i) {
            int n = ctextParts[i].indexOf(124);
            LocaleId loc = LocaleId.fromString((String)ctextParts[i].substring(0, n));
            TextContainer tc = TextContainer.splitStorageToContent((String)ctextParts[i].substring(n + 1), (String)codesParts[i]);
            tu.setTarget(loc, tc);
        }
    }

    @Override
    public IVDocument getFirstDocument() {
        List<Long> list = this.getDocumentsKeys();
        if (list.size() < 1) {
            return null;
        }
        return this.getDocument(list.get(0));
    }

    @Override
    public void saveExtraData1(InputStream inputStream) {
        Statement pstm = null;
        try {
            pstm = this.conn.prepareStatement(String.format("update %s set %s=? where %s=1", INFO_TBLNAME, INFO_EXTRA1, "KEY"));
            pstm.setBinaryStream(1, inputStream);
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    @Override
    public InputStream loadExtraData1() {
        Statement pstm = null;
        try {
            pstm = this.conn.prepareStatement(String.format("select %s from %s where %s=1", INFO_EXTRA1, INFO_TBLNAME, "KEY"));
            ResultSet rs = pstm.executeQuery();
            if (!rs.first()) {
                InputStream inputStream = null;
                return inputStream;
            }
            Blob blob = rs.getBlob(1);
            if (blob == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            InputStream inputStream = blob.getBinaryStream();
            return inputStream;
        }
        catch (SQLException e) {
            throw new OkapiException((Throwable)e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
    }

    public List<List<KeyAndSegId>> getSegmentsWithSameSourceButDifferentTarget(LocaleId trgLoc) {
        List<List<KeyAndSegId>> list = Collections.emptyList();
        Statement stm = null;
        Statement pstm = null;
        try {
            stm = this.conn.createStatement();
            stm.execute("DROP TABLE IF EXISTS SEGS");
            stm.execute("CREATE TEMPORARY TABLE SEGS (KEY INTEGER IDENTITY PRIMARY KEY,IKEY INTEGER,SID VARCHAR,CTEXT VARCHAR,TRGCTEXT VARCHAR)");
            String query = String.format("select ITMS.KEY, %s, %s from ITMS left join TUNS on ITMS.KEY=TUNS.IKEY where ITMS.KIND=%d", "CTEXT", "TRGCTEXT", 3);
            ResultSet rs = stm.executeQuery(query);
            pstm = this.conn.prepareStatement(String.format("INSERT INTO %s (%s,%s,%s,%s) VALUES(?,?,?,?)", SEGS_TBLNAME, "IKEY", SEGS_SID, "CTEXT", "TRGCTEXT"));
            while (rs.next()) {
                ITextUnit tu = ((H2TextUnit)this.getItemFromItemKey(null, rs.getLong(1))).getTextUnit();
                ISegments srcSegs = tu.getSource().getSegments();
                ISegments trgSegs = tu.createTarget(trgLoc, false, 0).getSegments();
                for (Segment seg : srcSegs) {
                    Segment trgSeg = trgSegs.get(seg.id);
                    pstm.setLong(1, rs.getLong(1));
                    pstm.setString(2, seg.id);
                    pstm.setString(3, seg.text.toString());
                    pstm.setString(4, trgSeg == null ? "" : trgSeg.text.toString());
                    pstm.execute();
                }
            }
            rs.close();
            rs = null;
            query = String.format("select %s, %s, %s, %s from %s order by %s DESC, %s", "IKEY", SEGS_SID, "CTEXT", "TRGCTEXT", SEGS_TBLNAME, "CTEXT", "TRGCTEXT");
            rs = stm.executeQuery(query);
            list = this.processSameSourceDifferentTarget(rs, 1, 2, 3, 4);
            stm.execute("DROP TABLE IF EXISTS SEGS");
        }
        catch (Throwable e) {
            throw new OkapiException("Error when looking for groups of items.\n" + e.getMessage());
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
        return list;
    }

    private List<List<KeyAndSegId>> processSameSourceDifferentTarget(ResultSet rs, int itemKeyCol, int segIdCol, int srcCol, int trgCol) throws SQLException {
        ArrayList<List<KeyAndSegId>> list = new ArrayList<List<KeyAndSegId>>();
        long prevKey = -1L;
        String prevSegId = null;
        String prevSrc = "";
        String prevTrg = "";
        boolean hasDiff = false;
        ArrayList<KeyAndSegId> group = new ArrayList<KeyAndSegId>();
        while (rs.next()) {
            if (prevKey == -1L) {
                prevKey = rs.getLong(itemKeyCol);
                if (segIdCol > 0) {
                    prevSegId = rs.getString(segIdCol);
                }
                prevSrc = rs.getString(srcCol);
                prevTrg = rs.getString(trgCol);
                continue;
            }
            if (prevSrc.equals(rs.getString(srcCol))) {
                if (prevKey != -2L) {
                    group.add(new KeyAndSegId(prevKey, prevSegId));
                    prevKey = -2L;
                }
                group.add(new KeyAndSegId(rs.getLong(itemKeyCol), segIdCol > 0 ? rs.getString(segIdCol) : null));
                if (hasDiff || prevTrg.equals(rs.getString(trgCol))) continue;
                hasDiff = true;
                continue;
            }
            if (hasDiff) {
                list.add(new ArrayList(group));
            }
            hasDiff = false;
            group.clear();
            prevKey = rs.getLong(itemKeyCol);
            if (segIdCol > 0) {
                prevSegId = rs.getString(segIdCol);
            }
            prevSrc = rs.getString(srcCol);
            prevTrg = rs.getString(trgCol);
        }
        if (hasDiff) {
            list.add(group);
        }
        return list;
    }

    public List<List<KeyAndSegId>> getSameSourceWithDifferentTarget() {
        List<List<KeyAndSegId>> list = Collections.emptyList();
        Statement stm = null;
        try {
            stm = this.conn.createStatement();
            String query = String.format("select ITMS.KEY, %s, %s from ITMS left join TUNS on ITMS.KEY=TUNS.IKEY where ITMS.KIND=%d order by %s DESC, %s", "CTEXT", "TRGCTEXT", 3, "CTEXT", "TRGCTEXT");
            ResultSet rs = stm.executeQuery(query);
            list = this.processSameSourceDifferentTarget(rs, 1, -1, 2, 3);
        }
        catch (Throwable e) {
            throw new OkapiException("Error when looking for groups of items.\n" + e.getMessage());
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new OkapiException((Throwable)e);
            }
        }
        return list;
    }
}

