/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Scanner;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.terminology.simpletb.SimpleTB;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.BlacklistChecker;
import net.sf.okapi.lib.verification.BlacklistTB;
import net.sf.okapi.lib.verification.CharactersChecker;
import net.sf.okapi.lib.verification.GeneralChecker;
import net.sf.okapi.lib.verification.InlineCodesChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.LanguageToolConnector;
import net.sf.okapi.lib.verification.LengthChecker;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternsChecker;
import net.sf.okapi.lib.verification.TermChecker;

class QualityChecker
extends AbstractChecker {
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private LanguageToolConnector ltConn;
    private TermChecker termChecker;
    private BlacklistChecker blacklistChecker;
    private Parameters params;
    private URI currentDocId;
    private String currentSubDocId;
    private GeneralChecker generalChecker;
    private LengthChecker lengthChecker;
    private InlineCodesChecker inlineCodesChecker;
    private PatternsChecker patternsChecker;
    private CharactersChecker charactersChecker;

    QualityChecker() {
    }

    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        this.params = params;
        this.generalChecker = new GeneralChecker();
        this.lengthChecker = new LengthChecker();
        this.inlineCodesChecker = new InlineCodesChecker();
        this.patternsChecker = new PatternsChecker();
        this.charactersChecker = new CharactersChecker();
        super.startProcess(sourceLocale, targetLocale, params, issues);
        this.generalChecker.startProcess(sourceLocale, targetLocale, params, issues);
        this.lengthChecker.startProcess(sourceLocale, targetLocale, params, issues);
        this.inlineCodesChecker.startProcess(sourceLocale, targetLocale, params, issues);
        this.patternsChecker.startProcess(sourceLocale, targetLocale, params, issues);
        this.charactersChecker.startProcess(sourceLocale, targetLocale, params, issues);
        this.ltConn = null;
        if (params.getCheckWithLT()) {
            this.ltConn = new LanguageToolConnector();
            this.ltConn.initialize(targetLocale, sourceLocale, params.getServerURL(), params.getLtBilingualMode());
        }
        this.termChecker = null;
        if (params.getCheckTerms()) {
            this.termChecker = new TermChecker();
            SimpleTB ta = new SimpleTB(this.srcLoc, this.trgLoc);
            ta.guessAndImport(new File(params.getTermsPath()));
            this.termChecker.initialize(ta, this.srcLoc, this.trgLoc, params.getStringMode(), params.getBetweenCodes());
        }
        this.blacklistChecker = null;
        if (params.getCheckBlacklist()) {
            this.blacklistChecker = new BlacklistChecker();
            LocaleId termsLocale = params.getBlacklistSrc() ? this.srcLoc : this.trgLoc;
            BlacklistTB ta = new BlacklistTB(termsLocale);
            if (params.getBlacklistStream() != null) {
                ta.loadBlacklistStream(params.getBlacklistStream());
            } else {
                ta.guessAndImport(new File(params.getBlacklistPath()));
            }
            this.blacklistChecker.initialize(ta, termsLocale);
        }
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        this.currentDocId = new File(sd.getName()).toURI();
        this.currentSubDocId = null;
        super.processStartDocument(sd, sigList);
        this.generalChecker.processStartDocument(sd, sigList);
        this.lengthChecker.processStartDocument(sd, sigList);
        this.inlineCodesChecker.processStartDocument(sd, sigList);
        this.patternsChecker.processStartDocument(sd, sigList);
        this.charactersChecker.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        this.currentSubDocId = ssd.getName();
        if (this.currentSubDocId == null) {
            this.currentSubDocId = ssd.getId();
        }
        super.processStartSubDocument(ssd);
        this.generalChecker.processStartSubDocument(ssd);
        this.lengthChecker.processStartSubDocument(ssd);
        this.inlineCodesChecker.processStartSubDocument(ssd);
        this.patternsChecker.processStartSubDocument(ssd);
        this.charactersChecker.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        Property prop;
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.trgLoc);
        this.harvestExistingAnnotations(srcCont, tu, false);
        this.harvestExistingAnnotations(trgCont, tu, true);
        if (this.params.getScope() != 0 && ((prop = trgCont.getProperty("approved")) != null && prop.getValue().equals("yes") ? this.params.getScope() == 2 : this.params.getScope() == 1)) {
            return;
        }
        this.generalChecker.processTextUnit(tu);
        this.lengthChecker.processTextUnit(tu);
        this.inlineCodesChecker.processTextUnit(tu);
        this.patternsChecker.processTextUnit(tu);
        this.charactersChecker.processTextUnit(tu);
        if (trgCont == null) {
            return;
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        Property prop2 = trgCont.getProperty("hashiddentext");
        if (prop2 != null) {
            try (Scanner scan = new Scanner(prop2.getValue());){
                scan.useDelimiter(";");
                TextFragment tf = trgCont.getUnSegmentedContentCopy();
                int start = TextFragment.fromFragmentToString((TextFragment)tf, (int)scan.nextInt());
                int end = TextFragment.fromFragmentToString((TextFragment)tf, (int)scan.nextInt());
                this.addAnnotationAndReportIssue(IssueType.SUSPECT_PATTERN, tu, trgCont, null, "Target content has at least one hidden part.", 0, -1, start, end, 100.0, srcCont.toString(), trgCont.toString(), null);
            }
        }
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg = trgSegs.get(srcSeg.getId());
            if (this.termChecker != null && this.termChecker.verify(this.currentDocId, this.currentSubDocId, tu, srcSeg, trgSeg) > 0) {
                for (Issue issue : this.termChecker.getIssues()) {
                    this.addAnnotationAndReportIssue(issue.getIssueType(), tu, srcCont, issue.getSegId(), issue.getMessage(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), issue.getSeverity(), srcSeg.toString(), trgSeg.toString(), issue.getCodes());
                }
            }
            if (this.blacklistChecker != null) {
                if (this.blacklistChecker.verify(this.currentDocId, this.currentSubDocId, tu, trgSeg, this.params.getAllowBlacklistSub(), false) > 0) {
                    for (Issue issue : this.blacklistChecker.getIssues()) {
                        this.addAnnotationAndReportIssue(issue.getIssueType(), tu, srcCont, issue.getSegId(), issue.getMessage(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), issue.getSeverity(), srcSeg.toString(), trgSeg.toString(), issue.getCodes());
                    }
                }
                if (this.params.getBlacklistSrc() && this.blacklistChecker.verify(this.currentDocId, this.currentSubDocId, tu, srcSeg, this.params.getAllowBlacklistSub(), true) > 0) {
                    for (Issue issue : this.blacklistChecker.getIssues()) {
                        this.addAnnotationAndReportIssue(issue.getIssueType(), tu, srcCont, issue.getSegId(), issue.getMessage(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), issue.getSeverity(), srcSeg.toString(), trgSeg.toString(), issue.getCodes());
                    }
                }
            }
            if (this.ltConn == null || this.ltConn.checkSegment(this.currentDocId, this.currentSubDocId, srcSeg, trgSeg, tu) <= 0) continue;
            for (Issue issue : this.ltConn.getIssues()) {
                this.addAnnotationAndReportIssue(issue.getIssueType(), tu, srcCont, issue.getSegId(), issue.getMessage(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), issue.getSeverity(), srcSeg.toString(), trgSeg.toString(), issue.getCodes(), issue.getString("lqiType"));
                if (issue.getSourceEnd() != -99) continue;
                this.ltConn = null;
            }
        }
        this.setAnnotationIds(srcCont, trgCont);
    }

    private void harvestExistingAnnotations(TextContainer tc, ITextUnit tu, boolean isTarget) {
        if (tc == null) {
            return;
        }
        GenericAnnotations anns = (GenericAnnotations)tc.getAnnotation(GenericAnnotations.class);
        if (anns == null) {
            return;
        }
        List list = anns.getAnnotations("its-lqi");
        for (GenericAnnotation ann : list) {
            IssueAnnotation issue = ann instanceof IssueAnnotation ? (IssueAnnotation)ann : new IssueAnnotation(ann);
            this.addAnnotationAndReportIssue(issue.getIssueType(), tu, tc, issue.getSegId(), issue.getComment(), issue.getSourceStart(), issue.getSourceEnd(), issue.getTargetStart(), issue.getTargetEnd(), Double.valueOf(issue.getSeverity()).intValue(), isTarget ? "" : tc.toString(), isTarget ? tc.toString() : "", issue.getCodesAsList());
        }
    }
}

