/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.virtualdb.jdbc.h2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.virtualdb.IVDocument;
import net.sf.okapi.virtualdb.IVItem;
import net.sf.okapi.virtualdb.IVTextUnit;
import net.sf.okapi.virtualdb.KeyAndSegId;
import net.sf.okapi.virtualdb.jdbc.IDBAccess;
import net.sf.okapi.virtualdb.jdbc.Repository;
import net.sf.okapi.virtualdb.jdbc.h2.H2Access;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class H2ImplementationTest {
    private FilterConfigurationMapper fcMapper;
    private LocaleId locEN = LocaleId.fromBCP47((String)"en");
    private LocaleId locFR = LocaleId.fromBCP47((String)"fr");
    private FileLocation location = FileLocation.fromClass(this.getClass()).out("/");

    @Test
    public void testExtraData1() throws IOException {
        Repository repo = new Repository((IDBAccess)new H2Access(this.location.toString(), null));
        repo.create("myRepo");
        String data = "this is a test";
        byte[] buffer = data.getBytes("UTF-8");
        repo.saveExtraData1((InputStream)new ByteArrayInputStream(buffer));
        ByteArrayInputStream bais = (ByteArrayInputStream)repo.loadExtraData1();
        byte[] buf = new byte[bais.available()];
        bais.read(buf);
        String out = new String(buf);
        Assert.assertEquals((Object)data, (Object)out);
        bais.close();
        repo.close();
    }

    @Test
    public void testItemNavigation() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        Repository repo = new Repository((IDBAccess)new H2Access(this.location.toString(), (IFilterConfigurationMapper)this.fcMapper));
        repo.create("myRepo");
        RawDocument rd = new RawDocument(this.location.in("/allItems.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        IVDocument vdoc = repo.getFirstDocument();
        IVItem item1 = vdoc.getFirstChild();
        Assert.assertEquals((Object)IVItem.ItemType.SUB_DOCUMENT, (Object)item1.getItemType());
        Assert.assertEquals((Object)"subdoc1", (Object)item1.getName());
        Assert.assertEquals((Object)IVItem.ItemType.DOCUMENT, (Object)item1.getParent().getItemType());
        IVItem item2 = item1.getNextSibling();
        Assert.assertEquals((Object)IVItem.ItemType.SUB_DOCUMENT, (Object)item2.getItemType());
        Assert.assertEquals((Object)"subdoc2", (Object)item2.getName());
        Assert.assertEquals((Object)IVItem.ItemType.DOCUMENT, (Object)item2.getParent().getItemType());
        IVItem item3 = item2.getNextSibling();
        Assert.assertEquals((Object)IVItem.ItemType.SUB_DOCUMENT, (Object)item3.getItemType());
        Assert.assertEquals((Object)"subdoc3", (Object)item3.getName());
        Assert.assertEquals((Object)IVItem.ItemType.DOCUMENT, (Object)item3.getParent().getItemType());
        item2 = item1.getFirstChild();
        Assert.assertEquals((Object)IVItem.ItemType.TEXT_UNIT, (Object)item2.getItemType());
        Assert.assertEquals((Object)"f1-sd1-1", (Object)item2.getName());
        Assert.assertEquals((Object)"subdoc1", (Object)item2.getParent().getName());
        item2 = item2.getNextSibling();
        Assert.assertEquals((Object)IVItem.ItemType.TEXT_UNIT, (Object)item2.getItemType());
        Assert.assertEquals((Object)"f1-sd1-2", (Object)item2.getName());
        Assert.assertEquals((Object)"subdoc1", (Object)item2.getParent().getName());
        item2 = item2.getNextSibling();
        Assert.assertEquals((Object)IVItem.ItemType.GROUP, (Object)item2.getItemType());
        Assert.assertEquals((Object)"f1-sd1-g1", (Object)item2.getName());
        Assert.assertEquals((Object)"subdoc1", (Object)item2.getParent().getName());
        item3 = item2.getFirstChild();
        Assert.assertEquals((Object)IVItem.ItemType.TEXT_UNIT, (Object)item3.getItemType());
        Assert.assertEquals((Object)"f1-sd1-g1-1", (Object)item3.getName());
        Assert.assertEquals((Object)"f1-sd1-g1", (Object)item3.getParent().getName());
        item2 = item2.getNextSibling();
        Assert.assertEquals((Object)IVItem.ItemType.TEXT_UNIT, (Object)item2.getItemType());
        Assert.assertEquals((Object)"f1-sd1-3", (Object)item2.getName());
        Assert.assertEquals((Object)"subdoc1", (Object)item2.getParent().getName());
        item2 = item1.getNextSibling().getFirstChild();
        Assert.assertEquals((Object)IVItem.ItemType.TEXT_UNIT, (Object)item2.getItemType());
        Assert.assertEquals((Object)"f1-sd2-1", (Object)item2.getName());
        Assert.assertEquals((Object)"subdoc2", (Object)item2.getParent().getName());
        item2 = item1.getNextSibling().getNextSibling().getFirstChild();
        Assert.assertEquals((Object)IVItem.ItemType.GROUP, (Object)item2.getItemType());
        Assert.assertEquals((Object)"f1-sd3-g1", (Object)item2.getName());
        Assert.assertEquals((Object)"subdoc3", (Object)item2.getParent().getName());
        item2 = item2.getFirstChild();
        Assert.assertEquals((Object)IVItem.ItemType.GROUP, (Object)item2.getItemType());
        Assert.assertEquals((Object)"f1-sd3-g1-g1", (Object)item2.getName());
        Assert.assertEquals((Object)"f1-sd3-g1", (Object)item2.getParent().getName());
        item2 = item2.getFirstChild();
        Assert.assertEquals((Object)IVItem.ItemType.TEXT_UNIT, (Object)item2.getItemType());
        Assert.assertEquals((Object)"f1-sd3-g1-g1-1", (Object)item2.getName());
        Assert.assertEquals((Object)"f1-sd3-g1-g1", (Object)item2.getParent().getName());
        rd.close();
        repo.close();
    }

    @Test
    public void testDirectNavigation() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        Repository repo = new Repository((IDBAccess)new H2Access(this.location.toString(), (IFilterConfigurationMapper)this.fcMapper));
        repo.create("myRepo");
        RawDocument rd = new RawDocument(this.location.in("/allItems.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        IVDocument vdoc = repo.getFirstDocument();
        IVItem item = vdoc.getFirstChild();
        Assert.assertEquals((Object)"subdoc1", (Object)item.getName());
        Assert.assertEquals((Object)"subdoc2", (Object)item.getNextSibling().getName());
        Assert.assertEquals((Object)"subdoc1", (Object)item.getNextSibling().getPreviousSibling().getName());
        Assert.assertEquals((Object)"subdoc3", (Object)item.getNextSibling().getNextSibling().getName());
        Assert.assertEquals((Object)"f1-sd1-1", (Object)item.getFirstChild().getName());
        Assert.assertEquals((Object)"f1-sd1-2", (Object)item.getFirstChild().getNextSibling().getName());
        Assert.assertEquals((Object)"subdoc1", (Object)item.getFirstChild().getNextSibling().getParent().getName());
        Assert.assertEquals((Object)"f1-sd1-g1", (Object)item.getFirstChild().getNextSibling().getNextSibling().getName());
        Assert.assertEquals((Object)"f1-sd1-2", (Object)item.getFirstChild().getNextSibling().getNextSibling().getPreviousSibling().getName());
        Assert.assertEquals((Object)"f1-sd3-g1-g1-1", (Object)item.getNextSibling().getNextSibling().getFirstChild().getFirstChild().getFirstChild().getName());
        rd.close();
        repo.close();
    }

    @Test
    public void testSameSourceDifferentTarget() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        H2Access acc = new H2Access(this.location.toString(), (IFilterConfigurationMapper)this.fcMapper);
        Repository repo = new Repository((IDBAccess)acc);
        repo.create("myRepo");
        RawDocument rd = new RawDocument(this.location.in("/testWithDup.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        IVDocument vdoc = repo.getFirstDocument();
        List list = acc.getSameSourceWithDifferentTarget();
        Assert.assertEquals((long)2L, (long)list.size());
        long key = ((KeyAndSegId)((List)list.get((int)0)).get((int)0)).key;
        ITextUnit tu = ((IVTextUnit)vdoc.getItem(key)).getTextUnit();
        Assert.assertEquals((Object)"source text", (Object)tu.toString());
        Assert.assertEquals((long)3L, (long)((List)list.get(0)).size());
        key = ((KeyAndSegId)((List)list.get((int)1)).get((int)0)).key;
        tu = ((IVTextUnit)vdoc.getItem(key)).getTextUnit();
        Assert.assertEquals((Object)"source text type 3", (Object)tu.toString());
        Assert.assertEquals((long)2L, (long)((List)list.get(1)).size());
        rd.close();
        repo.close();
    }

    @Test
    public void testSameSourceDifferentTarget_ForSegment() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        H2Access acc = new H2Access(this.location.toString(), (IFilterConfigurationMapper)this.fcMapper);
        Repository repo = new Repository((IDBAccess)acc);
        repo.create("myRepo");
        RawDocument rd = new RawDocument(this.location.in("/testWithDup.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        IVDocument vdoc = repo.getFirstDocument();
        List list = acc.getSegmentsWithSameSourceButDifferentTarget(this.locFR);
        Assert.assertEquals((long)3L, (long)list.size());
        int index = 0;
        KeyAndSegId ksid = (KeyAndSegId)((List)list.get(index)).get(0);
        ITextUnit tu = ((IVTextUnit)vdoc.getItem(ksid.key)).getTextUnit();
        Segment seg = tu.getSource().getSegments().get(ksid.segId);
        Assert.assertEquals((Object)"sourceA", (Object)seg.toString());
        Assert.assertEquals((long)2L, (long)((List)list.get(index)).size());
        index = 1;
        long key = ((KeyAndSegId)((List)list.get((int)index)).get((int)0)).key;
        tu = ((IVTextUnit)vdoc.getItem(key)).getTextUnit();
        Assert.assertEquals((Object)"source text type 3", (Object)tu.toString());
        Assert.assertEquals((long)2L, (long)((List)list.get(index)).size());
        index = 2;
        key = ((KeyAndSegId)((List)list.get((int)index)).get((int)0)).key;
        tu = ((IVTextUnit)vdoc.getItem(key)).getTextUnit();
        Assert.assertEquals((Object)"source text", (Object)tu.toString());
        Assert.assertEquals((long)3L, (long)((List)list.get(index)).size());
        rd.close();
        repo.close();
    }
}

