/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.virtualdb;

import java.util.ArrayList;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.virtualdb.IVDocument;
import net.sf.okapi.virtualdb.IVTextUnit;
import net.sf.okapi.virtualdb.jdbc.IDBAccess;
import net.sf.okapi.virtualdb.jdbc.Repository;
import net.sf.okapi.virtualdb.jdbc.h2.H2Access;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RepositoryTest {
    private FilterConfigurationMapper fcMapper;
    private LocaleId locEN = LocaleId.fromBCP47((String)"en");
    private LocaleId locFR = LocaleId.fromBCP47((String)"fr");
    private String outputDir;
    private FileLocation location = FileLocation.fromClass(RepositoryTest.class).out("/");

    public RepositoryTest() {
        this.outputDir = this.location.asUri().getPath();
    }

    @Test
    public void testImportTwoFiles() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        Repository repo = new Repository((IDBAccess)new H2Access(this.outputDir, (IFilterConfigurationMapper)this.fcMapper));
        repo.create("myRepo");
        RawDocument rd = new RawDocument(this.location.in("/test01.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        rd.close();
        rd = new RawDocument(this.location.in("/test02.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        rd.close();
        rd = new RawDocument(this.location.in("/test03.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        rd.close();
        IVDocument vdoc1 = repo.getFirstDocument();
        IVTextUnit vtu = vdoc1.getTextUnit("1");
        Assert.assertEquals((Object)"Texte de l'attribute", (Object)vtu.getTextUnit().getTarget(this.locFR).toString());
        IVDocument vdoc2 = (IVDocument)vdoc1.getNextSibling();
        vtu = vdoc2.getTextUnit("1");
        Assert.assertNotNull((Object)vtu);
        Assert.assertEquals((Object)"test02 - Texte de l'attribute", (Object)vtu.getTextUnit().getTarget(this.locFR).toString());
        IVDocument vdoc3 = (IVDocument)vdoc2.getNextSibling();
        vtu = vdoc3.getTextUnit("1");
        Assert.assertNotNull((Object)vtu);
        Assert.assertEquals((Object)"test03 - Texte de l'attribute", (Object)vtu.getTextUnit().getTarget(this.locFR).toString());
        repo.removeDocument(vdoc2);
        IVDocument nvdoc1 = repo.getFirstDocument();
        vtu = nvdoc1.getTextUnit("1");
        Assert.assertNotNull((Object)vtu);
        Assert.assertEquals((Object)"Texte de l'attribute", (Object)vtu.getTextUnit().getTarget(this.locFR).toString());
        IVDocument nvdoc2 = (IVDocument)nvdoc1.getNextSibling();
        vtu = nvdoc2.getTextUnit("1");
        Assert.assertNotNull((Object)vtu);
        Assert.assertEquals((Object)"test03 - Texte de l'attribute", (Object)vtu.getTextUnit().getTarget(this.locFR).toString());
        repo.close();
    }

    @Test
    public void testCreate() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        Repository repo = new Repository((IDBAccess)new H2Access(this.outputDir, (IFilterConfigurationMapper)this.fcMapper));
        repo.create("myRepo");
        RawDocument rd = new RawDocument(this.location.in("/test01.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        rd.close();
        ArrayList<IVDocument> docs = new ArrayList<IVDocument>();
        for (IVDocument doc : repo.documents()) {
            docs.add(doc);
        }
        Assert.assertEquals((long)1L, (long)docs.size());
        IVDocument doc = repo.getFirstDocument();
        Assert.assertNotNull((Object)doc);
        ArrayList<IVTextUnit> vtus = new ArrayList<IVTextUnit>();
        for (IVTextUnit vtu : doc.textUnits()) {
            vtus.add(vtu);
        }
        Assert.assertEquals((long)8L, (long)vtus.size());
        ITextUnit tu = ((IVTextUnit)vtus.get(0)).getTextUnit();
        Assert.assertEquals((Object)"1", (Object)tu.getId());
        Assert.assertEquals((Object)"Texte de l'attribute", (Object)tu.getTarget(this.locFR).toString());
        repo.close();
    }

    @Test
    public void testRetrieve() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        Repository repo = new Repository((IDBAccess)new H2Access(this.outputDir, (IFilterConfigurationMapper)this.fcMapper));
        repo.create("myRepo");
        RawDocument rd = new RawDocument(this.location.in("/test01.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        rd.close();
        ArrayList<IVDocument> docs = new ArrayList<IVDocument>();
        for (IVDocument doc : repo.documents()) {
            docs.add(doc);
        }
        Assert.assertEquals((long)1L, (long)docs.size());
        IVDocument doc = repo.getFirstDocument();
        ArrayList<IVTextUnit> vtus = new ArrayList<IVTextUnit>();
        for (IVTextUnit vtu : doc.textUnits()) {
            vtus.add(vtu);
        }
        Assert.assertEquals((long)8L, (long)vtus.size());
        ITextUnit tu = ((IVTextUnit)vtus.get(0)).getTextUnit();
        Assert.assertEquals((Object)"1", (Object)tu.getId());
        Assert.assertEquals((Object)"Texte de l'attribute", (Object)tu.getTarget(this.locFR).toString());
        repo.close();
    }

    @Test
    public void testSaveAndRetrieve() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        Repository repo = new Repository((IDBAccess)new H2Access(this.outputDir, (IFilterConfigurationMapper)this.fcMapper));
        repo.create("myRepo");
        RawDocument rd = new RawDocument(this.location.in("/test01.xlf").asUri(), "UTF-8", this.locEN, this.locFR);
        rd.setFilterConfigId("okf_xliff");
        repo.importDocument(rd);
        rd.close();
        IVDocument doc = repo.getFirstDocument();
        IVTextUnit vtu = (IVTextUnit)doc.getItem("1");
        ITextUnit tu = vtu.getTextUnit();
        Assert.assertEquals((Object)"Texte de l'attribute", (Object)tu.getTarget(this.locFR).toString());
        tu.setTarget(this.locFR, new TextContainer("new target text"));
        vtu.save();
        vtu = (IVTextUnit)doc.getItem("1");
        tu = vtu.getTextUnit();
        Assert.assertEquals((Object)"new target text", (Object)tu.getTarget(this.locFR).toString());
        repo.close();
    }
}

