/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.virtualdb.jdbc.h2;

import java.util.LinkedHashMap;
import java.util.Stack;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.virtualdb.IVItem;
import net.sf.okapi.virtualdb.jdbc.h2.H2Access;
import net.sf.okapi.virtualdb.jdbc.h2.H2Document;
import net.sf.okapi.virtualdb.jdbc.h2.H2Navigator;

public class H2Importer {
    private H2Access db;
    private IFilterConfigurationMapper fcMapper;
    private LinkedHashMap<Long, H2Navigator> items;
    private Stack<H2Navigator> parents;
    private Stack<H2Navigator> prevItems;
    private long docItemKey;
    private H2Navigator prevItem;
    private int level;

    public H2Importer(H2Access db, IFilterConfigurationMapper fcMapper) {
        this.db = db;
        this.fcMapper = fcMapper;
    }

    public long importDocument(RawDocument rd) {
        this.items = new LinkedHashMap();
        this.parents = new Stack();
        this.prevItems = new Stack();
        this.docItemKey = -1L;
        try (IFilter filter = this.fcMapper.createFilter(rd.getFilterConfigId());){
            filter.open(rd);
            while (filter.hasNext()) {
                Event event = filter.next();
                switch (event.getEventType()) {
                    case START_DOCUMENT: {
                        this.processStartDocument((StartDocument)event.getResource());
                        break;
                    }
                    case START_SUBDOCUMENT: {
                        if (this.prevItem.firstChild > -1L || this.prevItem.itemType == IVItem.ItemType.TEXT_UNIT || this.prevItem.itemType == IVItem.ItemType.SUB_DOCUMENT) {
                            this.addSibling(event.getResource(), IVItem.ItemType.SUB_DOCUMENT);
                            break;
                        }
                        this.addChild(event.getResource(), IVItem.ItemType.SUB_DOCUMENT);
                        break;
                    }
                    case START_GROUP: 
                    case START_SUBFILTER: {
                        if (this.prevItem.firstChild > -1L || this.prevItem.itemType == IVItem.ItemType.TEXT_UNIT) {
                            this.addSibling(event.getResource(), IVItem.ItemType.GROUP);
                            break;
                        }
                        this.addChild(event.getResource(), IVItem.ItemType.GROUP);
                        break;
                    }
                    case END_SUBDOCUMENT: 
                    case END_GROUP: 
                    case END_SUBFILTER: {
                        if (this.prevItem.previous != -1L && this.prevItem.itemType != IVItem.ItemType.TEXT_UNIT) break;
                        this.parents.pop();
                        --this.level;
                        this.prevItem = this.prevItems.pop();
                        break;
                    }
                    case TEXT_UNIT: {
                        if (this.prevItem.firstChild > -1L || this.prevItem.itemType == IVItem.ItemType.TEXT_UNIT) {
                            this.addSibling(event.getResource(), IVItem.ItemType.TEXT_UNIT);
                            break;
                        }
                        this.addChild(event.getResource(), IVItem.ItemType.TEXT_UNIT);
                        break;
                    }
                }
            }
            this.db.completeItemsWriting(this.items);
        }
        return this.docItemKey;
    }

    /*
     * WARNING - void declaration
     */
    private void processStartDocument(StartDocument sd) {
        void var2_3;
        Object var2_2 = null;
        for (H2Document h2Document : this.db.documents()) {
        }
        this.docItemKey = this.db.writeResourceData((INameable)sd, IVItem.ItemType.DOCUMENT, -1L);
        this.level = -1;
        H2Navigator item = new H2Navigator(IVItem.ItemType.DOCUMENT, this.docItemKey, -1L, this.level);
        if (var2_3 != null) {
            var2_3.next = item.key;
            item.previous = var2_3.key;
            this.db.saveDocument((H2Document)var2_3);
        }
        this.items.put(item.key, item);
        this.prevItem = item;
    }

    private void addChild(IResource res, IVItem.ItemType type) {
        long key = -1L;
        switch (type) {
            case SUB_DOCUMENT: {
                key = this.db.writeResourceData((INameable)((StartSubDocument)res), type, this.docItemKey);
                break;
            }
            case GROUP: {
                key = this.db.writeResourceData((INameable)((StartGroup)res), type, this.docItemKey);
                break;
            }
            case TEXT_UNIT: {
                key = this.db.writeTextUnitData((ITextUnit)res, this.docItemKey);
                break;
            }
        }
        ++this.level;
        H2Navigator item = new H2Navigator(type, key, this.docItemKey, this.level);
        this.items.put(item.key, item);
        item.parent = this.prevItem.key;
        this.prevItem.firstChild = key;
        this.parents.push(this.prevItem);
        this.prevItems.push(this.prevItem);
        this.prevItem = item;
    }

    private void addSibling(IResource res, IVItem.ItemType type) {
        long key = -1L;
        switch (type) {
            case SUB_DOCUMENT: {
                key = this.db.writeResourceData((INameable)((StartSubDocument)res), type, this.docItemKey);
                break;
            }
            case GROUP: {
                key = this.db.writeResourceData((INameable)((StartGroup)res), type, this.docItemKey);
                break;
            }
            case TEXT_UNIT: {
                key = this.db.writeTextUnitData((ITextUnit)res, this.docItemKey);
                break;
            }
        }
        H2Navigator item = new H2Navigator(type, key, this.docItemKey, this.level);
        this.items.put(item.key, item);
        item.previous = this.prevItem.key;
        item.parent = this.parents.peek().key;
        this.prevItem.next = key;
        this.prevItem = item;
    }
}

