/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.verification.JarLSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateXliffSchema {
    private static final String xliffSchema = "xliff-core-1.2-transitional.xsd";
    private static Validator validator;

    public static boolean validateXliffSchema(URI fileURI) {
        if (validator == null) {
            return true;
        }
        try {
            validator.validate(new StreamSource(new File(fileURI)));
            return true;
        }
        catch (SAXParseException ex) {
            String message = ex.getMessage();
            if (!message.startsWith("Duplicate key value [") || !message.endsWith("] declared for identity constraint of element \"file\".")) {
                String errorString = String.format("XLIFF Validation Error [%d, %d]:\n  %s\n  %s", ex.getLineNumber(), ex.getColumnNumber(), ex.getSystemId(), ex.getMessage());
                throw new OkapiIOException(errorString);
            }
        }
        catch (Exception ex) {
            throw new OkapiIOException("XLIFF Validation Error: " + ex.getMessage());
        }
        return false;
    }

    static {
        try {
            InputStream is = ValidateXliffSchema.class.getResourceAsStream(xliffSchema);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            JarLSResourceResolver jarResolver = new JarLSResourceResolver();
            factory.setResourceResolver(jarResolver);
            Schema schema = factory.newSchema(new StreamSource(is));
            validator = schema.newValidator();
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (validator == null) {
            throw new OkapiIOException("XLIFF Schame Validation : internal error, invalid xliff-core-1.2-transitional.xsd");
        }
    }
}

