/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class PatternItem {
    public static final String SAME = "<same>";
    public String source;
    public String target;
    public boolean enabled;
    public String description;
    public int severity;
    public boolean fromSource;
    private Pattern srcPat;
    private Pattern trgPat;

    public static List<PatternItem> loadFile(String path) {
        ArrayList<PatternItem> list = new ArrayList<PatternItem>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                String[] parts = line.split("\t", -2);
                if (parts.length < 6) {
                    throw new OkapiIOException("Missing one or more tabs in line:\n" + line);
                }
                int severity = 1;
                try {
                    severity = Integer.valueOf(parts[2]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                list.add(new PatternItem(parts[3], parts[4], parts[0].equals("1"), severity, parts[1].equals("1"), parts[5]));
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading pattern file.", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing pattern file.", (Throwable)e);
                }
            }
        }
        return list;
    }

    public static List<PatternItem> saveFile(String path, List<PatternItem> list) {
        String lineBreak = System.getProperty("line.separator");
        try (PrintWriter pr = null;){
            pr = new PrintWriter(path);
            for (PatternItem item : list) {
                pr.write((item.enabled ? "1" : "0") + "\t" + (item.fromSource ? "1" : "0") + "\t" + String.valueOf(item.severity) + "\t" + item.source + "\t" + item.target + "\t" + item.description + lineBreak);
            }
            pr.flush();
        }
        return list;
    }

    public PatternItem(String source, String target, boolean enabled, int severity) {
        this.create(source, target, enabled, severity, true, null);
    }

    public PatternItem(String source, String target, boolean enabled, int severity, String message) {
        this.create(source, target, enabled, severity, true, message);
    }

    public PatternItem(String source, String target, boolean enabled, int severity, boolean fromSource, String message) {
        this.create(source, target, enabled, severity, fromSource, message);
    }

    private void create(String source, String target, boolean enabled, int severity, boolean fromSource, String message) {
        this.source = source;
        this.target = target;
        this.enabled = enabled;
        this.description = message;
        this.severity = severity;
        this.fromSource = fromSource;
    }

    public void compile() {
        if (!this.source.equals(SAME)) {
            this.srcPat = Pattern.compile(this.source);
        }
        if (!this.target.equals(SAME)) {
            this.trgPat = Pattern.compile(this.target);
        }
    }

    public Pattern getSourcePattern() {
        return this.srcPat;
    }

    public Pattern getTargetPattern() {
        return this.trgPat;
    }
}

