/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.verification.BlackTerm;
import net.sf.okapi.lib.verification.BlacklistTB;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;
import net.sf.okapi.lib.verification.QualityCheckSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QualityCheckerTest {
    private QualityCheckSession session;
    private LocaleId locEN = LocaleId.ENGLISH;
    private LocaleId locFR = LocaleId.FRENCH;
    private LocaleId locJA = LocaleId.JAPANESE;
    private LocaleId locTR = LocaleId.fromString((String)"tr");
    private FileLocation location = FileLocation.fromClass(QualityCheckerTest.class);

    @Before
    public void setUp() {
        this.session = new QualityCheckSession();
        this.session.startProcess(this.locEN, this.locFR);
    }

    @Test
    public void testMISSING_TARGETTU() {
        TextUnit tu = new TextUnit("id", "source");
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.MISSING_TARGETTU, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testEMPTY_TARGETSEG() {
        TextUnit tu = new TextUnit("id", "source");
        tu.setTarget(this.locFR, new TextContainer());
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.EMPTY_TARGETSEG, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testEMPTY_SOURCESEG() {
        TextUnit tu = new TextUnit("id", "");
        tu.setTarget(this.locFR, new TextContainer("target"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)2L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.EMPTY_SOURCESEG, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testMISSING_TARGETSEG() {
        TextContainer tc = new TextContainer("srctext1");
        tc.getSegments().append(new Segment("s2", new TextFragment("srctext2")));
        TextUnit tu = new TextUnit("id");
        tu.setSource(tc);
        tu.setTarget(this.locFR, new TextContainer("trgext1"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.MISSING_TARGETSEG, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testEMPTY_TARGETSEG2() {
        TextContainer tc = new TextContainer("srctext1");
        tc.getSegments().append(new Segment("s2", new TextFragment("srctext2")));
        TextUnit tu = new TextUnit("id");
        tu.setSource(tc);
        tc = new TextContainer("trgtext1");
        tc.getSegments().append(new Segment("s2", new TextFragment()));
        tu.setTarget(this.locFR, tc);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.EMPTY_TARGETSEG, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testMISSINGORDIFF_LEADINGWS() {
        TextUnit tu = new TextUnit("id", "  srctext");
        tu.setTarget(this.locFR, new TextContainer("trgext"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.MISSINGORDIFF_LEADINGWS, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testMISSINGORDIFF_TRAILINGWS() {
        TextUnit tu = new TextUnit("id", " srctext ");
        tu.setTarget(this.locFR, new TextContainer(" trgext"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.MISSINGORDIFF_TRAILINGWS, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testEXTRAORDIFF_LEADINGWS() {
        TextUnit tu = new TextUnit("id", "  srctext");
        tu.setTarget(this.locFR, new TextContainer("   trgext"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.EXTRAORDIFF_LEADINGWS, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testEXTRAORDIFF_TRAILINGWS() {
        TextUnit tu = new TextUnit("id", "srctext  ");
        tu.setTarget(this.locFR, new TextContainer("trgtext   "));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.EXTRAORDIFF_TRAILINGWS, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testTARGET_SAME_AS_SOURCE() {
        TextUnit tu = new TextUnit("id", "src text");
        tu.setTarget(this.locFR, new TextContainer("src text"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testTARGET_SAME_AS_SOURCE_withoutWords() {
        TextUnit tu = new TextUnit("id", ":?%$#@#_~`()[]{}=+-");
        tu.setTarget(this.locFR, new TextContainer(":?%$#@#_~`()[]{}=+-"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
    }

    @Test
    public void testTARGET_SAME_AS_SOURCE_WithSameCodes() {
        TextUnit tu = new TextUnit("id", "src text");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code/>");
        tu.setTarget(this.locFR, new TextContainer("src text"));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code/>");
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testTARGET_SAME_AS_SOURCE_WithDiffCodes() {
        TextUnit tu = new TextUnit("id", "src text");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code/>");
        tu.setTarget(this.locFR, new TextContainer("src text"));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<etc/>");
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)2L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.MISSING_CODE, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((Object)IssueType.EXTRA_CODE, (Object)((Issue)issues.get(1)).getIssueType());
    }

    @Test
    public void testTARGET_SAME_AS_SOURCE_WithDiffCodesTurnedOff() {
        TextUnit tu = new TextUnit("id", "src text");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code/>");
        tu.setTarget(this.locFR, new TextContainer("src text"));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<etc/>");
        this.session.getParameters().setTargetSameAsSourceWithCodes(false);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)3L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((Object)IssueType.MISSING_CODE, (Object)((Issue)issues.get(1)).getIssueType());
        Assert.assertEquals((Object)IssueType.EXTRA_CODE, (Object)((Issue)issues.get(2)).getIssueType());
    }

    @Test
    public void testCODE_DIFFERENCE() {
        TextUnit tu = new TextUnit("id", "src ");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code/>");
        tu.setTarget(this.locFR, new TextContainer("trg "));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<CODE />");
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)2L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.MISSING_CODE, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((Object)IssueType.EXTRA_CODE, (Object)((Issue)issues.get(1)).getIssueType());
    }

    @Test
    public void testCODE_OCSEQUENCE() {
        TextUnit tu = new TextUnit("id", "src ");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.OPENING, "b", "<b>");
        tu.getSource().getSegments().get((int)0).text.append("text");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tu.setTarget(this.locFR, new TextContainer("trg "));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append("text");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.OPENING, "b", "<b>");
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.SUSPECT_CODE, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testCODE_OCSequenceNoError() {
        TextUnit tu = new TextUnit("id", "src ");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.OPENING, "i", "<i>");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.CLOSING, "i", "</i>");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.OPENING, "b", "<b>");
        tu.getSource().getSegments().get((int)0).text.append("text");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        tu.setTarget(this.locFR, new TextContainer("trg "));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.OPENING, "b", "<b>");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append("text");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.OPENING, "i", "<i>");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.CLOSING, "i", "</i>");
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
    }

    @Test
    public void testCODE_DIFFERENCE_OrderDiffIsOK() {
        TextUnit tu = new TextUnit("id", "src ");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code1/>");
        tu.getSource().getSegments().get((int)0).text.append(" and ");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code2/>");
        tu.setTarget(this.locFR, new TextContainer("trg "));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code2/>");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(" et ");
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code1/>");
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
    }

    @Test
    public void testTARGET_SAME_AS_SOURCE_WithDifferentCodes() {
        TextUnit tu = new TextUnit("id", "src text");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code/>");
        tu.setTarget(this.locFR, new TextContainer("src text"));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<CODE/>");
        this.session.getParameters().setCodeDifference(false);
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
    }

    @Test
    public void testTARGET_SAME_AS_SOURCE_WithDifferentCodes_CodeInsensitive() {
        TextUnit tu = new TextUnit("id", "src text");
        tu.getSource().getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<code/>");
        tu.setTarget(this.locFR, new TextContainer("src text"));
        tu.getTarget((LocaleId)this.locFR).getSegments().get((int)0).text.append(TextFragment.TagType.PLACEHOLDER, "codeType", "<CODE/>");
        this.session.getParameters().setCodeDifference(false);
        this.session.getParameters().setTargetSameAsSourceWithCodes(false);
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_SAME_AS_SOURCE, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testTARGET_SAME_AS_SOURCE_NoIssue() {
        TextUnit tu = new TextUnit("id", "  \t\n ");
        tu.setTarget(this.locFR, new TextContainer("  \t\n "));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
    }

    @Test
    public void testMISSING_PATTERN() {
        TextUnit tu = new TextUnit("id", "src text !? %s");
        tu.setTarget(this.locFR, new TextContainer("trg text"));
        ArrayList<PatternItem> list = new ArrayList<PatternItem>();
        list.add(new PatternItem("[!\\?]", "<same>", true, 0));
        list.add(new PatternItem("%s", "<same>", true, 2));
        this.session.getParameters().setPatterns(list);
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)3L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.UNEXPECTED_PATTERN, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((long)9L, (long)((Issue)issues.get(0)).getSourceStart());
        Assert.assertEquals((Object)IssueType.UNEXPECTED_PATTERN, (Object)((Issue)issues.get(1)).getIssueType());
        Assert.assertEquals((long)10L, (long)((Issue)issues.get(1)).getSourceStart());
        Assert.assertEquals((Object)IssueType.UNEXPECTED_PATTERN, (Object)((Issue)issues.get(2)).getIssueType());
        Assert.assertEquals((long)12L, (long)((Issue)issues.get(2)).getSourceStart());
    }

    @Test
    public void testMISSING_PATTERN_ForURL() {
        TextUnit tu = new TextUnit("id", "test: http://thisisatest.com.");
        tu.setTarget(this.locFR, new TextContainer("test: http://thisBADtest.com"));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.UNEXPECTED_PATTERN, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((long)6L, (long)((Issue)issues.get(0)).getSourceStart());
        Assert.assertEquals((long)28L, (long)((Issue)issues.get(0)).getSourceEnd());
    }

    @Test
    public void testNoIssues() {
        TextUnit tu = new TextUnit("id", "  Text {with} (123). ");
        tu.setTarget(this.locFR, new TextContainer("  Texte {avec} (123). "));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
    }

    @Test
    public void testMaxLength() {
        this.session.getParameters().setMaxCharLengthBreak(9);
        this.session.getParameters().setMaxCharLengthAbove(149);
        this.session.getParameters().setMaxCharLengthBelow(200);
        TextUnit tu = new TextUnit("id", "abcdefghij");
        tu.setTarget(this.locFR, new TextContainer("123456789012345"));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_LENGTH, (Object)((Issue)issues.get(0)).getIssueType());
        tu = new TextUnit("id", "abcdefghi");
        tu.setTarget(this.locFR, new TextContainer("123456789012345678"));
        this.session.getIssues().clear();
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
        tu.setTarget(this.locFR, new TextContainer("1234567890123456789"));
        this.session.processTextUnit((ITextUnit)tu);
        issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_LENGTH, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testMinLength() {
        this.session.getParameters().setMinCharLengthBreak(9);
        this.session.getParameters().setMinCharLengthAbove(100);
        this.session.getParameters().setMinCharLengthBelow(50);
        TextUnit tu = new TextUnit("id", "abcdefghij");
        tu.setTarget(this.locFR, new TextContainer("123456789"));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_LENGTH, (Object)((Issue)issues.get(0)).getIssueType());
        tu = new TextUnit("id", "abcdefghi");
        tu.setTarget(this.locFR, new TextContainer("12345"));
        this.session.getIssues().clear();
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
        tu.setTarget(this.locFR, new TextContainer("123"));
        this.session.processTextUnit((ITextUnit)tu);
        issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_LENGTH, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testTERMINOLOGY() {
        TextUnit tu = new TextUnit("id", "summer and WINTER");
        tu.setTarget(this.locFR, new TextContainer("\u00e9T\u00e9 et printemps"));
        this.session.getParameters().setCheckTerms(true);
        this.session.getParameters().setTermsPath(this.location.in("/test01.tsv").toString());
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TERMINOLOGY, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testStorageSizeInvalidChar() {
        TextUnit tu = new TextUnit("id", "abc");
        tu.setTarget(this.locFR, new TextContainer("abcXYZ"));
        tu.getTarget(this.locFR).setAnnotation((IAnnotation)new GenericAnnotations(new GenericAnnotation("its-storagesize", new Object[]{"storagesizeSize", 4, "storagesizeLinebreak", "lf", "storagesizeEncoding", "iso-8859-1"})));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_LENGTH, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testStorageSizeUTF8() {
        TextUnit tu = new TextUnit("id", "1234567890\n");
        tu.setTarget(this.locFR, new TextContainer("+1234567890\n"));
        tu.getTarget(this.locFR).setAnnotation((IAnnotation)new GenericAnnotations(new GenericAnnotation("its-storagesize", new Object[]{"storagesizeSize", 12, "storagesizeLinebreak", "crlf", "storagesizeEncoding", "UTF-8"})));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_LENGTH, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testStorageSizeUTF16() {
        TextUnit tu = new TextUnit("id", "1234567890\n");
        tu.setTarget(this.locFR, new TextContainer("+1234567890\n"));
        tu.getTarget(this.locFR).setAnnotation((IAnnotation)new GenericAnnotations(new GenericAnnotation("its-storagesize", new Object[]{"storagesizeSize", 24, "storagesizeLinebreak", "crlf", "storagesizeEncoding", "UTF-16"})));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_LENGTH, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testStorageSizeUTF32() {
        TextUnit tu = new TextUnit("id", "1234567890\n");
        tu.setTarget(this.locFR, new TextContainer("+1234567890\n"));
        tu.getTarget(this.locFR).setAnnotation((IAnnotation)new GenericAnnotations(new GenericAnnotation("its-storagesize", new Object[]{"storagesizeSize", 48, "storagesizeLinebreak", "crlf", "storagesizeEncoding", "UTF-32"})));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.TARGET_LENGTH, (Object)((Issue)issues.get(0)).getIssueType());
    }

    @Test
    public void testAllowedCharacters() {
        TextUnit tu = new TextUnit("id", "Summer and\nspring");
        tu.setTarget(this.locFR, new TextContainer("\u00e9t\u00e9 et printemps"));
        tu.getTarget(this.locFR).setAnnotation((IAnnotation)new GenericAnnotations(new GenericAnnotation("its-allowedchars", new Object[]{"allowedcharsValue", "[a-z ]"})));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.ALLOWED_CHARACTERS, (Object)((Issue)issues.get(0)).getIssueType());
    }

    private static void assertAllGood(List<BlackTerm> res) {
        Assert.assertEquals((long)13L, (long)res.size());
        Assert.assertEquals((Object)"BlackTerm1", (Object)res.get((int)0).text);
        Assert.assertEquals((Object)"BLACKTERM1", (Object)res.get((int)0).searchTerm);
        Assert.assertEquals((Object)"Suggestion1", (Object)res.get((int)0).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)0).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)0).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)0).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTerm2", (Object)res.get((int)1).text);
        Assert.assertEquals((Object)"BLACKTERM2", (Object)res.get((int)1).searchTerm);
        Assert.assertEquals((Object)"", (Object)res.get((int)1).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)1).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)1).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)1).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTerm3", (Object)res.get((int)2).text);
        Assert.assertEquals((Object)"BLACKTERM3", (Object)res.get((int)2).searchTerm);
        Assert.assertEquals((Object)"", (Object)res.get((int)2).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)2).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)2).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)2).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTerm4", (Object)res.get((int)3).text);
        Assert.assertEquals((Object)"BLACKTERM4", (Object)res.get((int)3).searchTerm);
        Assert.assertEquals((Object)"Suggestion4", (Object)res.get((int)3).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)3).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)3).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)3).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTerm5", (Object)res.get((int)4).text);
        Assert.assertEquals((Object)"BlackTerm5", (Object)res.get((int)4).searchTerm);
        Assert.assertEquals((Object)"BLACKTERM5", (Object)res.get((int)4).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)4).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)4).dispSeverity);
        Assert.assertTrue((boolean)res.get((int)4).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"blackterm6", (Object)res.get((int)5).text);
        Assert.assertEquals((Object)"blackterm6", (Object)res.get((int)5).searchTerm);
        Assert.assertEquals((Object)"BlackTerm6", (Object)res.get((int)5).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)5).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)5).dispSeverity);
        Assert.assertTrue((boolean)res.get((int)5).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BLACKTERM7", (Object)res.get((int)6).text);
        Assert.assertEquals((Object)"BLACKTERM7", (Object)res.get((int)6).searchTerm);
        Assert.assertEquals((Object)"Blackterm7", (Object)res.get((int)6).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)6).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)6).dispSeverity);
        Assert.assertTrue((boolean)res.get((int)6).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTerm8", (Object)res.get((int)7).text);
        Assert.assertEquals((Object)"BLACKTERM8", (Object)res.get((int)7).searchTerm);
        Assert.assertEquals((Object)"Suggestion8", (Object)res.get((int)7).suggestion);
        Assert.assertEquals((Object)"Wrong terminology", (Object)res.get((int)7).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)7).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)7).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTerm9", (Object)res.get((int)8).text);
        Assert.assertEquals((Object)"BLACKTERM9", (Object)res.get((int)8).searchTerm);
        Assert.assertEquals((Object)"", (Object)res.get((int)8).suggestion);
        Assert.assertEquals((Object)"Wrong terminology", (Object)res.get((int)8).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)8).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)8).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTermHasSeverity10", (Object)res.get((int)9).text);
        Assert.assertEquals((Object)"BLACKTERMHASSEVERITY10", (Object)res.get((int)9).searchTerm);
        Assert.assertEquals((Object)"", (Object)res.get((int)9).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)9).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)9).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)9).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTermHasSeverity11", (Object)res.get((int)10).text);
        Assert.assertEquals((Object)"BLACKTERMHASSEVERITY11", (Object)res.get((int)10).searchTerm);
        Assert.assertEquals((Object)"", (Object)res.get((int)10).suggestion);
        Assert.assertEquals((Object)"", (Object)res.get((int)10).comment);
        Assert.assertEquals((long)1L, (long)res.get((int)10).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)10).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTermHasSeverity12", (Object)res.get((int)11).text);
        Assert.assertEquals((Object)"BLACKTERMHASSEVERITY12", (Object)res.get((int)11).searchTerm);
        Assert.assertEquals((Object)"Suggestion12", (Object)res.get((int)11).suggestion);
        Assert.assertEquals((Object)"Wrong terminology", (Object)res.get((int)11).comment);
        Assert.assertEquals((long)0L, (long)res.get((int)11).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)11).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"BlackTermHasSeverity13", (Object)res.get((int)12).text);
        Assert.assertEquals((Object)"BLACKTERMHASSEVERITY13", (Object)res.get((int)12).searchTerm);
        Assert.assertEquals((Object)"Suggestion13", (Object)res.get((int)12).suggestion);
        Assert.assertEquals((Object)"Wrong terminology", (Object)res.get((int)12).comment);
        Assert.assertEquals((long)1L, (long)res.get((int)12).dispSeverity);
        Assert.assertFalse((boolean)res.get((int)12).doCaseSensitiveMatch);
    }

    @Test
    public void testImportBlacklist() {
        File file = this.location.in("/black_tsv_simple.txt").asFile();
        BlacklistTB tb = new BlacklistTB();
        tb.guessAndImport(file);
        QualityCheckerTest.assertAllGood(tb.getBlacklistStrings());
    }

    @Test
    public void testImportBlacklistForLocale_EN() {
        File file = this.location.in("/black_tsv_simple.txt").asFile();
        BlacklistTB tb = new BlacklistTB(this.locEN);
        tb.guessAndImport(file);
        QualityCheckerTest.assertAllGood(tb.getBlacklistStrings());
    }

    @Test
    public void testLoadBlacklist() {
        String content = "BlackTerm1\tSuggestion1\nBlackTerm2\t\nBlackTerm3\t\nBlackTerm4\tSuggestion4\nBlackTerm5\tBLACKTERM5\nblackterm6\tBlackTerm6\nBLACKTERM7\tBlackterm7\nBlackTerm8\tSuggestion8\tWrong terminology\nBlackTerm9\t\tWrong terminology\nBlackTermHasSeverity10\t\t\t0\nBlackTermHasSeverity11\t\t\t1\nBlackTermHasSeverity12\tSuggestion12\tWrong terminology\t0\nBlackTermHasSeverity13\tSuggestion13\tWrong terminology\t1";
        BlacklistTB tb = new BlacklistTB();
        tb.loadBlacklistStream((InputStream)new ByteArrayInputStream("BlackTerm1\tSuggestion1\nBlackTerm2\t\nBlackTerm3\t\nBlackTerm4\tSuggestion4\nBlackTerm5\tBLACKTERM5\nblackterm6\tBlackTerm6\nBLACKTERM7\tBlackterm7\nBlackTerm8\tSuggestion8\tWrong terminology\nBlackTerm9\t\tWrong terminology\nBlackTermHasSeverity10\t\t\t0\nBlackTermHasSeverity11\t\t\t1\nBlackTermHasSeverity12\tSuggestion12\tWrong terminology\t0\nBlackTermHasSeverity13\tSuggestion13\tWrong terminology\t1".getBytes(StandardCharsets.UTF_8)));
        QualityCheckerTest.assertAllGood(tb.getBlacklistStrings());
    }

    @Test
    public void testLoadBlacklistForLocale_EN() {
        String content = "Item1\titem1\nItem2\t\u0131tem2\n\u0130tem3\titem3\n\u0131tem4\tItem4\nitem5\tItem5\nitem6\t\u0130tem6\n\u0131tem7\t\u0130tem7\n\u0130TEM8\t\u0130tem8";
        BlacklistTB tb = new BlacklistTB(this.locEN);
        tb.loadBlacklistStream((InputStream)new ByteArrayInputStream("Item1\titem1\nItem2\t\u0131tem2\n\u0130tem3\titem3\n\u0131tem4\tItem4\nitem5\tItem5\nitem6\t\u0130tem6\n\u0131tem7\t\u0130tem7\n\u0130TEM8\t\u0130tem8".getBytes(StandardCharsets.UTF_8)));
        List res = tb.getBlacklistStrings();
        Assert.assertEquals((long)8L, (long)res.size());
        Assert.assertEquals((Object)"Item1", (Object)((BlackTerm)res.get((int)0)).text);
        Assert.assertEquals((Object)"Item1", (Object)((BlackTerm)res.get((int)0)).searchTerm);
        Assert.assertEquals((Object)"item1", (Object)((BlackTerm)res.get((int)0)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)0)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"Item2", (Object)((BlackTerm)res.get((int)1)).text);
        Assert.assertEquals((Object)"Item2", (Object)((BlackTerm)res.get((int)1)).searchTerm);
        Assert.assertEquals((Object)"\u0131tem2", (Object)((BlackTerm)res.get((int)1)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)1)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"\u0130tem3", (Object)((BlackTerm)res.get((int)2)).text);
        Assert.assertEquals((Object)"\u0130TEM3", (Object)((BlackTerm)res.get((int)2)).searchTerm);
        Assert.assertEquals((Object)"item3", (Object)((BlackTerm)res.get((int)2)).suggestion);
        Assert.assertFalse((boolean)((BlackTerm)res.get((int)2)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"\u0131tem4", (Object)((BlackTerm)res.get((int)3)).text);
        Assert.assertEquals((Object)"\u0131tem4", (Object)((BlackTerm)res.get((int)3)).searchTerm);
        Assert.assertEquals((Object)"Item4", (Object)((BlackTerm)res.get((int)3)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)3)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"item5", (Object)((BlackTerm)res.get((int)4)).text);
        Assert.assertEquals((Object)"item5", (Object)((BlackTerm)res.get((int)4)).searchTerm);
        Assert.assertEquals((Object)"Item5", (Object)((BlackTerm)res.get((int)4)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)4)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"item6", (Object)((BlackTerm)res.get((int)5)).text);
        Assert.assertEquals((Object)"ITEM6", (Object)((BlackTerm)res.get((int)5)).searchTerm);
        Assert.assertEquals((Object)"\u0130tem6", (Object)((BlackTerm)res.get((int)5)).suggestion);
        Assert.assertFalse((boolean)((BlackTerm)res.get((int)5)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"\u0131tem7", (Object)((BlackTerm)res.get((int)6)).text);
        Assert.assertEquals((Object)"ITEM7", (Object)((BlackTerm)res.get((int)6)).searchTerm);
        Assert.assertEquals((Object)"\u0130tem7", (Object)((BlackTerm)res.get((int)6)).suggestion);
        Assert.assertFalse((boolean)((BlackTerm)res.get((int)6)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"\u0130TEM8", (Object)((BlackTerm)res.get((int)7)).text);
        Assert.assertEquals((Object)"\u0130TEM8", (Object)((BlackTerm)res.get((int)7)).searchTerm);
        Assert.assertEquals((Object)"\u0130tem8", (Object)((BlackTerm)res.get((int)7)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)7)).doCaseSensitiveMatch);
    }

    @Test
    public void testLoadBlacklistForLocale_TR() {
        String content = "Item1\titem1\nItem2\t\u0131tem2\n\u0130tem3\titem3\n\u0131tem4\tItem4\nitem5\tItem5\nitem6\t\u0130tem6\n\u0131tem7\t\u0130tem7\n\u0130TEM8\t\u0130tem8";
        BlacklistTB tb = new BlacklistTB(this.locTR);
        tb.loadBlacklistStream((InputStream)new ByteArrayInputStream("Item1\titem1\nItem2\t\u0131tem2\n\u0130tem3\titem3\n\u0131tem4\tItem4\nitem5\tItem5\nitem6\t\u0130tem6\n\u0131tem7\t\u0130tem7\n\u0130TEM8\t\u0130tem8".getBytes(StandardCharsets.UTF_8)));
        List res = tb.getBlacklistStrings();
        Assert.assertEquals((long)8L, (long)res.size());
        Assert.assertEquals((Object)"Item1", (Object)((BlackTerm)res.get((int)0)).text);
        Assert.assertEquals((Object)"ITEM1", (Object)((BlackTerm)res.get((int)0)).searchTerm);
        Assert.assertEquals((Object)"item1", (Object)((BlackTerm)res.get((int)0)).suggestion);
        Assert.assertFalse((boolean)((BlackTerm)res.get((int)0)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"Item2", (Object)((BlackTerm)res.get((int)1)).text);
        Assert.assertEquals((Object)"Item2", (Object)((BlackTerm)res.get((int)1)).searchTerm);
        Assert.assertEquals((Object)"\u0131tem2", (Object)((BlackTerm)res.get((int)1)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)1)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"\u0130tem3", (Object)((BlackTerm)res.get((int)2)).text);
        Assert.assertEquals((Object)"\u0130tem3", (Object)((BlackTerm)res.get((int)2)).searchTerm);
        Assert.assertEquals((Object)"item3", (Object)((BlackTerm)res.get((int)2)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)2)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"\u0131tem4", (Object)((BlackTerm)res.get((int)3)).text);
        Assert.assertEquals((Object)"\u0131tem4", (Object)((BlackTerm)res.get((int)3)).searchTerm);
        Assert.assertEquals((Object)"Item4", (Object)((BlackTerm)res.get((int)3)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)3)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"item5", (Object)((BlackTerm)res.get((int)4)).text);
        Assert.assertEquals((Object)"\u0130TEM5", (Object)((BlackTerm)res.get((int)4)).searchTerm);
        Assert.assertEquals((Object)"Item5", (Object)((BlackTerm)res.get((int)4)).suggestion);
        Assert.assertFalse((boolean)((BlackTerm)res.get((int)4)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"item6", (Object)((BlackTerm)res.get((int)5)).text);
        Assert.assertEquals((Object)"item6", (Object)((BlackTerm)res.get((int)5)).searchTerm);
        Assert.assertEquals((Object)"\u0130tem6", (Object)((BlackTerm)res.get((int)5)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)5)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"\u0131tem7", (Object)((BlackTerm)res.get((int)6)).text);
        Assert.assertEquals((Object)"ITEM7", (Object)((BlackTerm)res.get((int)6)).searchTerm);
        Assert.assertEquals((Object)"\u0130tem7", (Object)((BlackTerm)res.get((int)6)).suggestion);
        Assert.assertFalse((boolean)((BlackTerm)res.get((int)6)).doCaseSensitiveMatch);
        Assert.assertEquals((Object)"\u0130TEM8", (Object)((BlackTerm)res.get((int)7)).text);
        Assert.assertEquals((Object)"\u0130TEM8", (Object)((BlackTerm)res.get((int)7)).searchTerm);
        Assert.assertEquals((Object)"\u0130tem8", (Object)((BlackTerm)res.get((int)7)).suggestion);
        Assert.assertTrue((boolean)((BlackTerm)res.get((int)7)).doCaseSensitiveMatch);
    }

    @Test
    public void testBlacklistChecker() {
        String inPath = this.location.in("/black_tsv_simple.txt").toString();
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setblacklistPath(inPath);
        this.verifyBlacklistChecker_Target();
    }

    @Test
    public void testBlacklistCheckerWithStream() {
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        File file = this.location.in("/black_tsv_simple.txt").asFile();
        try {
            params.setBlacklistStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occured.");
        }
        this.verifyBlacklistChecker_Target();
    }

    private void verifyBlacklistChecker_Target() {
        TextUnit tu = new TextUnit("id", "Srcwrd srcwrd srcwrd srcwrd");
        tu.setTarget(this.locFR, new TextContainer("BlackTerm1 followed by BlackTerm1"));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)2L, (long)issues.size());
    }

    @Test
    public void testBlacklistChecker_CaseSensitive() {
        String inPath = this.location.in("/black_tsv_simple.txt").toString();
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setblacklistPath(inPath);
        this.verifyBlacklistChecker_Target_CaseSensitive();
    }

    @Test
    public void testBlacklistCheckerWithStream_CaseSensitive() {
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        File file = this.location.in("/black_tsv_simple.txt").asFile();
        try {
            params.setBlacklistStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occured.");
        }
        this.verifyBlacklistChecker_Target_CaseSensitive();
    }

    private void verifyBlacklistChecker_Target_CaseSensitive() {
        TextUnit tu = new TextUnit("id", "Srcwrd srcwrd srcwrd srcwrd srcwrd srcwrd.");
        tu.setTarget(this.locFR, new TextContainer("BlackTerm1 BLACKTerm1 BlackTerm5 BLACKTerm5 blackterm6 blackterm7."));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)4L, (long)issues.size());
    }

    @Test
    public void testBlacklistChecker_DispSeverity() {
        String inPath = this.location.in("/black_tsv_simple.txt").toString();
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setblacklistPath(inPath);
        this.verifyBlacklistChecker_Target_DispSeverity();
    }

    @Test
    public void testBlacklistCheckerWithStream_DispSeverity() {
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        File file = this.location.in("/black_tsv_simple.txt").asFile();
        try {
            params.setBlacklistStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occured.");
        }
        this.verifyBlacklistChecker_Target_DispSeverity();
    }

    private void verifyBlacklistChecker_Target_DispSeverity() {
        TextUnit tu = new TextUnit("id", "Srcwrd srcwrd srcwrd srcwrd srcwrd srcwrd srcwrd srcwrd srcwrd.");
        tu.setTarget(this.locFR, new TextContainer("BlackTermHasSeverity10 BlackTermHasSeverity11 BlackTermHasSeverity12 BlackTermHasSeverity13"));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)4L, (long)issues.size());
        Assert.assertEquals((long)0L, (long)((Issue)issues.get(0)).getDisplaySeverity());
        Assert.assertEquals((long)1L, (long)((Issue)issues.get(1)).getDisplaySeverity());
        Assert.assertEquals((long)0L, (long)((Issue)issues.get(2)).getDisplaySeverity());
        Assert.assertEquals((long)1L, (long)((Issue)issues.get(3)).getDisplaySeverity());
    }

    @Test
    public void testBlacklistChecker_JA() {
        String inPath = this.location.in("/black_tsv_simple_JA.txt").toString();
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setAllowBlacklistSub(true);
        params.setblacklistPath(inPath);
        this.verifyBlacklistChecker_Target_JA();
    }

    @Test
    public void testBlacklistCheckerWithTermList_JA() {
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setAllowBlacklistSub(true);
        File file = this.location.in("/black_tsv_simple_JA.txt").asFile();
        try {
            params.setBlacklistStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occured.");
        }
        this.verifyBlacklistChecker_Target_JA();
    }

    private void verifyBlacklistChecker_Target_JA() {
        TextUnit tu = new TextUnit("id", "Srcwrd srcwrd srcwrd srcwrd");
        tu.setTarget(this.locJA, new TextContainer("\u79c1\u306f\u3042\u306a\u305f\u3060\u3051\u3092\u611b\u3057\u3066\u3044\u307e\u3059\u3002"));
        this.session.startProcess(this.locEN, this.locJA);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
    }

    @Test
    public void testBlacklistChecker_Src() {
        String inPath = this.location.in("/black_tsv_simple_JA.txt").toString();
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setAllowBlacklistSub(true);
        params.setBlacklistSrc(true);
        params.setblacklistPath(inPath);
        this.verifyBlacklistChecker_Src();
    }

    @Test
    public void testBlacklistCheckerWithTermList_Src() {
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setAllowBlacklistSub(true);
        params.setBlacklistSrc(true);
        File file = this.location.in("/black_tsv_simple_JA.txt").asFile();
        try {
            params.setBlacklistStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occured.");
        }
        this.verifyBlacklistChecker_Src();
    }

    private void verifyBlacklistChecker_Src() {
        TextUnit tu = new TextUnit("id", "\u79c1\u306f\u3042\u306a\u305f\u3060\u3051\u3092\u611b\u3057\u3066\u3044\u307e\u3059\u3002");
        tu.setTarget(this.locJA, new TextContainer("I love you only."));
        this.session.startProcess(this.locEN, this.locJA);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
    }

    @Test
    public void testSimpleWithCode() {
        String inPath = this.location.in("/black_tsv_simple.txt").toString();
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setblacklistPath(inPath);
        TextFragment srcTf1 = new TextFragment();
        srcTf1.append("Source text ");
        srcTf1.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf1.append("text");
        srcTf1.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf1.append(" text ");
        srcTf1.append(TextFragment.TagType.OPENING, "span", "<span>");
        srcTf1.append(TextFragment.TagType.OPENING, "bold", "<b>");
        srcTf1.append("text");
        srcTf1.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        srcTf1.append(" text");
        srcTf1.append(TextFragment.TagType.CLOSING, "span", "</span>");
        srcTf1.append(".");
        TextFragment trgTf1 = new TextFragment();
        trgTf1.append("Target text ");
        trgTf1.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf1.append("BlackTerm1");
        trgTf1.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf1.append(" text ");
        trgTf1.append(TextFragment.TagType.OPENING, "span", "<span>");
        trgTf1.append(TextFragment.TagType.OPENING, "bold", "<b>");
        trgTf1.append("BlackTerm1");
        trgTf1.append(TextFragment.TagType.CLOSING, "bold", "</b>");
        trgTf1.append(" text");
        trgTf1.append(TextFragment.TagType.CLOSING, "span", "</span>");
        trgTf1.append(".");
        TextUnit tu = new TextUnit("id");
        tu.setSourceContent(srcTf1);
        tu.setTargetContent(this.locFR, trgTf1);
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)2L, (long)issues.size());
        Assert.assertEquals((long)15L, (long)((Issue)issues.get(0)).getTargetStart());
        Assert.assertEquals((long)25L, (long)((Issue)issues.get(0)).getTargetEnd());
        Assert.assertEquals((long)44L, (long)((Issue)issues.get(1)).getTargetStart());
        Assert.assertEquals((long)54L, (long)((Issue)issues.get(1)).getTargetEnd());
    }

    @Test
    public void testBlacklistWithCode() {
        String inPath = this.location.in("/black_tsv_simple.txt").toString();
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setblacklistPath(inPath);
        this.verifyBlacklistWithCode();
    }

    @Test
    public void testBlacklistWithCodeWithTermList() {
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        File file = this.location.in("/black_tsv_simple.txt").asFile();
        try {
            params.setBlacklistStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occured.");
        }
        this.verifyBlacklistWithCode();
    }

    private void verifyBlacklistWithCode() {
        TextFragment srcTf1 = new TextFragment();
        srcTf1.append("I like source on my pasta.");
        TextFragment trgTf1 = new TextFragment();
        trgTf1.append("Texte de l'attribute avec BlackTerm4.");
        TextFragment srcTf2 = new TextFragment();
        srcTf2.append("Source ");
        srcTf2.append(TextFragment.TagType.OPENING, "span", "<span>");
        srcTf2.append("sentence");
        srcTf2.append(TextFragment.TagType.CLOSING, "span", "</span>");
        srcTf2.append(" with words.");
        TextFragment trgTf2 = new TextFragment();
        trgTf2.append("Target ");
        trgTf2.append(TextFragment.TagType.OPENING, "span", "<span>");
        trgTf2.append("BlackTerm1");
        trgTf2.append(TextFragment.TagType.CLOSING, "span", "</span>");
        trgTf2.append(" also with BlackTerm1.");
        TextUnit tu = new TextUnit("id");
        tu.getSource().append((TextPart)new Segment("seg1", srcTf1));
        tu.createTarget(this.locFR, true, 0).append((TextPart)new Segment("seg1", trgTf1));
        tu.getSource().append((TextPart)new Segment("seg2", srcTf2));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg2", trgTf2));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)3L, (long)issues.size());
        Assert.assertEquals((Object)"Texte de l'attribute avec BlackTerm4.", (Object)((Issue)issues.get(0)).getTarget());
        Assert.assertEquals((Object)"Target <span>BlackTerm1</span> also with BlackTerm1.", (Object)((Issue)issues.get(1)).getTarget());
        Assert.assertEquals((Object)"Target <span>BlackTerm1</span> also with BlackTerm1.", (Object)((Issue)issues.get(2)).getTarget());
    }

    @Test
    public void testCheckBoundaries() {
        String inPath = this.location.in("/black_tsv_simple.txt").toString();
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        params.setblacklistPath(inPath);
        TextFragment srcTf1 = new TextFragment("Source");
        TextFragment srcTf2 = new TextFragment("This source rules.");
        TextFragment srcTf3 = new TextFragment("Source magic.");
        TextFragment srcTf4 = new TextFragment("My source");
        TextFragment srcTf5 = new TextFragment("Fancy source beans");
        TextFragment srcTf6 = new TextFragment("Special source cocktail");
        TextFragment srcTf7 = new TextFragment("Fresh java.");
        TextFragment srcTf8 = new TextFragment("Coding boogie.");
        TextFragment srcTf9 = new TextFragment("Single malt");
        TextFragment srcTf10 = new TextFragment("GreenTea Latte");
        TextFragment trgTf1 = new TextFragment("BlackTerm1");
        TextFragment trgTf2 = new TextFragment("This BlackTerm1 rules.");
        TextFragment trgTf3 = new TextFragment("BlackTerm1 magic.");
        TextFragment trgTf4 = new TextFragment("My BlackTerm1");
        TextFragment trgTf5 = new TextFragment("Caught RedBlackTerm1 here.");
        TextFragment trgTf6 = new TextFragment("Project BlackTerm1B.");
        TextFragment trgTf7 = new TextFragment("BlackTerm1B here.");
        TextFragment trgTf8 = new TextFragment("BBlackTerm1 boogie.");
        TextFragment trgTf9 = new TextFragment("Single BlackTerm1B");
        TextFragment trgTf10 = new TextFragment("Mocha BBlackTerm1");
        TextUnit tu = new TextUnit("id");
        tu.getSource().append((TextPart)new Segment("seg1", srcTf1));
        tu.createTarget(this.locFR, true, 0).append((TextPart)new Segment("seg1", trgTf1));
        tu.getSource().append((TextPart)new Segment("seg2", srcTf2));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg2", trgTf2));
        tu.getSource().append((TextPart)new Segment("seg3", srcTf3));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg3", trgTf3));
        tu.getSource().append((TextPart)new Segment("seg4", srcTf4));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg4", trgTf4));
        tu.getSource().append((TextPart)new Segment("seg5", srcTf5));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg5", trgTf5));
        tu.getSource().append((TextPart)new Segment("seg6", srcTf6));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg6", trgTf6));
        tu.getSource().append((TextPart)new Segment("seg7", srcTf7));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg7", trgTf7));
        tu.getSource().append((TextPart)new Segment("seg8", srcTf8));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg8", trgTf8));
        tu.getSource().append((TextPart)new Segment("seg9", srcTf9));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg9", trgTf9));
        tu.getSource().append((TextPart)new Segment("seg10", srcTf10));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg10", trgTf10));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)4L, (long)issues.size());
        Assert.assertEquals((Object)"BlackTerm1", (Object)((Issue)issues.get(0)).getTarget());
        Assert.assertEquals((Object)"This BlackTerm1 rules.", (Object)((Issue)issues.get(1)).getTarget());
        Assert.assertEquals((Object)"BlackTerm1 magic.", (Object)((Issue)issues.get(2)).getTarget());
        Assert.assertEquals((Object)"My BlackTerm1", (Object)((Issue)issues.get(3)).getTarget());
    }

    @Test
    public void testCheckBlacklist_fail() {
        Parameters params = this.session.getParameters();
        params.setCheckBlacklist(true);
        TextFragment srcTf1 = new TextFragment("Source");
        TextFragment srcTf2 = new TextFragment("This source rules.");
        TextFragment trgTf1 = new TextFragment("BlackTerm1");
        TextFragment trgTf2 = new TextFragment("This BlackTerm1 rules.");
        TextUnit tu = new TextUnit("id");
        tu.getSource().append((TextPart)new Segment("seg1", srcTf1));
        tu.createTarget(this.locFR, true, 0).append((TextPart)new Segment("seg1", trgTf1));
        tu.getSource().append((TextPart)new Segment("seg2", srcTf2));
        tu.getTarget(this.locFR).append((TextPart)new Segment("seg2", trgTf2));
        try {
            this.session.startProcess(this.locEN, this.locFR);
        }
        catch (OkapiIOException okapiIOException) {
            // empty catch block
        }
    }

    @Test
    public void testLineFeedErrorMessage() {
        Parameters params = this.session.getParameters();
        params.setPatterns(Collections.singletonList(new PatternItem("\\x0a", "<same>", true, 2, true, "Missing line break")));
        TextUnit tu = new TextUnit("id");
        tu.getSource().append((TextPart)new Segment("seg1", new TextFragment("Contains a\nline break")));
        tu.createTarget(this.locFR, true, 0).append((TextPart)new Segment("seg1", new TextFragment("Doesn't contain a line break")));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)"The source part \"\\n\" is not in the target (from rule: Missing line break).", (Object)((Issue)issues.get(0)).getMessage());
    }

    @Test
    public void testCRLFErrorMessage() {
        Parameters params = this.session.getParameters();
        params.setPatterns(Collections.singletonList(new PatternItem("\\x0d\\x0a", "<same>", true, 2, true, "Missing CRLF")));
        TextUnit tu = new TextUnit("id");
        tu.getSource().append((TextPart)new Segment("seg1", new TextFragment("Contains a\r\nline break")));
        tu.createTarget(this.locFR, true, 0).append((TextPart)new Segment("seg1", new TextFragment("Doesn't contain a line break")));
        this.session.startProcess(this.locEN, this.locFR);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)"The source part \"\\r\\n\" is not in the target (from rule: Missing CRLF).", (Object)((Issue)issues.get(0)).getMessage());
    }

    @Test
    public void testRULES_PRIORITYLOW() {
        TextUnit tu = new TextUnit("id", "Srctext: (brackets)");
        tu.setTarget(this.locFR, new TextContainer("Trgtext: (brackets"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.UNEXPECTED_PATTERN, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((long)0L, (long)((Issue)issues.get(0)).getDisplaySeverity());
    }

    @Test
    public void testRULES_PRIORITYMEDIUM() {
        TextUnit tu = new TextUnit("id", "Srctext: foo@bar.com");
        tu.setTarget(this.locFR, new TextContainer("Trgtext: foo@barbar.fr"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.UNEXPECTED_PATTERN, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((long)1L, (long)((Issue)issues.get(0)).getDisplaySeverity());
    }

    @Test
    public void testRULES_PRIORITYHIGH() {
        TextUnit tu = new TextUnit("id", "Srctext: %s");
        tu.setTarget(this.locFR, new TextContainer("Trgtext: %d"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.UNEXPECTED_PATTERN, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((long)2L, (long)((Issue)issues.get(0)).getDisplaySeverity());
    }

    @Test
    public void testDoubleWordsIssue594() {
        String[] testData = new String[]{"hi", "\u0915\u0949\u0932 \u0932\u0949\u0917", "bn", "\u099a\u09be\u09b2\u09be\u09ac\u09c7\u09a8 \u09a8\u09be!", "gu", "\u0ab2\u0abf\u0a82\u0a95 \u0a95\u0ac9\u0aaa\u0abf", "kn", "\u0c92\u0cb3\u0cac\u0cb0\u0cc1\u0cb5 \u0cb5\u0cc0\u0ca1\u0cbf\u0caf\u0cca \u0c95\u0cb0\u0cc6", "mr", "\u0938\u093e\u0907\u0928 \u0907\u0928 \u0915\u0930\u093e", "ne", "\u0921\u094d\u0930\u093e\u0907\u092d\u092c\u093e\u091f \u091f\u093f\u092e", "pa", "\u0a15\u0a32\u0a3f\u0a71\u0a15 \u0a15\u0a40\u0a24\u0a40", "si", "\u0d94\u0db6 \u0d94\u0db6\u0dda"};
        for (int i = 0; i < testData.length; i += 2) {
            LocaleId trgLocale = LocaleId.fromBCP47((String)testData[i]);
            String trgText = testData[i + 1];
            TextUnit tu = new TextUnit("id" + i, "Indic scripts");
            tu.setTarget(trgLocale, new TextContainer(trgText));
            this.session.startProcess(this.locEN, trgLocale);
            this.session.processTextUnit((ITextUnit)tu);
            List issues = this.session.getIssues();
            Assert.assertEquals((long)0L, (long)issues.size());
        }
    }

    @Test
    public void testDoubleWordForReal() {
        LocaleId trgLocale = LocaleId.fromBCP47((String)"hi");
        TextUnit tu = new TextUnit("id", "Double word");
        tu.setTarget(trgLocale, new TextContainer("\u0915\u0949\u0932 \u0932\u0949\u0917  \t\n \u0932\u0949\u0917"));
        this.session.startProcess(this.locEN, trgLocale);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.SUSPECT_PATTERN, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((Object)"Double word: \"\u0932\u0949\u0917\" found in the target.", (Object)((Issue)issues.get(0)).getMessage());
    }

    @Test
    public void testDoubleWordThai() {
        LocaleId trgLocale = LocaleId.fromBCP47((String)"th");
        String doubleWord = "\u0e1b\u0e23\u0e30\u0e15\u0e394\u0e2b\u0e25\u0e31\u0e07";
        String targetString = "\u0e01\u0e33\u0e25\u0e31\u0e07\u0e1b\u0e23\u0e30\u0e15\u0e394\u0e2b\u0e25\u0e31\u0e07\u0e1b\u0e23\u0e30\u0e15\u0e394\u0e2b\u0e25\u0e31\u0e07\u0e1e\u0e23\u0e30";
        TextUnit tu = new TextUnit("id", "Double word");
        tu.setTarget(trgLocale, new TextContainer("\u0e01\u0e33\u0e25\u0e31\u0e07\u0e1b\u0e23\u0e30\u0e15\u0e394\u0e2b\u0e25\u0e31\u0e07\u0e1b\u0e23\u0e30\u0e15\u0e394\u0e2b\u0e25\u0e31\u0e07\u0e1e\u0e23\u0e30"));
        this.session.startProcess(this.locEN, trgLocale);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.SUSPECT_PATTERN, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((Object)"Double word: \"\u0e1b\u0e23\u0e30\u0e15\u0e394\u0e2b\u0e25\u0e31\u0e07\" found in the target.", (Object)((Issue)issues.get(0)).getMessage());
    }

    @Test
    public void testDoubleWordJapanese() {
        LocaleId trgLocale = LocaleId.fromBCP47((String)"ja");
        String doubleWord = "\u516b\u738b\u5b50";
        String targetString = "\u6771\u4eac\u90fd\u516b\u738b\u5b50\u516b\u738b\u5b50\u5e02\u5317\u91ce\u53f0";
        TextUnit tu = new TextUnit("id", "Double word");
        tu.setTarget(trgLocale, new TextContainer("\u6771\u4eac\u90fd\u516b\u738b\u5b50\u516b\u738b\u5b50\u5e02\u5317\u91ce\u53f0"));
        this.session.startProcess(this.locEN, trgLocale);
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)IssueType.SUSPECT_PATTERN, (Object)((Issue)issues.get(0)).getIssueType());
        Assert.assertEquals((Object)"Double word: \"\u516b\u738b\u5b50\" found in the target.", (Object)((Issue)issues.get(0)).getMessage());
    }

    @Test
    public void testDoubleWordExceptions() {
        TextUnit tu = new TextUnit("id", "If you remember");
        tu.setTarget(this.locFR, new TextContainer("si vous vous souvenez"));
        this.session.processTextUnit((ITextUnit)tu);
        List issues = this.session.getIssues();
        Assert.assertEquals((long)0L, (long)issues.size());
    }
}

