/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.net.URI;
import java.net.URL;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.LanguageToolConnector;
import net.sf.okapi.lib.verification.QualityCheckSession;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class LanguageToolTest {
    private QualityCheckSession session;
    private LocaleId locEN = LocaleId.US_ENGLISH;
    private LocaleId locFR = LocaleId.FRENCH;
    LanguageToolConnector ltConn;
    LanguageToolConnector ltConnBilingual;
    String response = "{\"software\":{\"name\":\"LanguageTool\",\"version\":\"3.7-SNAPSHOT\",\"buildDate\":\"2017-02-06 21:01\",\"apiVersion\":\"1\",\"status\":\"\"},\"language\":{\"name\":\"French\",\"code\":\"fr\"},\"matches\":[{\"message\":\"Cette phrase ne commence pas par une majuscule\",\"shortMessage\":\"\",\"replacements\":[{\"value\":\"Mon\"}],\"offset\":0,\"length\":3,\"context\":{\"text\":\"mon texxte\",\"offset\":0,\"length\":3},\"rule\":{\"id\":\"UPPERCASE_SENTENCE_START\",\"description\":\"Absence de majuscule en d\u0413\u00a9but de phrase\",\"issueType\":\"typographical\",\"category\":{\"id\":\"CASING\",\"name\":\"Majuscules\"}}},{\"message\":\"Faute de frappe possible trouv\u0413\u00a9e\",\"shortMessage\":\"Faute de frappe\",\"replacements\":[],\"offset\":4,\"length\":6,\"context\":{\"text\":\"mon texxte\",\"offset\":4,\"length\":6},\"rule\":{\"id\":\"HUNSPELL_NO_SUGGEST_RULE\",\"description\":\"Faute d'orthographe possible (sans suggestions)\",\"issueType\":\"misspelling\",\"category\":{\"id\":\"TYPOS\",\"name\":\"Faute de frappe possible\"}}}]}";

    public LanguageToolTest() {
        this.session = new QualityCheckSession();
        this.session.startProcess(this.locEN, this.locFR);
        String serverUrl = "https://languagetool.org/api/";
        this.ltConn = (LanguageToolConnector)Mockito.spy((Object)new LanguageToolConnector());
        this.ltConn.initialize(this.locFR, this.locEN, serverUrl, this.session.getParameters().getTranslateLTMsg(), false, this.session.getParameters().getLtTranslationSource(), this.session.getParameters().getLtTranslationTarget(), this.session.getParameters().getLtTranslationServiceKey());
        this.ltConnBilingual = (LanguageToolConnector)Mockito.spy((Object)new LanguageToolConnector());
        this.ltConnBilingual.initialize(this.locFR, this.locEN, serverUrl, this.session.getParameters().getTranslateLTMsg(), true, this.session.getParameters().getLtTranslationSource(), this.session.getParameters().getLtTranslationTarget(), this.session.getParameters().getLtTranslationServiceKey());
    }

    @Test
    public void testLanguageTool() throws Exception {
        TextUnit tu = new TextUnit("id", "My text");
        tu.setTarget(this.locFR, new TextContainer("mon texxte"));
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.locFR);
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        ((LanguageToolConnector)Mockito.doReturn((Object)((JSONObject)new JSONParser().parse(this.response))).when((Object)this.ltConn)).sendRequest((URL)Mockito.any(URL.class));
        this.ltConn.checkSegment(new URI(""), "", srcSegs.get(0), trgSegs.get(0), (ITextUnit)tu);
        List issues = this.ltConn.getIssues();
        Assert.assertEquals((long)2L, (long)issues.size());
        Assert.assertEquals((Object)"typographical", (Object)((Issue)issues.get(0)).getITSType());
        Assert.assertEquals((Object)"misspelling", (Object)((Issue)issues.get(1)).getITSType());
    }

    @Test
    public void testLanguageToolBilingual() throws Exception {
        TextUnit tu = new TextUnit("id", "My text");
        tu.setTarget(this.locFR, new TextContainer("mon texxte"));
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.locFR);
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        ((LanguageToolConnector)Mockito.doReturn((Object)((JSONObject)new JSONParser().parse(this.response))).when((Object)this.ltConnBilingual)).sendRequest((URL)Mockito.any(URL.class));
        this.ltConnBilingual.checkSegment(new URI(""), "", srcSegs.get(0), trgSegs.get(0), (ITextUnit)tu);
        List issues = this.ltConnBilingual.getIssues();
        Assert.assertEquals((long)2L, (long)issues.size());
        Assert.assertEquals((Object)"typographical", (Object)((Issue)issues.get(0)).getITSType());
        Assert.assertEquals((Object)"misspelling", (Object)((Issue)issues.get(1)).getITSType());
    }
}

