/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.verification;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import net.sf.okapi.lib.ui.verification.QualityCheckEditor;
import org.eclipse.swt.widgets.Display;

public class Watcher
extends TimerTask {
    private Map<File, Long> stamps;
    private QualityCheckEditor editor;
    private Display display;

    public Watcher(QualityCheckEditor editor, Display display) {
        this.display = display;
        this.editor = editor;
        Map docs = editor.getSession().getDocumentsMap();
        this.stamps = new HashMap<File, Long>();
        for (URI uri : docs.keySet()) {
            File file = new File(uri);
            this.stamps.put(file, file.lastModified());
        }
    }

    @Override
    public void run() {
        if (this.stamps == null) {
            return;
        }
        boolean needRefresh = false;
        for (File file : this.stamps.keySet()) {
            if (this.stamps.get(file).longValue() == file.lastModified()) continue;
            this.stamps.put(file, file.lastModified());
            needRefresh = true;
        }
        if (needRefresh) {
            this.display.syncExec(() -> this.editor.checkAll());
        }
    }
}

