/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.editor;

import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.TextOptions;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TextOptionsPanel
extends Composite {
    private TextOptions opt;
    private StyledText edExample;
    private Button chkBidi;

    public TextOptionsPanel(Composite parent, int flags, String caption, Font fontCopy) {
        super(parent, flags);
        GridLayout layTmp = new GridLayout(4, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        GridData gdTmp = new GridData(768);
        this.setLayoutData(gdTmp);
        Label label = new Label((Composite)this, 0);
        label.setText(caption);
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 4;
        label.setLayoutData((Object)gdTmp);
        Button btFont = UIUtil.createGridButton((Composite)this, (int)8, (String)"Font...", (int)80, (int)1);
        btFont.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextOptionsPanel.this.selectFont();
            }
        });
        Button btTextColor = UIUtil.createGridButton((Composite)this, (int)8, (String)"Text Color...", (int)80, (int)1);
        btTextColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextOptionsPanel.this.selectColor(false);
            }
        });
        Button btBackColor = UIUtil.createGridButton((Composite)this, (int)8, (String)"Background...", (int)80, (int)1);
        btBackColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextOptionsPanel.this.selectColor(true);
            }
        });
        this.chkBidi = new Button((Composite)this, 32);
        this.chkBidi.setText("Right to left script");
        this.chkBidi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextOptionsPanel.this.edExample.setOrientation(TextOptionsPanel.this.chkBidi.getSelection() ? 0x4000000 : 0x2000000);
            }
        });
        this.edExample = new StyledText((Composite)this, 2052);
        this.edExample.setText("Example of text");
        StyleRange sr = new StyleRange();
        sr.background = this.getDisplay().getSystemColor(7);
        sr.start = 11;
        sr.length = 4;
        this.edExample.setStyleRange(sr);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        gdTmp.heightHint = 50;
        this.edExample.setLayoutData((Object)gdTmp);
    }

    protected void finalize() {
        if (this.opt != null) {
            this.opt.dispose();
        }
    }

    public void setOptions(TextOptions options) {
        this.opt = new TextOptions((Device)this.getDisplay(), options);
        this.opt.applyTo(this.edExample);
        this.chkBidi.setSelection(this.opt.isBidirectional);
    }

    public TextOptions getOptions() {
        return new TextOptions((Device)this.getDisplay(), this.opt);
    }

    private void selectColor(boolean background) {
        try {
            ColorDialog dlg = new ColorDialog(this.getShell());
            if (background) {
                dlg.setRGB(this.opt.background.getRGB());
                dlg.setText("Select Background Color");
            } else {
                dlg.setRGB(this.opt.foreground.getRGB());
                dlg.setText("Select Text Color");
            }
            RGB rgb = dlg.open();
            if (rgb == null) {
                return;
            }
            if (background) {
                this.opt.background.dispose();
                this.opt.background = new Color((Device)this.getDisplay(), rgb);
                this.edExample.setBackground(this.opt.background);
            } else {
                this.opt.foreground.dispose();
                this.opt.foreground = new Color((Device)this.getDisplay(), rgb);
                this.edExample.setForeground(this.opt.foreground);
            }
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.getShell(), (String)e.getLocalizedMessage(), null);
        }
    }

    private void selectFont() {
        try {
            FontDialog dlg = new FontDialog(this.getShell());
            dlg.setText("Select Font");
            dlg.setFontList(this.opt.font.getFontData());
            dlg.setRGB(this.opt.foreground.getRGB());
            FontData fontData = dlg.open();
            if (fontData == null) {
                return;
            }
            Font tmp = this.opt.font;
            this.opt.font = new Font((Device)this.getDisplay(), fontData);
            this.edExample.setFont(this.opt.font);
            tmp.dispose();
            this.opt.foreground.dispose();
            this.opt.foreground = new Color((Device)this.getDisplay(), dlg.getRGB());
            this.edExample.setForeground(this.opt.foreground);
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.getShell(), (String)e.getLocalizedMessage(), null);
        }
    }
}

