/*===========================================================================
  Copyright (C) 2011 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
===========================================================================*/

package net.sf.okapi.lib.ui.verification;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

import net.sf.okapi.common.resource.RawDocument;

import org.eclipse.swt.widgets.Display;

public class Watcher extends TimerTask {

	private Map<File, Long> stamps;
	private QualityCheckEditor editor;
	private Display display;
	
	public Watcher (QualityCheckEditor editor,
		Display display)
	{
		this.display = display;
		this.editor = editor;
		Map<URI, RawDocument> docs = editor.getSession().getDocumentsMap();
		stamps = new HashMap<File, Long>();
		for ( URI uri : docs.keySet() ) {
			File file = new File(uri);
			stamps.put(file, file.lastModified());
		}
	}
	
	@Override
	public void run () {
		if ( stamps == null ) return;
		
		boolean needRefresh = false;
		for ( File file : stamps.keySet() ) {
			if ( stamps.get(file) != file.lastModified() ) {
				stamps.put(file, file.lastModified());
				needRefresh = true;
				// Continue to check/update all files, because the refresh will be done for all
			}
		}
		
		if ( needRefresh ) {
			display.syncExec(() -> editor.checkAll());
		}
	}	
}
